/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.NoOpWindowStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.QueryableStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryableStoreProviderTest {
    private final String keyValueStore = "key-value";
    private final String windowStore = "window-store";
    private QueryableStoreProvider storeProvider;
    private HashMap<String, StateStore> globalStateStores;

    @Before
    public void before() {
        StateStoreProviderStub theStoreProvider = new StateStoreProviderStub(false);
        theStoreProvider.addStore("key-value", new NoOpReadOnlyStore());
        theStoreProvider.addStore("window-store", new NoOpWindowStore());
        this.globalStateStores = new HashMap();
        this.storeProvider = new QueryableStoreProvider(Collections.singletonList(theStoreProvider), new GlobalStateStoreProvider(this.globalStateStores));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfKVStoreDoesntExist() {
        this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"not-a-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfWindowStoreDoesntExist() {
        this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"not-a-store", (QueryableStoreType)QueryableStoreTypes.windowStore()));
    }

    @Test
    public void shouldReturnKVStoreWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    @Test
    public void shouldReturnWindowStoreWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForWindowStoreWithDifferentType() {
        this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForKVStoreWithDifferentType() {
        this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.windowStore()));
    }

    @Test
    public void shouldFindGlobalStores() {
        this.globalStateStores.put("global", new NoOpReadOnlyStore());
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"global", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }
}

