/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.MockRecordCollector;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ChangeLoggingWindowBytesStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final MockRecordCollector collector = new MockRecordCollector();
    private final byte[] value = new byte[]{0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value);
    @Mock(type=MockType.NICE)
    private WindowStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContextImpl context;
    private ChangeLoggingWindowBytesStore store;

    @Before
    public void setUp() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, false);
    }

    private void init() {
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.context.recordCollector()).andReturn((Object)this.collector);
        this.inner.init((ProcessorContext)this.context, (StateStore)this.store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldLogPuts() {
        this.inner.put((Object)this.bytesKey, (Object)this.value, 0L);
        EasyMock.expectLastCall();
        this.init();
        this.store.put(this.bytesKey, this.value);
        Bytes key = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)0);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.value));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)0L));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey, 0L, 10L)).andReturn((Object)KeyValueIterators.emptyWindowStoreIterator());
        this.init();
        this.store.fetch((Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.fetch((Object)this.bytesKey, (Object)this.bytesKey, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRetainDuplicatesWhenSet() {
        this.store = new ChangeLoggingWindowBytesStore(this.inner, true);
        this.inner.put((Object)this.bytesKey, (Object)this.value, 0L);
        EasyMock.expectLastCall().times(2);
        this.init();
        this.store.put(this.bytesKey, this.value);
        this.store.put(this.bytesKey, this.value);
        Bytes key1 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)1);
        Bytes key2 = WindowKeySchema.toStoreKeyBinary((Bytes)this.bytesKey, (long)0L, (int)2);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)key1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.value));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)key2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.equalTo((Object)this.value));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).timestamp(), (Matcher)CoreMatchers.equalTo((Object)0L));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }
}

