/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.SingleGroupPartitionGrouperStub;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockInternalTopicManager;
import org.apache.kafka.test.MockKeyValueStoreBuilder;
import org.apache.kafka.test.MockProcessorSupplier;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsPartitionAssignorTest {
    private static final String CONSUMER_1 = "consumer1";
    private static final String CONSUMER_2 = "consumer2";
    private static final String CONSUMER_3 = "consumer3";
    private static final String CONSUMER_4 = "consumer4";
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t1p2 = new TopicPartition("topic1", 2);
    private final TopicPartition t1p3 = new TopicPartition("topic1", 3);
    private final TopicPartition t2p0 = new TopicPartition("topic2", 0);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final TopicPartition t2p2 = new TopicPartition("topic2", 2);
    private final TopicPartition t2p3 = new TopicPartition("topic2", 3);
    private final TopicPartition t3p0 = new TopicPartition("topic3", 0);
    private final TopicPartition t3p1 = new TopicPartition("topic3", 1);
    private final TopicPartition t3p2 = new TopicPartition("topic3", 2);
    private final TopicPartition t3p3 = new TopicPartition("topic3", 3);
    private final TopicPartition t4p0 = new TopicPartition("topic4", 0);
    private final TopicPartition t4p1 = new TopicPartition("topic4", 1);
    private final TopicPartition t4p2 = new TopicPartition("topic4", 2);
    private final TopicPartition t4p3 = new TopicPartition("topic4", 3);
    private final TaskId task0_0 = new TaskId(0, 0);
    private final TaskId task0_1 = new TaskId(0, 1);
    private final TaskId task0_2 = new TaskId(0, 2);
    private final TaskId task0_3 = new TaskId(0, 3);
    private final TaskId task1_0 = new TaskId(1, 0);
    private final TaskId task1_1 = new TaskId(1, 1);
    private final TaskId task1_2 = new TaskId(1, 2);
    private final TaskId task1_3 = new TaskId(1, 3);
    private final TaskId task2_0 = new TaskId(2, 0);
    private final TaskId task2_1 = new TaskId(2, 1);
    private final TaskId task2_2 = new TaskId(2, 2);
    private final TaskId task2_3 = new TaskId(2, 3);
    private final Map<TaskId, Set<TopicPartition>> partitionsForTask = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.task0_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t2p0})), Utils.mkEntry((Object)this.task0_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1, this.t2p1})), Utils.mkEntry((Object)this.task0_2, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p2, this.t2p2})), Utils.mkEntry((Object)this.task0_3, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p3, this.t2p3})), Utils.mkEntry((Object)this.task1_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t3p0})), Utils.mkEntry((Object)this.task1_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t3p1})), Utils.mkEntry((Object)this.task1_2, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t3p2})), Utils.mkEntry((Object)this.task1_3, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t3p3})), Utils.mkEntry((Object)this.task2_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t4p0})), Utils.mkEntry((Object)this.task2_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t4p1})), Utils.mkEntry((Object)this.task2_2, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t4p2})), Utils.mkEntry((Object)this.task2_3, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t4p3}))});
    private final Set<String> allTopics = Utils.mkSet((Object[])new String[]{"topic1", "topic2"});
    private final List<PartitionInfo> infos = Arrays.asList(new PartitionInfo("topic1", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic3", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic3", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic3", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic3", 3, Node.noNode(), new Node[0], new Node[0]));
    private final Set<TaskId> emptyTasks = Collections.emptySet();
    private final Cluster metadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());
    private final StreamsPartitionAssignor partitionAssignor = new StreamsPartitionAssignor();
    private final MockClientSupplier mockClientSupplier = new MockClientSupplier();
    private final InternalTopologyBuilder builder = new InternalTopologyBuilder();
    private final StreamsConfig streamsConfig = new StreamsConfig(this.configProps());
    private static final String USER_END_POINT = "localhost:8080";
    private static final String APPLICATION_ID = "stream-partition-assignor-test";
    private TaskManager taskManager;
    private Map<String, ConsumerPartitionAssignor.Subscription> subscriptions;

    private Map<String, Object> configProps() {
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        configurationMap.put("application.id", APPLICATION_ID);
        configurationMap.put("bootstrap.servers", USER_END_POINT);
        configurationMap.put("__task.manager.instance__", this.taskManager);
        configurationMap.put("__assignment.error.code__", new AtomicInteger());
        return configurationMap;
    }

    private void configurePartitionAssignor(Map<String, Object> props) {
        Map<String, Object> configurationMap = this.configProps();
        configurationMap.putAll(props);
        this.partitionAssignor.configure(configurationMap);
    }

    private void configureDefault() {
        this.createMockTaskManager();
        this.partitionAssignor.configure(this.configProps());
    }

    private void createMockTaskManager() {
        StreamsBuilder builder = new StreamsBuilder();
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(builder.build());
        internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), internalTopologyBuilder);
    }

    private void createMockTaskManager(Set<TaskId> prevTasks, Set<TaskId> cachedTasks, UUID processId, InternalTopologyBuilder builder) {
        this.taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)this.taskManager.adminClient()).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.taskManager.builder()).andReturn((Object)builder).anyTimes();
        EasyMock.expect((Object)this.taskManager.previousRunningTaskIds()).andReturn(prevTasks).anyTimes();
        EasyMock.expect((Object)this.taskManager.activeTaskIds()).andReturn(prevTasks).anyTimes();
        EasyMock.expect((Object)this.taskManager.cachedTasksIds()).andReturn(cachedTasks).anyTimes();
        EasyMock.expect((Object)this.taskManager.processId()).andReturn((Object)processId).anyTimes();
    }

    @Before
    public void setUp() {
        if (this.subscriptions != null) {
            this.subscriptions.clear();
        } else {
            this.subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        }
    }

    private static SubscriptionInfo getInfo(int version, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        return new SubscriptionInfo(version, 6, processId, prevTasks, standbyTasks, userEndPoint);
    }

    private static SubscriptionInfo getInfo(UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        return new SubscriptionInfo(6, 6, processId, prevTasks, standbyTasks, userEndPoint);
    }

    private static SubscriptionInfo getInfo(UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks) {
        return new SubscriptionInfo(6, 6, processId, prevTasks, standbyTasks, USER_END_POINT);
    }

    @Test
    public void shouldUseEagerRebalancingProtocol() {
        this.createMockTaskManager();
        Map<String, Object> props = this.configProps();
        props.put("upgrade.from", "2.3");
        this.partitionAssignor.configure(props);
        Assert.assertEquals((long)1L, (long)this.partitionAssignor.supportedProtocols().size());
        Assert.assertTrue((boolean)this.partitionAssignor.supportedProtocols().contains(ConsumerPartitionAssignor.RebalanceProtocol.EAGER));
        Assert.assertFalse((boolean)this.partitionAssignor.supportedProtocols().contains(ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE));
    }

    @Test
    public void shouldUseCooperativeRebalancingProtocol() {
        this.createMockTaskManager();
        Map<String, Object> props = this.configProps();
        this.partitionAssignor.configure(props);
        Assert.assertEquals((long)2L, (long)this.partitionAssignor.supportedProtocols().size());
        Assert.assertTrue((boolean)this.partitionAssignor.supportedProtocols().contains(ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE));
    }

    @Test
    public void shouldProduceStickyAndBalancedAssignmentWhenNothingChanges() {
        this.configureDefault();
        ClientState state = new ClientState();
        List<TaskId> allTasks = Arrays.asList(this.task0_0, this.task0_1, this.task0_2, this.task0_3, this.task1_0, this.task1_1, this.task1_2, this.task1_3);
        Map previousAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CONSUMER_1, Arrays.asList(this.task0_0, this.task1_1, this.task1_3)), Utils.mkEntry((Object)CONSUMER_2, Arrays.asList(this.task0_3, this.task1_0)), Utils.mkEntry((Object)CONSUMER_3, Arrays.asList(this.task0_1, this.task0_2, this.task1_2))});
        for (Map.Entry entry : previousAssignment.entrySet()) {
            for (TaskId task : (List)entry.getValue()) {
                state.addOwnedPartitions((Collection)this.partitionsForTask.get(task), (String)entry.getKey());
            }
        }
        Set consumers = Utils.mkSet((Object[])new String[]{CONSUMER_1, CONSUMER_2, CONSUMER_3});
        state.assignActiveTasks(allTasks);
        StreamsPartitionAssignorTest.assertEquivalentAssignment(previousAssignment, this.partitionAssignor.tryStickyAndBalancedTaskAssignmentWithinClient(state, consumers, this.partitionsForTask, Collections.emptySet()));
    }

    @Test
    public void shouldProduceStickyAndBalancedAssignmentWhenNewTasksAreAdded() {
        this.configureDefault();
        ClientState state = new ClientState();
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2, this.task0_3, this.task1_0, this.task1_1, this.task1_2, this.task1_3});
        Map previousAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CONSUMER_1, new ArrayList<TaskId>(Arrays.asList(this.task0_0, this.task1_1, this.task1_3))), Utils.mkEntry((Object)CONSUMER_2, new ArrayList<TaskId>(Arrays.asList(this.task0_3, this.task1_0))), Utils.mkEntry((Object)CONSUMER_3, new ArrayList<TaskId>(Arrays.asList(this.task0_1, this.task0_2, this.task1_2)))});
        for (Map.Entry entry : previousAssignment.entrySet()) {
            for (TaskId task : (List)entry.getValue()) {
                state.addOwnedPartitions((Collection)this.partitionsForTask.get(task), (String)entry.getKey());
            }
        }
        Set consumers = Utils.mkSet((Object[])new String[]{CONSUMER_1, CONSUMER_2, CONSUMER_3});
        TaskId newTask = this.task2_0;
        allTasks.add(newTask);
        state.assignActiveTasks((Collection)allTasks);
        Map newAssignment = this.partitionAssignor.tryStickyAndBalancedTaskAssignmentWithinClient(state, consumers, this.partitionsForTask, Collections.emptySet());
        ((List)previousAssignment.get(CONSUMER_2)).add(newTask);
        StreamsPartitionAssignorTest.assertEquivalentAssignment(previousAssignment, newAssignment);
    }

    @Test
    public void shouldReturnEmptyMapWhenStickyAndBalancedAssignmentIsNotPossibleBecauseNewConsumerJoined() {
        this.configureDefault();
        ClientState state = new ClientState();
        List<TaskId> allTasks = Arrays.asList(this.task0_0, this.task0_1, this.task0_2, this.task0_3, this.task1_0, this.task1_1, this.task1_2, this.task1_3);
        Map previousAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CONSUMER_1, Arrays.asList(this.task0_0, this.task1_1, this.task1_3)), Utils.mkEntry((Object)CONSUMER_2, Arrays.asList(this.task0_3, this.task1_0)), Utils.mkEntry((Object)CONSUMER_3, Arrays.asList(this.task0_1, this.task0_2, this.task1_2))});
        for (Map.Entry entry : previousAssignment.entrySet()) {
            for (TaskId task : (List)entry.getValue()) {
                state.addOwnedPartitions((Collection)this.partitionsForTask.get(task), (String)entry.getKey());
            }
        }
        Set consumers = Utils.mkSet((Object[])new String[]{CONSUMER_1, CONSUMER_2, CONSUMER_3, CONSUMER_4});
        state.assignActiveTasks(allTasks);
        MatcherAssert.assertThat((Object)this.partitionAssignor.tryStickyAndBalancedTaskAssignmentWithinClient(state, consumers, this.partitionsForTask, Collections.emptySet()), (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
    }

    @Test
    public void shouldReturnEmptyMapWhenStickyAndBalancedAssignmentIsNotPossibleBecauseOtherClientOwnedPartition() {
        this.configureDefault();
        ClientState state = new ClientState();
        List<TaskId> allTasks = Arrays.asList(this.task0_0, this.task0_1, this.task0_2, this.task0_3, this.task1_0, this.task1_1, this.task1_2, this.task1_3);
        Map previousAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)CONSUMER_1, new ArrayList<TaskId>(Arrays.asList(this.task1_1, this.task1_3))), Utils.mkEntry((Object)CONSUMER_2, new ArrayList<TaskId>(Arrays.asList(this.task0_3, this.task1_0))), Utils.mkEntry((Object)CONSUMER_3, new ArrayList<TaskId>(Arrays.asList(this.task0_1, this.task0_2, this.task1_2)))});
        for (Map.Entry entry : previousAssignment.entrySet()) {
            for (TaskId task : (List)entry.getValue()) {
                state.addOwnedPartitions((Collection)this.partitionsForTask.get(task), (String)entry.getKey());
            }
        }
        HashSet allOwnedPartitions = new HashSet(this.partitionsForTask.get(this.task0_0));
        Set consumers = Utils.mkSet((Object[])new String[]{CONSUMER_1, CONSUMER_2, CONSUMER_3});
        state.assignActiveTasks(allTasks);
        MatcherAssert.assertThat((Object)this.partitionAssignor.tryStickyAndBalancedTaskAssignmentWithinClient(state, consumers, this.partitionsForTask, allOwnedPartitions), (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
    }

    @Test
    public void shouldInterleaveTasksByGroupId() {
        TaskId taskIdA0 = new TaskId(0, 0);
        TaskId taskIdA1 = new TaskId(0, 1);
        TaskId taskIdA2 = new TaskId(0, 2);
        TaskId taskIdA3 = new TaskId(0, 3);
        TaskId taskIdB0 = new TaskId(1, 0);
        TaskId taskIdB1 = new TaskId(1, 1);
        TaskId taskIdB2 = new TaskId(1, 2);
        TaskId taskIdC0 = new TaskId(2, 0);
        TaskId taskIdC1 = new TaskId(2, 1);
        String c1 = "c1";
        String c2 = "c2";
        String c3 = "c3";
        Set consumers = Utils.mkSet((Object[])new String[]{"c1", "c2", "c3"});
        List<TaskId> expectedSubList1 = Arrays.asList(taskIdA0, taskIdA3, taskIdB2);
        List<TaskId> expectedSubList2 = Arrays.asList(taskIdA1, taskIdB0, taskIdC0);
        List<TaskId> expectedSubList3 = Arrays.asList(taskIdA2, taskIdB1, taskIdC1);
        HashMap<String, List<TaskId>> assignment = new HashMap<String, List<TaskId>>();
        assignment.put("c1", expectedSubList1);
        assignment.put("c2", expectedSubList2);
        assignment.put("c3", expectedSubList3);
        List<TaskId> tasks = Arrays.asList(taskIdC0, taskIdC1, taskIdB0, taskIdB1, taskIdB2, taskIdA0, taskIdA1, taskIdA2, taskIdA3);
        Collections.shuffle(tasks);
        Map interleavedTaskIds = StreamsPartitionAssignor.interleaveConsumerTasksByGroupId(tasks, (Set)consumers);
        MatcherAssert.assertThat((Object)interleavedTaskIds, (Matcher)CoreMatchers.equalTo(assignment));
    }

    @Test
    public void testEagerSubscription() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        Set prevTasks = Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 1), new TaskId(1, 1), new TaskId(2, 1)});
        Set cachedTasks = Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 1), new TaskId(1, 1), new TaskId(2, 1), new TaskId(0, 2), new TaskId(1, 2), new TaskId(2, 2)});
        UUID processId = UUID.randomUUID();
        this.createMockTaskManager(prevTasks, cachedTasks, processId, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.setRebalanceProtocol(ConsumerPartitionAssignor.RebalanceProtocol.EAGER);
        Set topics = Utils.mkSet((Object[])new String[]{"topic1", "topic2"});
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(new ArrayList(topics), this.partitionAssignor.subscriptionUserData(topics));
        Collections.sort(subscription.topics());
        Assert.assertEquals(Arrays.asList("topic1", "topic2"), (Object)subscription.topics());
        HashSet<TaskId> standbyTasks = new HashSet<TaskId>(cachedTasks);
        standbyTasks.removeAll(prevTasks);
        SubscriptionInfo info = StreamsPartitionAssignorTest.getInfo(processId, prevTasks, standbyTasks, null);
        Assert.assertEquals((Object)info, (Object)SubscriptionInfo.decode((ByteBuffer)subscription.userData()));
    }

    @Test
    public void testCooperativeSubscription() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        Set prevTasks = Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 1), new TaskId(1, 1), new TaskId(2, 1)});
        Set cachedTasks = Utils.mkSet((Object[])new TaskId[]{new TaskId(0, 1), new TaskId(1, 1), new TaskId(2, 1), new TaskId(0, 2), new TaskId(1, 2), new TaskId(2, 2)});
        UUID processId = UUID.randomUUID();
        this.createMockTaskManager(prevTasks, cachedTasks, processId, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        Set topics = Utils.mkSet((Object[])new String[]{"topic1", "topic2"});
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(new ArrayList(topics), this.partitionAssignor.subscriptionUserData(topics));
        Collections.sort(subscription.topics());
        Assert.assertEquals(Arrays.asList("topic1", "topic2"), (Object)subscription.topics());
        HashSet<TaskId> standbyTasks = new HashSet<TaskId>(cachedTasks);
        standbyTasks.removeAll(prevTasks);
        SubscriptionInfo info = StreamsPartitionAssignorTest.getInfo(processId, Collections.emptySet(), standbyTasks, null);
        Assert.assertEquals((Object)info, (Object)SubscriptionInfo.decode((ByteBuffer)subscription.userData()));
    }

    @Test
    public void testAssignBasic() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        List<String> topics = Arrays.asList("topic1", "topic2");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        Set prevTasks10 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        Set prevTasks11 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Set prevTasks20 = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        Set standbyTasks10 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Set standbyTasks11 = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        Set standbyTasks20 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        this.createMockTaskManager(prevTasks10, standbyTasks10, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks10, standbyTasks10, USER_END_POINT).encode()));
        this.subscriptions.put("consumer11", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks11, standbyTasks11, USER_END_POINT).encode()));
        this.subscriptions.put("consumer20", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid2, prevTasks20, standbyTasks20, USER_END_POINT).encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Set[]{Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t2p0}), Utils.mkSet((Object[])new TopicPartition[]{this.t1p1, this.t2p1})}), (Object)Utils.mkSet((Object[])new HashSet[]{new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions()), new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).partitions())}));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p2, this.t2p2}), new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer20")).partitions()));
        AssignmentInfo info10 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer10"));
        HashSet allActiveTasks = new HashSet(info10.activeTasks());
        AssignmentInfo info11 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer11"));
        allActiveTasks.addAll(info11.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1}), allActiveTasks);
        AssignmentInfo info20 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer20"));
        allActiveTasks.addAll(info20.activeTasks());
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, new HashSet(allActiveTasks));
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, allActiveTasks);
    }

    @Test
    public void shouldAssignEvenlyAcrossConsumersOneClientMultipleThreads() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addProcessor("processorII", new MockProcessorSupplier(), new String[]{"source2"});
        List<PartitionInfo> localInfos = Arrays.asList(new PartitionInfo("topic1", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 3, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 3, Node.noNode(), new Node[0], new Node[0]));
        Cluster localMetadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), localInfos, Collections.emptySet(), Collections.emptySet());
        List<String> topics = Arrays.asList("topic1", "topic2");
        TaskId taskIdA0 = new TaskId(0, 0);
        TaskId taskIdA1 = new TaskId(0, 1);
        TaskId taskIdA2 = new TaskId(0, 2);
        TaskId taskIdA3 = new TaskId(0, 3);
        TaskId taskIdB0 = new TaskId(1, 0);
        TaskId taskIdB1 = new TaskId(1, 1);
        TaskId taskIdB2 = new TaskId(1, 2);
        TaskId taskIdB3 = new TaskId(1, 3);
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(new HashSet<TaskId>(), new HashSet<TaskId>(), uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, new HashSet<TaskId>(), new HashSet<TaskId>()).encode()));
        this.subscriptions.put("consumer11", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, new HashSet<TaskId>(), new HashSet<TaskId>()).encode()));
        Map assignments = this.partitionAssignor.assign(localMetadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Set[]{Utils.mkSet((Object[])new TopicPartition[]{this.t2p2, this.t1p0, this.t1p2, this.t2p0}), Utils.mkSet((Object[])new TopicPartition[]{this.t1p1, this.t2p1, this.t1p3, this.t2p3})}), (Object)Utils.mkSet((Object[])new HashSet[]{new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions()), new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).partitions())}));
        AssignmentInfo info10 = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).userData());
        List<TaskId> expectedInfo10TaskIds = Arrays.asList(taskIdA0, taskIdA2, taskIdB0, taskIdB2);
        Assert.assertEquals(expectedInfo10TaskIds, (Object)info10.activeTasks());
        AssignmentInfo info11 = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).userData());
        List<TaskId> expectedInfo11TaskIds = Arrays.asList(taskIdA1, taskIdA3, taskIdB1, taskIdB3);
        Assert.assertEquals(expectedInfo11TaskIds, (Object)info11.activeTasks());
    }

    @Test
    public void testAssignWithPartialTopology() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addProcessor("processor1", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store1", false), new String[]{"processor1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor2", new MockProcessorSupplier(), new String[]{"source2"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store2", false), new String[]{"processor2"});
        List<String> topics = Arrays.asList("topic1", "topic2");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("partition.grouper", SingleGroupPartitionGrouperStub.class));
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        AssignmentInfo info10 = StreamsPartitionAssignorTest.checkAssignment(Utils.mkSet((Object[])new String[]{"topic1"}), (ConsumerPartitionAssignor.Assignment)assignments.get("consumer10"));
        HashSet allActiveTasks = new HashSet(info10.activeTasks());
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, new HashSet(allActiveTasks));
    }

    @Test
    public void testAssignEmptyMetadata() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        List<String> topics = Arrays.asList("topic1", "topic2");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        Set prevTasks10 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        Set standbyTasks10 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Cluster emptyMetadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(prevTasks10, standbyTasks10, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks10, standbyTasks10).encode()));
        Map assignments = this.partitionAssignor.assign(emptyMetadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals(Collections.emptySet(), new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions()));
        AssignmentInfo info10 = StreamsPartitionAssignorTest.checkAssignment(Collections.emptySet(), (ConsumerPartitionAssignor.Assignment)assignments.get("consumer10"));
        HashSet allActiveTasks = new HashSet(info10.activeTasks());
        Assert.assertEquals((long)0L, (long)allActiveTasks.size());
        assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Set[]{Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t2p0, this.t1p0, this.t2p0, this.t1p1, this.t2p1, this.t1p2, this.t2p2})}), (Object)Utils.mkSet((Object[])new HashSet[]{new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions())}));
        info10 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer10"));
        allActiveTasks.addAll(info10.activeTasks());
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, new HashSet(allActiveTasks));
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, allActiveTasks);
    }

    @Test
    public void testAssignWithNewTasks() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addSource(null, "source3", null, null, null, new String[]{"topic3"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2", "source3"});
        List<String> topics = Arrays.asList("topic1", "topic2", "topic3");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2, this.task0_3});
        Set prevTasks10 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        Set prevTasks11 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Set prevTasks20 = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        this.createMockTaskManager(prevTasks10, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks10, this.emptyTasks).encode()));
        this.subscriptions.put("consumer11", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks11, this.emptyTasks).encode()));
        this.subscriptions.put("consumer20", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid2, prevTasks20, this.emptyTasks).encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        AssignmentInfo info = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).userData());
        HashSet allActiveTasks = new HashSet(info.activeTasks());
        HashSet allPartitions = new HashSet(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions());
        info = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).userData());
        allActiveTasks.addAll(info.activeTasks());
        allPartitions.addAll(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).partitions());
        info = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer20")).userData());
        allActiveTasks.addAll(info.activeTasks());
        allPartitions.addAll(((ConsumerPartitionAssignor.Assignment)assignments.get("consumer20")).partitions());
        Assert.assertEquals((Object)allTasks, allActiveTasks);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t1p1, this.t1p2, this.t2p0, this.t2p1, this.t2p2, this.t3p0, this.t3p1, this.t3p2, this.t3p3}), allPartitions);
    }

    @Test
    public void testAssignWithStates() {
        this.builder.setApplicationId(APPLICATION_ID);
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store1", false), new String[]{"processor-1"});
        this.builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source2"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store2", false), new String[]{"processor-2"});
        this.builder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("store3", false), new String[]{"processor-2"});
        List<String> topics = Arrays.asList("topic1", "topic2");
        TaskId task00 = new TaskId(0, 0);
        TaskId task01 = new TaskId(0, 1);
        TaskId task02 = new TaskId(0, 2);
        TaskId task10 = new TaskId(1, 0);
        TaskId task11 = new TaskId(1, 1);
        TaskId task12 = new TaskId(1, 2);
        List<TaskId> tasks = Arrays.asList(task00, task01, task02, task10, task11, task12);
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        this.subscriptions.put("consumer11", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        this.subscriptions.put("consumer20", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid2, this.emptyTasks, this.emptyTasks).encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((long)2L, (long)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).partitions().size());
        Assert.assertEquals((long)2L, (long)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).partitions().size());
        Assert.assertEquals((long)2L, (long)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer20")).partitions().size());
        AssignmentInfo info10 = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer10")).userData());
        AssignmentInfo info11 = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer11")).userData());
        AssignmentInfo info20 = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignments.get("consumer20")).userData());
        Assert.assertEquals((long)2L, (long)info10.activeTasks().size());
        Assert.assertEquals((long)2L, (long)info11.activeTasks().size());
        Assert.assertEquals((long)2L, (long)info20.activeTasks().size());
        HashSet allTasks = new HashSet();
        allTasks.addAll(info10.activeTasks());
        allTasks.addAll(info11.activeTasks());
        allTasks.addAll(info20.activeTasks());
        Assert.assertEquals(new HashSet<TaskId>(tasks), allTasks);
        Map topicGroups = this.builder.topicGroups();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{task00, task01, task02}), StreamsPartitionAssignorTest.tasksForState("store1", tasks, topicGroups));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{task10, task11, task12}), StreamsPartitionAssignorTest.tasksForState("store2", tasks, topicGroups));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{task10, task11, task12}), StreamsPartitionAssignorTest.tasksForState("store3", tasks, topicGroups));
    }

    private static Set<TaskId> tasksForState(String storeName, List<TaskId> tasks, Map<Integer, InternalTopologyBuilder.TopicsInfo> topicGroups) {
        String changelogTopic = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)storeName);
        HashSet<TaskId> ids = new HashSet<TaskId>();
        for (Map.Entry<Integer, InternalTopologyBuilder.TopicsInfo> entry : topicGroups.entrySet()) {
            Set stateChangelogTopics = entry.getValue().stateChangelogTopics.keySet();
            if (!stateChangelogTopics.contains(changelogTopic)) continue;
            for (TaskId id : tasks) {
                if (id.topicGroupId != entry.getKey()) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    @Test
    public void testAssignWithStandbyReplicas() {
        Map<String, Object> props = this.configProps();
        props.put("num.standby.replicas", "1");
        StreamsConfig streamsConfig = new StreamsConfig(props);
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topic2"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source1", "source2"});
        List<String> topics = Arrays.asList("topic1", "topic2");
        Set allTopicPartitions = topics.stream().map(topic -> Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1), new TopicPartition(topic, 2))).flatMap(Collection::stream).collect(Collectors.toSet());
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        Set prevTasks00 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        Set prevTasks01 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Set prevTasks02 = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        Set standbyTasks00 = Utils.mkSet((Object[])new TaskId[]{this.task0_0});
        Set standbyTasks01 = Utils.mkSet((Object[])new TaskId[]{this.task0_1});
        Set standbyTasks02 = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        this.createMockTaskManager(prevTasks00, standbyTasks01, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("num.standby.replicas", 1));
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks00, standbyTasks01, "any:9096").encode()));
        this.subscriptions.put("consumer11", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, prevTasks01, standbyTasks02, "any:9096").encode()));
        this.subscriptions.put("consumer20", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid2, prevTasks02, standbyTasks00, "any:9097").encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        AssignmentInfo info10 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer10"));
        HashSet allActiveTasks = new HashSet(info10.activeTasks());
        HashSet allStandbyTasks = new HashSet(info10.standbyTasks().keySet());
        AssignmentInfo info11 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer11"));
        allActiveTasks.addAll(info11.activeTasks());
        allStandbyTasks.addAll(info11.standbyTasks().keySet());
        Assert.assertNotEquals((String)"same processId has same set of standby tasks", info11.standbyTasks().keySet(), info10.standbyTasks().keySet());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1}), new HashSet(allActiveTasks));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.task0_2}), new HashSet(allStandbyTasks));
        AssignmentInfo info20 = StreamsPartitionAssignorTest.checkAssignment(this.allTopics, (ConsumerPartitionAssignor.Assignment)assignments.get("consumer20"));
        allActiveTasks.addAll(info20.activeTasks());
        allStandbyTasks.addAll(info20.standbyTasks().keySet());
        Assert.assertEquals((long)3L, (long)allActiveTasks.size());
        Assert.assertEquals((Object)allTasks, allActiveTasks);
        Assert.assertEquals((long)3L, (long)allStandbyTasks.size());
        Assert.assertEquals((Object)allTasks, allStandbyTasks);
        Map partitionsByHost = info10.partitionsByHost();
        Assert.assertEquals((long)2L, (long)partitionsByHost.size());
        Assert.assertEquals(allTopicPartitions, partitionsByHost.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        Map standbyPartitionsByHost = info10.standbyPartitionByHost();
        Assert.assertEquals((long)2L, (long)standbyPartitionsByHost.size());
        Assert.assertEquals(allTopicPartitions, standbyPartitionsByHost.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        for (HostInfo hostInfo : partitionsByHost.keySet()) {
            Assert.assertTrue((boolean)Collections.disjoint((Collection)partitionsByHost.get(hostInfo), (Collection)standbyPartitionsByHost.get(hostInfo)));
        }
        Assert.assertEquals((Object)partitionsByHost, (Object)info11.partitionsByHost());
        Assert.assertEquals((Object)partitionsByHost, (Object)info20.partitionsByHost());
        Assert.assertEquals((Object)standbyPartitionsByHost, (Object)info11.standbyPartitionByHost());
        Assert.assertEquals((Object)standbyPartitionsByHost, (Object)info20.standbyPartitionByHost());
    }

    @Test
    public void testOnAssignment() {
        this.createMockTaskManager();
        Map<HostInfo, Set> hostState = Collections.singletonMap(new HostInfo("localhost", 9090), Utils.mkSet((Object[])new TopicPartition[]{this.t3p0, this.t3p3}));
        this.taskManager.setHostPartitionMappings(hostState, Collections.emptyMap());
        EasyMock.expectLastCall();
        HashMap<TaskId, Set> activeTasks = new HashMap<TaskId, Set>();
        activeTasks.put(this.task0_0, Utils.mkSet((Object[])new TopicPartition[]{this.t3p0}));
        activeTasks.put(this.task0_3, Utils.mkSet((Object[])new TopicPartition[]{this.t3p3}));
        HashMap<TaskId, Set> standbyTasks = new HashMap<TaskId, Set>();
        standbyTasks.put(this.task0_1, Utils.mkSet((Object[])new TopicPartition[]{this.t3p1}));
        standbyTasks.put(this.task0_2, Utils.mkSet((Object[])new TopicPartition[]{this.t3p2}));
        this.taskManager.setAssignmentMetadata(activeTasks, standbyTasks);
        EasyMock.expectLastCall();
        Capture capturedCluster = EasyMock.newCapture();
        this.taskManager.setClusterMetadata((Cluster)EasyMock.capture((Capture)capturedCluster));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        List<TaskId> activeTaskList = Arrays.asList(this.task0_0, this.task0_3);
        AssignmentInfo info = new AssignmentInfo(6, activeTaskList, standbyTasks, hostState, Collections.emptyMap(), 0);
        ConsumerPartitionAssignor.Assignment assignment = new ConsumerPartitionAssignor.Assignment(Arrays.asList(this.t3p0, this.t3p3), info.encode());
        this.partitionAssignor.onAssignment(assignment, null);
        EasyMock.verify((Object[])new Object[]{this.taskManager});
        Assert.assertEquals(Collections.singleton(this.t3p0.topic()), (Object)((Cluster)capturedCluster.getValue()).topics());
        Assert.assertEquals((long)2L, (long)((Cluster)capturedCluster.getValue()).partitionsForTopic(this.t3p0.topic()).size());
    }

    @Test
    public void testAssignWithInternalTopics() {
        this.builder.setApplicationId(APPLICATION_ID);
        this.builder.addInternalTopic("topicX");
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addProcessor("processor1", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addSink("sink1", "topicX", null, null, null, new String[]{"processor1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topicX"});
        this.builder.addProcessor("processor2", new MockProcessorSupplier(), new String[]{"source2"});
        List<String> topics = Arrays.asList("topic1", "stream-partition-assignor-test-topicX");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        MockInternalTopicManager internalTopicManager = new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)internalTopicManager);
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((long)1L, (long)internalTopicManager.readyTopics.size());
        Assert.assertEquals((long)allTasks.size(), (long)internalTopicManager.readyTopics.get("stream-partition-assignor-test-topicX").intValue());
    }

    @Test
    public void testAssignWithInternalTopicThatsSourceIsAnotherInternalTopic() {
        String applicationId = "test";
        this.builder.setApplicationId("test");
        this.builder.addInternalTopic("topicX");
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.builder.addProcessor("processor1", new MockProcessorSupplier(), new String[]{"source1"});
        this.builder.addSink("sink1", "topicX", null, null, null, new String[]{"processor1"});
        this.builder.addSource(null, "source2", null, null, null, new String[]{"topicX"});
        this.builder.addInternalTopic("topicZ");
        this.builder.addProcessor("processor2", new MockProcessorSupplier(), new String[]{"source2"});
        this.builder.addSink("sink2", "topicZ", null, null, null, new String[]{"processor2"});
        this.builder.addSource(null, "source3", null, null, null, new String[]{"topicZ"});
        List<String> topics = Arrays.asList("topic1", "test-topicX", "test-topicZ");
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        MockInternalTopicManager internalTopicManager = new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)internalTopicManager);
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        Assert.assertEquals((long)2L, (long)internalTopicManager.readyTopics.size());
        Assert.assertEquals((long)allTasks.size(), (long)internalTopicManager.readyTopics.get("test-topicZ").intValue());
    }

    @Test
    public void shouldGenerateTasksForAllCreatedPartitions() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream1 = builder.stream("topic1").map(KeyValue::new);
        KTable table1 = builder.table("topic3").groupBy(KeyValue::new).count();
        stream1.join(table1, (value1, value2) -> null);
        UUID uuid = UUID.randomUUID();
        String client = "client1";
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(builder.build());
        internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), internalTopologyBuilder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        MockInternalTopicManager mockInternalTopicManager = new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)mockInternalTopicManager);
        this.subscriptions.put("client1", new ConsumerPartitionAssignor.Subscription(Arrays.asList("topic1", "topic3"), StreamsPartitionAssignorTest.getInfo(uuid, this.emptyTasks, this.emptyTasks).encode()));
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        HashMap<String, Integer> expectedCreatedInternalTopics = new HashMap<String, Integer>();
        expectedCreatedInternalTopics.put("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-repartition", 4);
        expectedCreatedInternalTopics.put("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-changelog", 4);
        expectedCreatedInternalTopics.put("stream-partition-assignor-test-topic3-STATE-STORE-0000000002-changelog", 4);
        expectedCreatedInternalTopics.put("stream-partition-assignor-test-KSTREAM-MAP-0000000001-repartition", 4);
        MatcherAssert.assertThat(mockInternalTopicManager.readyTopics, (Matcher)CoreMatchers.equalTo(expectedCreatedInternalTopics));
        List<TopicPartition> expectedAssignment = Arrays.asList(new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic1", 2), new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2), new TopicPartition("topic3", 3), new TopicPartition("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-repartition", 0), new TopicPartition("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-repartition", 1), new TopicPartition("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-repartition", 2), new TopicPartition("stream-partition-assignor-test-KTABLE-AGGREGATE-STATE-STORE-0000000006-repartition", 3), new TopicPartition("stream-partition-assignor-test-KSTREAM-MAP-0000000001-repartition", 0), new TopicPartition("stream-partition-assignor-test-KSTREAM-MAP-0000000001-repartition", 1), new TopicPartition("stream-partition-assignor-test-KSTREAM-MAP-0000000001-repartition", 2), new TopicPartition("stream-partition-assignor-test-KSTREAM-MAP-0000000001-repartition", 3));
        MatcherAssert.assertThat(new HashSet(((ConsumerPartitionAssignor.Assignment)assignment.get("client1")).partitions()), (Matcher)CoreMatchers.equalTo(new HashSet<TopicPartition>(expectedAssignment)));
    }

    @Test
    public void shouldAddUserDefinedEndPointToSubscription() {
        this.builder.setApplicationId(APPLICATION_ID);
        this.builder.addSource(null, "source", null, null, null, new String[]{"input"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addSink("sink", "output", null, null, null, new String[]{"processor"});
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("application.server", USER_END_POINT));
        Set topics = Utils.mkSet((Object[])new String[]{"input"});
        ByteBuffer userData = this.partitionAssignor.subscriptionUserData(topics);
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(new ArrayList(topics), userData);
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.decode((ByteBuffer)subscription.userData());
        Assert.assertEquals((Object)USER_END_POINT, (Object)subscriptionInfo.userEndPoint());
    }

    @Test
    public void shouldMapUserEndPointToTopicPartitions() {
        this.builder.setApplicationId(APPLICATION_ID);
        this.builder.addSource(null, "source", null, null, null, new String[]{"topic1"});
        this.builder.addProcessor("processor", new MockProcessorSupplier(), new String[]{"source"});
        this.builder.addSink("sink", "output", null, null, null, new String[]{"processor"});
        List<String> topics = Collections.singletonList("topic1");
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("application.server", USER_END_POINT));
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        Map assignments = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        ConsumerPartitionAssignor.Assignment consumerAssignment = (ConsumerPartitionAssignor.Assignment)assignments.get(CONSUMER_1);
        AssignmentInfo assignmentInfo = AssignmentInfo.decode((ByteBuffer)consumerAssignment.userData());
        Set topicPartitions = (Set)assignmentInfo.partitionsByHost().get(new HostInfo("localhost", 8080));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic1", 2)}), (Object)topicPartitions);
    }

    @Test
    public void shouldThrowExceptionIfApplicationServerConfigIsNotHostPortPair() {
        this.builder.setApplicationId(APPLICATION_ID);
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        try {
            this.configurePartitionAssignor(Collections.singletonMap("application.server", "localhost"));
            Assert.fail((String)"expected to an exception due to invalid config");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfApplicationServerConfigPortIsNotAnInteger() {
        this.builder.setApplicationId(APPLICATION_ID);
        try {
            this.configurePartitionAssignor(Collections.singletonMap("application.server", "localhost:j87yhk"));
            Assert.fail((String)"expected to an exception due to invalid config");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotLoopInfinitelyOnMissingMetadataAndShouldNotCreateRelatedTasks() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream1 = builder.stream("topic1").selectKey((key, value) -> null).groupByKey().count(Materialized.as((String)"count")).toStream().map((key, value) -> null);
        builder.stream("unknownTopic").selectKey((key, value) -> null).join(stream1, (value1, value2) -> null, JoinWindows.of((Duration)Duration.ofMillis(0L)));
        UUID uuid = UUID.randomUUID();
        String client = "client1";
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(builder.build());
        internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), internalTopologyBuilder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        MockInternalTopicManager mockInternalTopicManager = new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)mockInternalTopicManager);
        this.subscriptions.put("client1", new ConsumerPartitionAssignor.Subscription(Collections.singletonList("unknownTopic"), StreamsPartitionAssignorTest.getInfo(uuid, this.emptyTasks, this.emptyTasks).encode()));
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        MatcherAssert.assertThat((Object)mockInternalTopicManager.readyTopics.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get("client1")).partitions().isEmpty(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldUpdateClusterMetadataAndHostInfoOnAssignment() {
        TopicPartition partitionOne = new TopicPartition("topic", 1);
        TopicPartition partitionTwo = new TopicPartition("topic", 2);
        Map<HostInfo, Set<TopicPartition>> hostState = Collections.singletonMap(new HostInfo("localhost", 9090), Utils.mkSet((Object[])new TopicPartition[]{partitionOne, partitionTwo}));
        StreamsBuilder builder = new StreamsBuilder();
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(builder.build());
        internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), internalTopologyBuilder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        this.partitionAssignor.onAssignment(StreamsPartitionAssignorTest.createAssignment(hostState), null);
        EasyMock.verify((Object[])new Object[]{this.taskManager});
    }

    @Test
    public void shouldNotAddStandbyTaskPartitionsToPartitionsForHost() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("topic1").groupByKey().count();
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(builder.build());
        internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        UUID uuid = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid, internalTopologyBuilder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("num.standby.replicas", 1);
        props.put("application.server", USER_END_POINT);
        this.configurePartitionAssignor(props);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer));
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(uuid, this.emptyTasks, this.emptyTasks).encode()));
        this.subscriptions.put(CONSUMER_2, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(UUID.randomUUID(), this.emptyTasks, this.emptyTasks, "other:9090").encode()));
        Set allPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t1p1, this.t1p2});
        Map assign = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        ConsumerPartitionAssignor.Assignment consumer1Assignment = (ConsumerPartitionAssignor.Assignment)assign.get(CONSUMER_1);
        AssignmentInfo assignmentInfo = AssignmentInfo.decode((ByteBuffer)consumer1Assignment.userData());
        Set consumer1ActivePartitions = (Set)assignmentInfo.partitionsByHost().get(new HostInfo("localhost", 8080));
        Set consumer2ActivePartitions = (Set)assignmentInfo.partitionsByHost().get(new HostInfo("other", 9090));
        Set consumer1StandbyPartitions = (Set)assignmentInfo.standbyPartitionByHost().get(new HostInfo("localhost", 8080));
        Set consumer2StandbyPartitions = (Set)assignmentInfo.standbyPartitionByHost().get(new HostInfo("other", 9090));
        HashSet allAssignedPartitions = new HashSet(consumer1ActivePartitions);
        allAssignedPartitions.addAll(consumer2ActivePartitions);
        MatcherAssert.assertThat((Object)consumer1ActivePartitions, (Matcher)CoreMatchers.not((Object)allPartitions));
        MatcherAssert.assertThat((Object)consumer2ActivePartitions, (Matcher)CoreMatchers.not((Object)allPartitions));
        MatcherAssert.assertThat((Object)consumer1ActivePartitions, (Matcher)CoreMatchers.equalTo((Object)consumer2StandbyPartitions));
        MatcherAssert.assertThat((Object)consumer2ActivePartitions, (Matcher)CoreMatchers.equalTo((Object)consumer1StandbyPartitions));
        MatcherAssert.assertThat(allAssignedPartitions, (Matcher)CoreMatchers.equalTo((Object)allPartitions));
    }

    @Test
    public void shouldThrowKafkaExceptionIfTaskMangerNotConfigured() {
        Map<String, Object> config = this.configProps();
        config.remove("__task.manager.instance__");
        try {
            this.partitionAssignor.configure(config);
            Assert.fail((String)"Should have thrown KafkaException");
        }
        catch (KafkaException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"TaskManager is not specified"));
        }
    }

    @Test
    public void shouldThrowKafkaExceptionIfTaskMangerConfigIsNotTaskManagerInstance() {
        Map<String, Object> config = this.configProps();
        config.put("__task.manager.instance__", "i am not a task manager");
        try {
            this.partitionAssignor.configure(config);
            Assert.fail((String)"Should have thrown KafkaException");
        }
        catch (KafkaException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"java.lang.String is not an instance of org.apache.kafka.streams.processor.internals.TaskManager"));
        }
    }

    @Test
    public void shouldThrowKafkaExceptionAssignmentErrorCodeNotConfigured() {
        this.createMockTaskManager();
        Map<String, Object> config = this.configProps();
        config.remove("__assignment.error.code__");
        try {
            this.partitionAssignor.configure(config);
            Assert.fail((String)"Should have thrown KafkaException");
        }
        catch (KafkaException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"assignmentErrorCode is not specified"));
        }
    }

    @Test
    public void shouldThrowKafkaExceptionIfVersionProbingFlagConfigIsNotAtomicInteger() {
        this.createMockTaskManager();
        Map<String, Object> config = this.configProps();
        config.put("__assignment.error.code__", "i am not an AtomicInteger");
        try {
            this.partitionAssignor.configure(config);
            Assert.fail((String)"Should have thrown KafkaException");
        }
        catch (KafkaException expected) {
            MatcherAssert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"java.lang.String is not an instance of java.util.concurrent.atomic.AtomicInteger"));
        }
    }

    @Test
    public void shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersionsV1V2() {
        this.shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersions(1, 2);
    }

    @Test
    public void shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersionsV1V3() {
        this.shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersions(1, 3);
    }

    @Test
    public void shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersionsV2V3() {
        this.shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersions(2, 3);
    }

    private void shouldReturnLowestAssignmentVersionForDifferentSubscriptionVersions(int smallestVersion, int otherVersion) {
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(smallestVersion, UUID.randomUUID(), this.emptyTasks, this.emptyTasks, null).encode()));
        this.subscriptions.put(CONSUMER_2, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(otherVersion, UUID.randomUUID(), this.emptyTasks, this.emptyTasks, null).encode()));
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.partitionAssignor.configure(this.configProps());
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        MatcherAssert.assertThat((Object)assignment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).userData()).version(), (Matcher)CoreMatchers.equalTo((Object)smallestVersion));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_2)).userData()).version(), (Matcher)CoreMatchers.equalTo((Object)smallestVersion));
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion1() {
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("upgrade.from", "0.10.0"));
        Set topics = Utils.mkSet((Object[])new String[]{"topic1"});
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(new ArrayList(topics), this.partitionAssignor.subscriptionUserData(topics));
        MatcherAssert.assertThat((Object)SubscriptionInfo.decode((ByteBuffer)subscription.userData()).version(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion2For0101() {
        this.shouldDownGradeSubscriptionToVersion2("0.10.1");
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion2For0102() {
        this.shouldDownGradeSubscriptionToVersion2("0.10.2");
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion2For0110() {
        this.shouldDownGradeSubscriptionToVersion2("0.11.0");
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion2For10() {
        this.shouldDownGradeSubscriptionToVersion2("1.0");
    }

    @Test
    public void shouldDownGradeSubscriptionToVersion2For11() {
        this.shouldDownGradeSubscriptionToVersion2("1.1");
    }

    private void shouldDownGradeSubscriptionToVersion2(Object upgradeFromValue) {
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.singletonMap("upgrade.from", upgradeFromValue));
        Set topics = Utils.mkSet((Object[])new String[]{"topic1"});
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(new ArrayList(topics), this.partitionAssignor.subscriptionUserData(topics));
        MatcherAssert.assertThat((Object)SubscriptionInfo.decode((ByteBuffer)subscription.userData()).version(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldReturnInterleavedAssignmentWithUnrevokedPartitionsRemovedWhenNewConsumerJoins() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        Map allTaskLags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.task0_0, (Object)0), Utils.mkEntry((Object)this.task0_1, (Object)0), Utils.mkEntry((Object)this.task0_2, (Object)0)});
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(UUID.randomUUID(), allTasks, Collections.emptySet(), null).encode(), Arrays.asList(this.t1p0, this.t1p1, this.t1p2)));
        this.subscriptions.put(CONSUMER_2, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(UUID.randomUUID(), Collections.emptySet(), Collections.emptySet(), null).encode(), Collections.emptyList()));
        this.createMockTaskManager(allTasks, allTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.partitionAssignor.configure(this.configProps());
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        MatcherAssert.assertThat((Object)assignment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).partitions(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.t1p0, this.t1p2)));
        AssignmentInfo decode = AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).userData());
        MatcherAssert.assertThat((Object)decode, (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, Arrays.asList(this.task0_0, this.task0_2), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0)));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_2)).partitions(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_2)).userData()), (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0)));
    }

    @Test
    public void shouldReturnNormalAssignmentForOldAndFutureInstancesDuringVersionProbing() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        Set activeTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1});
        Set standbyTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_2});
        Map standbyTaskMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.task0_2, Collections.singleton(this.t1p2))});
        Map futureStandbyTaskMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.task0_0, Collections.singleton(this.t1p0)), Utils.mkEntry((Object)this.task0_1, Collections.singleton(this.t1p1))});
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(UUID.randomUUID(), activeTasks, standbyTasks, null).encode(), Arrays.asList(this.t1p0, this.t1p1)));
        this.subscriptions.put("future-consumer", new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.encodeFutureSubscription(), Collections.singletonList(this.t1p2)));
        this.createMockTaskManager(allTasks, allTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        Map<String, Object> props = this.configProps();
        props.put("num.standby.replicas", 1);
        this.partitionAssignor.configure(props);
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        MatcherAssert.assertThat((Object)assignment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).partitions(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.t1p0, this.t1p1)));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).userData()), (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, new ArrayList(activeTasks), standbyTaskMap, Collections.emptyMap(), Collections.emptyMap(), 0)));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get("future-consumer")).partitions(), (Matcher)CoreMatchers.equalTo(Collections.singletonList(this.t1p2)));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get("future-consumer")).userData()), (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, Collections.singletonList(this.task0_2), futureStandbyTaskMap, Collections.emptyMap(), Collections.emptyMap(), 0)));
    }

    @Test
    public void shouldReturnInterleavedAssignmentForOnlyFutureInstancesDuringVersionProbing() {
        this.builder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{this.task0_0, this.task0_1, this.task0_2});
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.encodeFutureSubscription(), Collections.emptyList()));
        this.subscriptions.put(CONSUMER_2, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.encodeFutureSubscription(), Collections.emptyList()));
        this.createMockTaskManager(allTasks, allTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        Map<String, Object> props = this.configProps();
        props.put("num.standby.replicas", 1);
        this.partitionAssignor.configure(props);
        Map assignment = this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
        MatcherAssert.assertThat((Object)assignment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).partitions(), (Matcher)CoreMatchers.equalTo(Arrays.asList(this.t1p0, this.t1p2)));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_1)).userData()), (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, Arrays.asList(this.task0_0, this.task0_2), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0)));
        MatcherAssert.assertThat((Object)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_2)).partitions(), (Matcher)CoreMatchers.equalTo(Collections.singletonList(this.t1p1)));
        MatcherAssert.assertThat((Object)AssignmentInfo.decode((ByteBuffer)((ConsumerPartitionAssignor.Assignment)assignment.get(CONSUMER_2)).userData()), (Matcher)CoreMatchers.equalTo((Object)new AssignmentInfo(6, Collections.singletonList(this.task0_1), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0)));
    }

    @Test
    public void shouldThrowIfV1SubscriptionAndFutureSubscriptionIsMixed() {
        this.shouldThrowIfPreVersionProbingSubscriptionAndFutureSubscriptionIsMixed(1);
    }

    @Test
    public void shouldThrowIfV2SubscriptionAndFutureSubscriptionIsMixed() {
        this.shouldThrowIfPreVersionProbingSubscriptionAndFutureSubscriptionIsMixed(2);
    }

    @Test
    public void shouldNotFailOnBranchedMultiLevelRepartitionConnectedTopology() {
        String applicationId = "test";
        this.builder.setApplicationId("test");
        this.builder.addSource(null, "KSTREAM-SOURCE-0000000000", null, null, null, new String[]{"input-stream"});
        this.builder.addProcessor("KSTREAM-FLATMAPVALUES-0000000001", new MockProcessorSupplier(), new String[]{"KSTREAM-SOURCE-0000000000"});
        this.builder.addProcessor("KSTREAM-BRANCH-0000000002", new MockProcessorSupplier(), new String[]{"KSTREAM-FLATMAPVALUES-0000000001"});
        this.builder.addProcessor("KSTREAM-BRANCHCHILD-0000000003", new MockProcessorSupplier(), new String[]{"KSTREAM-BRANCH-0000000002"});
        this.builder.addProcessor("KSTREAM-BRANCHCHILD-0000000004", new MockProcessorSupplier(), new String[]{"KSTREAM-BRANCH-0000000002"});
        this.builder.addProcessor("KSTREAM-MAP-0000000005", new MockProcessorSupplier(), new String[]{"KSTREAM-BRANCHCHILD-0000000003"});
        this.builder.addInternalTopic("odd_store-repartition");
        this.builder.addProcessor("odd_store-repartition-filter", new MockProcessorSupplier(), new String[]{"KSTREAM-MAP-0000000005"});
        this.builder.addSink("odd_store-repartition-sink", "odd_store-repartition", null, null, null, new String[]{"odd_store-repartition-filter"});
        this.builder.addSource(null, "odd_store-repartition-source", null, null, null, new String[]{"odd_store-repartition"});
        this.builder.addProcessor("KSTREAM-REDUCE-0000000006", new MockProcessorSupplier(), new String[]{"odd_store-repartition-source"});
        this.builder.addProcessor("KTABLE-TOSTREAM-0000000010", new MockProcessorSupplier(), new String[]{"KSTREAM-REDUCE-0000000006"});
        this.builder.addProcessor("KSTREAM-PEEK-0000000011", new MockProcessorSupplier(), new String[]{"KTABLE-TOSTREAM-0000000010"});
        this.builder.addProcessor("KSTREAM-MAP-0000000012", new MockProcessorSupplier(), new String[]{"KSTREAM-PEEK-0000000011"});
        this.builder.addInternalTopic("odd_store_2-repartition");
        this.builder.addProcessor("odd_store_2-repartition-filter", new MockProcessorSupplier(), new String[]{"KSTREAM-MAP-0000000012"});
        this.builder.addSink("odd_store_2-repartition-sink", "odd_store_2-repartition", null, null, null, new String[]{"odd_store_2-repartition-filter"});
        this.builder.addSource(null, "odd_store_2-repartition-source", null, null, null, new String[]{"odd_store_2-repartition"});
        this.builder.addProcessor("KSTREAM-REDUCE-0000000013", new MockProcessorSupplier(), new String[]{"odd_store_2-repartition-source"});
        this.builder.addProcessor("KSTREAM-MAP-0000000017", new MockProcessorSupplier(), new String[]{"KSTREAM-BRANCHCHILD-0000000004"});
        this.builder.addInternalTopic("even_store-repartition");
        this.builder.addProcessor("even_store-repartition-filter", new MockProcessorSupplier(), new String[]{"KSTREAM-MAP-0000000017"});
        this.builder.addSink("even_store-repartition-sink", "even_store-repartition", null, null, null, new String[]{"even_store-repartition-filter"});
        this.builder.addSource(null, "even_store-repartition-source", null, null, null, new String[]{"even_store-repartition"});
        this.builder.addProcessor("KSTREAM-REDUCE-0000000018", new MockProcessorSupplier(), new String[]{"even_store-repartition-source"});
        this.builder.addProcessor("KTABLE-TOSTREAM-0000000022", new MockProcessorSupplier(), new String[]{"KSTREAM-REDUCE-0000000018"});
        this.builder.addProcessor("KSTREAM-PEEK-0000000023", new MockProcessorSupplier(), new String[]{"KTABLE-TOSTREAM-0000000022"});
        this.builder.addProcessor("KSTREAM-MAP-0000000024", new MockProcessorSupplier(), new String[]{"KSTREAM-PEEK-0000000023"});
        this.builder.addInternalTopic("even_store_2-repartition");
        this.builder.addProcessor("even_store_2-repartition-filter", new MockProcessorSupplier(), new String[]{"KSTREAM-MAP-0000000024"});
        this.builder.addSink("even_store_2-repartition-sink", "even_store_2-repartition", null, null, null, new String[]{"even_store_2-repartition-filter"});
        this.builder.addSource(null, "even_store_2-repartition-source", null, null, null, new String[]{"even_store_2-repartition"});
        this.builder.addProcessor("KSTREAM-REDUCE-0000000025", new MockProcessorSupplier(), new String[]{"even_store_2-repartition-source"});
        this.builder.addProcessor("KTABLE-JOINTHIS-0000000030", new MockProcessorSupplier(), new String[]{"KSTREAM-REDUCE-0000000013"});
        this.builder.addProcessor("KTABLE-JOINOTHER-0000000031", new MockProcessorSupplier(), new String[]{"KSTREAM-REDUCE-0000000025"});
        this.builder.addProcessor("KTABLE-MERGE-0000000029", new MockProcessorSupplier(), new String[]{"KTABLE-JOINTHIS-0000000030", "KTABLE-JOINOTHER-0000000031"});
        this.builder.addProcessor("KTABLE-TOSTREAM-0000000032", new MockProcessorSupplier(), new String[]{"KTABLE-MERGE-0000000029"});
        List<String> topics = Arrays.asList("input-stream", "test-even_store-repartition", "test-even_store_2-repartition", "test-odd_store-repartition", "test-odd_store_2-repartition");
        UUID uuid1 = UUID.randomUUID();
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, uuid1, this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.configurePartitionAssignor(Collections.emptyMap());
        MockInternalTopicManager internalTopicManager = new MockInternalTopicManager(this.streamsConfig, this.mockClientSupplier.restoreConsumer);
        this.partitionAssignor.setInternalTopicManager((InternalTopicManager)internalTopicManager);
        this.subscriptions.put("consumer10", new ConsumerPartitionAssignor.Subscription(topics, StreamsPartitionAssignorTest.getInfo(uuid1, this.emptyTasks, this.emptyTasks).encode()));
        Cluster metadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), Collections.singletonList(new PartitionInfo("input-stream", 0, Node.noNode(), new Node[0], new Node[0])), Collections.emptySet(), Collections.emptySet());
        this.partitionAssignor.assign(metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions));
    }

    private static ByteBuffer encodeFutureSubscription() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(7);
        buf.putInt(7);
        return buf;
    }

    private void shouldThrowIfPreVersionProbingSubscriptionAndFutureSubscriptionIsMixed(int oldVersion) {
        this.subscriptions.put(CONSUMER_1, new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.getInfo(oldVersion, UUID.randomUUID(), this.emptyTasks, this.emptyTasks, null).encode()));
        this.subscriptions.put("future-consumer", new ConsumerPartitionAssignor.Subscription(Collections.singletonList("topic1"), StreamsPartitionAssignorTest.encodeFutureSubscription()));
        this.createMockTaskManager(this.emptyTasks, this.emptyTasks, UUID.randomUUID(), this.builder);
        EasyMock.replay((Object[])new Object[]{this.taskManager});
        this.partitionAssignor.configure(this.configProps());
        try {
            this.partitionAssignor.assign(this.metadata, new ConsumerPartitionAssignor.GroupSubscription(this.subscriptions)).groupAssignment();
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static ConsumerPartitionAssignor.Assignment createAssignment(Map<HostInfo, Set<TopicPartition>> firstHostState) {
        AssignmentInfo info = new AssignmentInfo(6, Collections.emptyList(), Collections.emptyMap(), firstHostState, Collections.emptyMap(), 0);
        return new ConsumerPartitionAssignor.Assignment(Collections.emptyList(), info.encode());
    }

    private static AssignmentInfo checkAssignment(Set<String> expectedTopics, ConsumerPartitionAssignor.Assignment assignment) {
        AssignmentInfo info = AssignmentInfo.decode((ByteBuffer)assignment.userData());
        Assert.assertEquals((long)assignment.partitions().size(), (long)info.activeTasks().size());
        ArrayList<TaskId> activeTasks = new ArrayList<TaskId>();
        HashSet<String> activeTopics = new HashSet<String>();
        for (TopicPartition partition : assignment.partitions()) {
            activeTasks.add(new TaskId(0, partition.partition()));
            activeTopics.add(partition.topic());
        }
        Assert.assertEquals(activeTasks, (Object)info.activeTasks());
        Assert.assertEquals(expectedTopics, activeTopics);
        HashSet<String> standbyTopics = new HashSet<String>();
        for (Map.Entry entry : info.standbyTasks().entrySet()) {
            TaskId id = (TaskId)entry.getKey();
            Set partitions = (Set)entry.getValue();
            for (TopicPartition partition : partitions) {
                Assert.assertEquals((long)id.partition, (long)partition.partition());
                standbyTopics.add(partition.topic());
            }
        }
        if (!info.standbyTasks().isEmpty()) {
            Assert.assertEquals(expectedTopics, standbyTopics);
        }
        return info;
    }

    private static void assertEquivalentAssignment(Map<String, List<TaskId>> thisAssignment, Map<String, List<TaskId>> otherAssignment) {
        Assert.assertEquals((long)thisAssignment.size(), (long)otherAssignment.size());
        for (Map.Entry<String, List<TaskId>> entry : thisAssignment.entrySet()) {
            String consumer = entry.getKey();
            Assert.assertTrue((boolean)otherAssignment.containsKey(consumer));
            List<TaskId> thisTaskList = entry.getValue();
            Collections.sort(thisTaskList);
            List<TaskId> otherTaskList = otherAssignment.get(consumer);
            Collections.sort(otherTaskList);
            MatcherAssert.assertThat(thisTaskList, (Matcher)CoreMatchers.equalTo(otherTaskList));
        }
    }
}

