/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.UnwindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.junit.Assert;
import org.junit.Test;

public class InternalTopicConfigTest {
    @Test(expected=NullPointerException.class)
    public void shouldThrowIfNameIsNull() {
        new RepartitionTopicConfig(null, Collections.emptyMap());
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldThrowIfNameIsInvalid() {
        new RepartitionTopicConfig("foo bar baz", Collections.emptyMap());
    }

    @Test
    public void shouldSetCreateTimeByDefaultForWindowedChangelog() {
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", Collections.emptyMap());
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForUnwindowedChangelog() {
        UnwindowedChangelogTopicConfig topicConfig = new UnwindowedChangelogTopicConfig("name", Collections.emptyMap());
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldSetCreateTimeByDefaultForRepartitionTopic() {
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("name", Collections.emptyMap());
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"CreateTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldAugmentRetentionMsWithWindowedChangelog() {
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", Collections.emptyMap());
        topicConfig.setRetentionMs(10L);
        Assert.assertEquals((Object)"30", topicConfig.getProperties(Collections.emptyMap(), 20L).get("retention.ms"));
    }

    @Test
    public void shouldUseSuppliedConfigsForWindowedChangelogConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("message.timestamp.type", "LogAppendTime");
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", configs);
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldUseSuppliedConfigsForUnwindowedChangelogConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("retention.bytes", "10000");
        configs.put("message.timestamp.type", "LogAppendTime");
        UnwindowedChangelogTopicConfig topicConfig = new UnwindowedChangelogTopicConfig("name", configs);
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"1000", properties.get("retention.ms"));
        Assert.assertEquals((Object)"10000", properties.get("retention.bytes"));
        Assert.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }

    @Test
    public void shouldUseSuppliedConfigsForRepartitionConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("message.timestamp.type", "LogAppendTime");
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("name", configs);
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"1000", properties.get("retention.ms"));
        Assert.assertEquals((Object)"LogAppendTime", properties.get("message.timestamp.type"));
    }
}

