/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueIteratorAdapter;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

public class KeyValueToTimestampedKeyValueByteStoreAdapter
implements KeyValueStore<Bytes, byte[]> {
    final KeyValueStore<Bytes, byte[]> store;

    KeyValueToTimestampedKeyValueByteStoreAdapter(KeyValueStore<Bytes, byte[]> store) {
        if (!store.persistent()) {
            throw new IllegalArgumentException("Provided store must be a persistent store, but it is not.");
        }
        this.store = store;
    }

    @Override
    public void put(Bytes key, byte[] valueWithTimestamp) {
        this.store.put(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] valueWithTimestamp) {
        return TimestampedBytesStore.convertToTimestampedFormat(this.store.putIfAbsent(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp)));
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            byte[] valueWithTimestamp = (byte[])entry.value;
            this.store.put((Bytes)entry.key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        return TimestampedBytesStore.convertToTimestampedFormat(this.store.delete(key));
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.store.init(context, root);
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    @Override
    public byte[] get(Bytes key) {
        return TimestampedBytesStore.convertToTimestampedFormat((byte[])this.store.get(key));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.range(from, to));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.all());
    }

    @Override
    public long approximateNumEntries() {
        return this.store.approximateNumEntries();
    }
}

