/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

public final class BufferValue {
    private static final int NULL_VALUE_SENTINEL = -1;
    private static final int OLD_PREV_DUPLICATE_VALUE_SENTINEL = -2;
    private final byte[] priorValue;
    private final byte[] oldValue;
    private final byte[] newValue;
    private final ProcessorRecordContext recordContext;

    BufferValue(byte[] priorValue, byte[] oldValue, byte[] newValue, ProcessorRecordContext recordContext) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.recordContext = recordContext;
        this.priorValue = Arrays.equals(priorValue, oldValue) ? oldValue : priorValue;
    }

    byte[] priorValue() {
        return this.priorValue;
    }

    byte[] oldValue() {
        return this.oldValue;
    }

    byte[] newValue() {
        return this.newValue;
    }

    ProcessorRecordContext context() {
        return this.recordContext;
    }

    static BufferValue deserialize(ByteBuffer buffer) {
        byte[] oldValue;
        ProcessorRecordContext context = ProcessorRecordContext.deserialize(buffer);
        byte[] priorValue = BufferValue.extractValue(buffer);
        int oldValueLength = buffer.getInt();
        if (oldValueLength == -1) {
            oldValue = null;
        } else if (oldValueLength == -2) {
            oldValue = priorValue;
        } else {
            oldValue = new byte[oldValueLength];
            buffer.get(oldValue);
        }
        byte[] newValue = BufferValue.extractValue(buffer);
        return new BufferValue(priorValue, oldValue, newValue, context);
    }

    private static byte[] extractValue(ByteBuffer buffer) {
        int valueLength = buffer.getInt();
        if (valueLength == -1) {
            return null;
        }
        byte[] value = new byte[valueLength];
        buffer.get(value);
        return value;
    }

    ByteBuffer serialize(int endPadding) {
        int sizeOfValueLength = 4;
        int sizeOfPriorValue = this.priorValue == null ? 0 : this.priorValue.length;
        int sizeOfOldValue = this.oldValue == null || this.priorValue == this.oldValue ? 0 : this.oldValue.length;
        int sizeOfNewValue = this.newValue == null ? 0 : this.newValue.length;
        byte[] serializedContext = this.recordContext.serialize();
        ByteBuffer buffer = ByteBuffer.allocate(serializedContext.length + 4 + sizeOfPriorValue + 4 + sizeOfOldValue + 4 + sizeOfNewValue + endPadding);
        buffer.put(serializedContext);
        BufferValue.addValue(buffer, this.priorValue);
        if (this.oldValue == null) {
            buffer.putInt(-1);
        } else if (this.priorValue == this.oldValue) {
            buffer.putInt(-2);
        } else {
            buffer.putInt(sizeOfOldValue);
            buffer.put(this.oldValue);
        }
        BufferValue.addValue(buffer, this.newValue);
        return buffer;
    }

    private static void addValue(ByteBuffer buffer, byte[] value) {
        if (value == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(value.length);
            buffer.put(value);
        }
    }

    long residentMemorySizeEstimate() {
        return (long)((this.priorValue == null ? 0 : this.priorValue.length) + (this.oldValue == null || this.priorValue == this.oldValue ? 0 : this.oldValue.length) + (this.newValue == null ? 0 : this.newValue.length)) + this.recordContext.residentMemorySizeEstimate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferValue that = (BufferValue)o;
        return Arrays.equals(this.priorValue, that.priorValue) && Arrays.equals(this.oldValue, that.oldValue) && Arrays.equals(this.newValue, that.newValue) && Objects.equals(this.recordContext, that.recordContext);
    }

    public int hashCode() {
        int result = Objects.hash(this.recordContext);
        result = 31 * result + Arrays.hashCode(this.priorValue);
        result = 31 * result + Arrays.hashCode(this.oldValue);
        result = 31 * result + Arrays.hashCode(this.newValue);
        return result;
    }

    public String toString() {
        return "BufferValue{priorValue=" + Arrays.toString(this.priorValue) + ", oldValue=" + Arrays.toString(this.oldValue) + ", newValue=" + Arrays.toString(this.newValue) + ", recordContext=" + this.recordContext + '}';
    }
}

