/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;

public class MockKeyValueStore
implements KeyValueStore {
    private static final AtomicInteger GLOBAL_FLUSH_COUNTER = new AtomicInteger(0);
    private final AtomicInteger instanceLastFlushCount = new AtomicInteger(-1);
    private final String name;
    private final boolean persistent;
    public boolean initialized = false;
    public boolean flushed = false;
    public boolean closed = true;
    public final ArrayList<Integer> keys = new ArrayList();
    public final ArrayList<byte[]> values = new ArrayList();
    private final boolean simulateForwardOnFlush;
    private RecordCollector collector;
    public final StateRestoreCallback stateRestoreCallback = new StateRestoreCallback(){
        private final Deserializer<Integer> deserializer = new IntegerDeserializer();

        public void restore(byte[] key, byte[] value) {
            MockKeyValueStore.this.keys.add((Integer)this.deserializer.deserialize("", key));
            MockKeyValueStore.this.values.add(value);
        }
    };

    public MockKeyValueStore(String name, boolean persistent) {
        this.name = name;
        this.persistent = persistent;
        this.simulateForwardOnFlush = false;
    }

    public MockKeyValueStore(String name, boolean persistent, boolean simulateForwardOnFlush) {
        this.name = name;
        this.persistent = persistent;
        this.simulateForwardOnFlush = simulateForwardOnFlush;
    }

    public String name() {
        return this.name;
    }

    public void init(ProcessorContext context, StateStore root) {
        context.register(root, this.stateRestoreCallback);
        if (this.simulateForwardOnFlush) {
            this.collector = ((RecordCollector.Supplier)context).recordCollector();
        }
        this.initialized = true;
        this.closed = false;
    }

    public void flush() {
        if (this.simulateForwardOnFlush) {
            this.collector.send("any", (Object)"anykey", (Object)"anyvalue", null, Integer.valueOf(0), Long.valueOf(0L), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        }
        this.instanceLastFlushCount.set(GLOBAL_FLUSH_COUNTER.getAndIncrement());
        this.flushed = true;
    }

    public int getLastFlushCount() {
        return this.instanceLastFlushCount.get();
    }

    public void close() {
        this.closed = true;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void put(Object key, Object value) {
    }

    public Object putIfAbsent(Object key, Object value) {
        return null;
    }

    public Object delete(Object key) {
        return null;
    }

    public void putAll(List entries) {
    }

    public Object get(Object key) {
        return null;
    }

    public KeyValueIterator range(Object from, Object to) {
        return null;
    }

    public KeyValueIterator all() {
        return null;
    }

    public long approximateNumEntries() {
        return 0L;
    }
}

