/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class MockInternalProcessorContext
extends MockProcessorContext
implements InternalProcessorContext {
    private final Map<String, StateRestoreCallback> restoreCallbacks = new LinkedHashMap<String, StateRestoreCallback>();
    private ProcessorNode currentNode;
    private RecordCollector recordCollector;

    public MockInternalProcessorContext() {
    }

    public MockInternalProcessorContext(Properties config, TaskId taskId, File stateDir) {
        super(config, taskId, stateDir);
    }

    public StreamsMetricsImpl metrics() {
        return (StreamsMetricsImpl)super.metrics();
    }

    public ProcessorRecordContext recordContext() {
        return new ProcessorRecordContext(this.timestamp(), this.offset(), this.partition(), this.topic(), this.headers());
    }

    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.setRecordMetadata(recordContext.topic(), recordContext.partition(), recordContext.offset(), recordContext.headers(), recordContext.timestamp());
    }

    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    public ProcessorNode currentNode() {
        return this.currentNode;
    }

    public ThreadCache getCache() {
        return null;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }

    public RecordCollector recordCollector() {
        return this.recordCollector;
    }

    public void setRecordCollector(RecordCollector recordCollector) {
        this.recordCollector = recordCollector;
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.restoreCallbacks.put(store.name(), stateRestoreCallback);
        super.register(store, stateRestoreCallback);
    }

    public StateRestoreCallback stateRestoreCallback(String storeName) {
        return this.restoreCallbacks.get(storeName);
    }

    public static final class MockRecordCollector
    implements RecordCollector {
        private final List<ProducerRecord<byte[], byte[]>> collected = new LinkedList<ProducerRecord<byte[], byte[]>>();

        public <K, V> void send(String topic, K key, V value, Headers headers, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.collected.add((ProducerRecord<byte[], byte[]>)new ProducerRecord(topic, partition, timestamp, (Object)keySerializer.serialize(topic, key), (Object)valueSerializer.serialize(topic, value), (Iterable)headers));
        }

        public <K, V> void send(String topic, K key, V value, Headers headers, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer, StreamPartitioner<? super K, ? super V> partitioner) {
            throw new UnsupportedOperationException();
        }

        public void init(Producer<byte[], byte[]> producer) {
        }

        public void flush() {
        }

        public void close() {
        }

        public Map<TopicPartition, Long> offsets() {
            return null;
        }

        public List<ProducerRecord<byte[], byte[]>> collected() {
            return Collections.unmodifiableList(this.collected);
        }
    }
}

