/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.internals.RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Logger;
import org.rocksdb.Options;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.RateLimiter;
import org.rocksdb.RemoveEmptyValueCompactionFilter;
import org.rocksdb.SstFileManager;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.VectorMemTableConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WriteBufferManager;
import org.rocksdb.util.BytewiseComparator;

@RunWith(value=EasyMockRunner.class)
public class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapterTest {
    private final List<String> ignoreMethods = new LinkedList<String>(){
        {
            this.add("isOwningHandle");
            this.add("dispose");
            this.add("wait");
            this.add("equals");
            this.add("getClass");
            this.add("hashCode");
            this.add("notify");
            this.add("notifyAll");
            this.add("toString");
        }
    };

    @Test
    public void shouldOverwriteAllOptionsMethods() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
    }

    @Test
    public void shouldForwardAllDbOptionsCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                DBOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyDBOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void verifyDBOptionsMethodCall(Method method) throws Exception {
        DBOptions mockedDbOptions = (DBOptions)EasyMock.mock(DBOptions.class);
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeDbOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(mockedDbOptions, new ColumnFamilyOptions());
        Object[] parameters = this.getDBOptionsParameters(method.getParameterTypes());
        try {
            EasyMock.reset((Object[])new Object[]{mockedDbOptions});
            EasyMock.replay((Object[])new Object[]{mockedDbOptions});
            method.invoke((Object)optionsFacadeDbOptions, parameters);
            EasyMock.verify((Object[])new Object[0]);
            Assert.fail((String)("Should have called DBOptions." + method.getName() + "()"));
        }
        catch (InvocationTargetException undeclaredMockMethodCall) {
            MatcherAssert.assertThat((Object)undeclaredMockMethodCall.getCause(), (Matcher)Matchers.instanceOf(AssertionError.class));
            MatcherAssert.assertThat((Object)undeclaredMockMethodCall.getCause().getMessage().trim(), (Matcher)Matchers.matchesPattern((String)("Unexpected method call DBOptions\\." + method.getName() + "((.*\n*)*):")));
        }
    }

    private Object[] getDBOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block30: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block30;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block30;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block30;
                }
                case "java.util.Collection": {
                    parameters[i] = new ArrayList();
                    continue block30;
                }
                case "org.rocksdb.AccessHint": {
                    parameters[i] = AccessHint.NONE;
                    continue block30;
                }
                case "org.rocksdb.Cache": {
                    parameters[i] = new LRUCache(1L);
                    continue block30;
                }
                case "org.rocksdb.Env": {
                    parameters[i] = Env.getDefault();
                    continue block30;
                }
                case "org.rocksdb.InfoLogLevel": {
                    parameters[i] = InfoLogLevel.FATAL_LEVEL;
                    continue block30;
                }
                case "org.rocksdb.Logger": {
                    parameters[i] = new Logger(new Options()){

                        protected void log(InfoLogLevel infoLogLevel, String logMsg) {
                        }
                    };
                    continue block30;
                }
                case "org.rocksdb.RateLimiter": {
                    parameters[i] = new RateLimiter(1L);
                    continue block30;
                }
                case "org.rocksdb.SstFileManager": {
                    parameters[i] = new SstFileManager(Env.getDefault());
                    continue block30;
                }
                case "org.rocksdb.WALRecoveryMode": {
                    parameters[i] = WALRecoveryMode.AbsoluteConsistency;
                    continue block30;
                }
                case "org.rocksdb.WriteBufferManager": {
                    parameters[i] = new WriteBufferManager(1L, (Cache)new LRUCache(1L));
                    continue block30;
                }
                default: {
                    parameters[i] = parameterTypes[i].newInstance();
                }
            }
        }
        return parameters;
    }

    @Test
    public void shouldForwardAllColumnFamilyCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                ColumnFamilyOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyColumnFamilyOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void verifyColumnFamilyOptionsMethodCall(Method method) throws Exception {
        ColumnFamilyOptions mockedColumnFamilyOptions = (ColumnFamilyOptions)EasyMock.mock(ColumnFamilyOptions.class);
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeColumnFamilyOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(new DBOptions(), mockedColumnFamilyOptions);
        Object[] parameters = this.getColumnFamilyOptionsParameters(method.getParameterTypes());
        try {
            EasyMock.reset((Object[])new Object[]{mockedColumnFamilyOptions});
            EasyMock.replay((Object[])new Object[]{mockedColumnFamilyOptions});
            method.invoke((Object)optionsFacadeColumnFamilyOptions, parameters);
            EasyMock.verify((Object[])new Object[0]);
            Assert.fail((String)("Should have called ColumnFamilyOptions." + method.getName() + "()"));
        }
        catch (InvocationTargetException undeclaredMockMethodCall) {
            MatcherAssert.assertThat((Object)undeclaredMockMethodCall.getCause(), (Matcher)Matchers.instanceOf(AssertionError.class));
            MatcherAssert.assertThat((Object)undeclaredMockMethodCall.getCause().getMessage().trim(), (Matcher)Matchers.matchesPattern((String)("Unexpected method call ColumnFamilyOptions\\." + method.getName() + "(.*)")));
        }
    }

    private Object[] getColumnFamilyOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block36: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block36;
                }
                case "double": {
                    parameters[i] = 0.0;
                    continue block36;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block36;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block36;
                }
                case "[I": {
                    parameters[i] = new int[0];
                    continue block36;
                }
                case "java.util.List": {
                    parameters[i] = new ArrayList();
                    continue block36;
                }
                case "org.rocksdb.AbstractCompactionFilter": {
                    parameters[i] = new RemoveEmptyValueCompactionFilter();
                    continue block36;
                }
                case "org.rocksdb.AbstractCompactionFilterFactory": {
                    parameters[i] = new AbstractCompactionFilterFactory(){

                        public AbstractCompactionFilter<?> createCompactionFilter(AbstractCompactionFilter.Context context) {
                            return null;
                        }

                        public String name() {
                            return "AbstractCompactionFilterFactory";
                        }
                    };
                    continue block36;
                }
                case "org.rocksdb.AbstractComparator": {
                    parameters[i] = new BytewiseComparator(new ComparatorOptions());
                    continue block36;
                }
                case "org.rocksdb.BuiltinComparator": {
                    parameters[i] = BuiltinComparator.BYTEWISE_COMPARATOR;
                    continue block36;
                }
                case "org.rocksdb.CompactionPriority": {
                    parameters[i] = CompactionPriority.ByCompensatedSize;
                    continue block36;
                }
                case "org.rocksdb.CompactionStyle": {
                    parameters[i] = CompactionStyle.UNIVERSAL;
                    continue block36;
                }
                case "org.rocksdb.CompressionType": {
                    parameters[i] = CompressionType.NO_COMPRESSION;
                    continue block36;
                }
                case "org.rocksdb.MemTableConfig": {
                    parameters[i] = new VectorMemTableConfig();
                    continue block36;
                }
                case "org.rocksdb.MergeOperator": {
                    parameters[i] = new StringAppendOperator();
                    continue block36;
                }
                case "org.rocksdb.TableFormatConfig": {
                    parameters[i] = new PlainTableConfig();
                    continue block36;
                }
                default: {
                    parameters[i] = parameterTypes[i].newInstance();
                }
            }
        }
        return parameters;
    }

    @Test
    public void shouldWarnThanMethodCompactionOptionsFIFOSetTtlWillBeRemoved() {
        DBOptions mockedDbOptions = (DBOptions)EasyMock.mock(DBOptions.class);
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeDbOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(mockedDbOptions, new ColumnFamilyOptions());
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        optionsFacadeDbOptions.setCompactionOptionsFIFO(new CompactionOptionsFIFO());
        LogCaptureAppender.unregister(appender);
        MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"RocksDB's version will be bumped to version 6+ via KAFKA-8897 in a future release. If you use `org.rocksdb.CompactionOptionsFIFO#setTtl(long)` or `#ttl()` you will need to rewrite your code after KAFKA-8897 is resolved and set TTL via `org.rocksdb.Options` (or `org.rocksdb.ColumnFamilyOptions`)."));
    }

    @Test
    public void shouldWarnThanMethodCompactionOptionsFIFOTtlWillBeRemoved() {
        DBOptions mockedDbOptions = (DBOptions)EasyMock.mock(DBOptions.class);
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeDbOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(mockedDbOptions, new ColumnFamilyOptions());
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        optionsFacadeDbOptions.compactionOptionsFIFO();
        LogCaptureAppender.unregister(appender);
        MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"RocksDB's version will be bumped to version 6+ via KAFKA-8897 in a future release. If you use `org.rocksdb.CompactionOptionsFIFO#setTtl(long)` or `#ttl()` you will need to rewrite your code after KAFKA-8897 is resolved and set TTL via `org.rocksdb.Options` (or `org.rocksdb.ColumnFamilyOptions`)."));
    }
}

