/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.InMemorySessionBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemorySessionStore;
import org.apache.kafka.streams.state.internals.SessionBytesStoreTest;
import org.junit.Assert;
import org.junit.Test;

public class InMemorySessionStoreTest
extends SessionBytesStoreTest {
    private static final String STORE_NAME = "in-memory session store";

    @Override
    <K, V> SessionStore<K, V> buildSessionStore(long retentionPeriod, Serde<K> keySerde, Serde<V> valueSerde) {
        return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.inMemorySessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod)), keySerde, valueSerde).build();
    }

    @Override
    String getMetricsScope() {
        return new InMemorySessionBytesStoreSupplier(null, 0L).metricsScope();
    }

    @Override
    void setClassLoggerToDebug() {
        LogCaptureAppender.setClassLoggerToDebug(InMemorySessionStore.class);
    }

    @Test
    public void shouldRemoveExpired() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 10000L)), (Object)4L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, Long.MAX_VALUE);){
            Assert.assertEquals(InMemorySessionStoreTest.valuesToSet(iterator), new HashSet<Long>(Arrays.asList(2L, 3L, 4L)));
        }
    }

    @Test
    public void shouldNotExpireFromOpenIterator() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, 10000L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(100L, 20000L)), (Object)4L);
        Assert.assertEquals(InMemorySessionStoreTest.valuesToSet(iterator), new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L)));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        Assert.assertFalse((boolean)this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, 20L).hasNext());
    }
}

