/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.Windows;
import org.junit.Assert;
import org.junit.Test;

public class StreamsGraphTest {
    private final Pattern repartitionTopicPattern = Pattern.compile("Sink: .*-repartition");
    private String expectedJoinedTopology = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-WINDOWED-0000000002\n    Source: KSTREAM-SOURCE-0000000001 (topics: [other-topic])\n      --> KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-WINDOWED-0000000002 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-JOINTHIS-0000000004\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-WINDOWED-0000000003 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-JOINOTHER-0000000005\n      <-- KSTREAM-SOURCE-0000000001\n    Processor: KSTREAM-JOINOTHER-0000000005 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-JOINTHIS-0000000004 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000002\n    Processor: KSTREAM-MERGE-0000000006 (stores: [])\n      --> none\n      <-- KSTREAM-JOINTHIS-0000000004, KSTREAM-JOINOTHER-0000000005\n\n";
    private String expectedJoinedFilteredTopology = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-WINDOWED-0000000002\n    Source: KSTREAM-SOURCE-0000000001 (topics: [other-topic])\n      --> KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-WINDOWED-0000000002 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-JOINTHIS-0000000004\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-WINDOWED-0000000003 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-JOINOTHER-0000000005\n      <-- KSTREAM-SOURCE-0000000001\n    Processor: KSTREAM-JOINOTHER-0000000005 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-JOINTHIS-0000000004 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000002\n    Processor: KSTREAM-MERGE-0000000006 (stores: [])\n      --> KSTREAM-FILTER-0000000007\n      <-- KSTREAM-JOINTHIS-0000000004, KSTREAM-JOINOTHER-0000000005\n    Processor: KSTREAM-FILTER-0000000007 (stores: [])\n      --> none\n      <-- KSTREAM-MERGE-0000000006\n\n";
    private String expectedFullTopology = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [topic])\n      --> KSTREAM-WINDOWED-0000000002\n    Source: KSTREAM-SOURCE-0000000001 (topics: [other-topic])\n      --> KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-WINDOWED-0000000002 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-JOINTHIS-0000000004\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-WINDOWED-0000000003 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-JOINOTHER-0000000005\n      <-- KSTREAM-SOURCE-0000000001\n    Processor: KSTREAM-JOINOTHER-0000000005 (stores: [KSTREAM-JOINTHIS-0000000004-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000003\n    Processor: KSTREAM-JOINTHIS-0000000004 (stores: [KSTREAM-JOINOTHER-0000000005-store])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-WINDOWED-0000000002\n    Processor: KSTREAM-MERGE-0000000006 (stores: [])\n      --> KSTREAM-FILTER-0000000007\n      <-- KSTREAM-JOINTHIS-0000000004, KSTREAM-JOINOTHER-0000000005\n    Processor: KSTREAM-FILTER-0000000007 (stores: [])\n      --> KSTREAM-MAPVALUES-0000000008\n      <-- KSTREAM-MERGE-0000000006\n    Processor: KSTREAM-MAPVALUES-0000000008 (stores: [])\n      --> KSTREAM-SINK-0000000009\n      <-- KSTREAM-FILTER-0000000007\n    Sink: KSTREAM-SINK-0000000009 (topic: output-topic)\n      <-- KSTREAM-MAPVALUES-0000000008\n\n";
    private String expectedMergeOptimizedTopology = "Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input_topic])\n      --> KSTREAM-KEY-SELECT-0000000001\n    Processor: KSTREAM-KEY-SELECT-0000000001 (stores: [])\n      --> KSTREAM-MAPVALUES-0000000002, KSTREAM-MAPVALUES-0000000003, KSTREAM-MAPVALUES-0000000004\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-MAPVALUES-0000000002 (stores: [])\n      --> KSTREAM-MERGE-0000000005\n      <-- KSTREAM-KEY-SELECT-0000000001\n    Processor: KSTREAM-MAPVALUES-0000000003 (stores: [])\n      --> KSTREAM-MERGE-0000000005\n      <-- KSTREAM-KEY-SELECT-0000000001\n    Processor: KSTREAM-MAPVALUES-0000000004 (stores: [])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-KEY-SELECT-0000000001\n    Processor: KSTREAM-MERGE-0000000005 (stores: [])\n      --> KSTREAM-MERGE-0000000006\n      <-- KSTREAM-MAPVALUES-0000000002, KSTREAM-MAPVALUES-0000000003\n    Processor: KSTREAM-MERGE-0000000006 (stores: [])\n      --> KSTREAM-SINK-0000000007\n      <-- KSTREAM-MERGE-0000000005, KSTREAM-MAPVALUES-0000000004\n    Sink: KSTREAM-SINK-0000000007 (topic: output_topic)\n      <-- KSTREAM-MERGE-0000000006\n\n";

    @Test
    public void shouldBeAbleToBuildTopologyIncrementally() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("topic");
        KStream streamII = builder.stream("other-topic");
        ValueJoiner valueJoiner = (v, v2) -> v + v2;
        KStream joinedStream = stream.join(streamII, valueJoiner, JoinWindows.of((Duration)Duration.ofMillis(5000L)));
        Assert.assertEquals((Object)this.expectedJoinedTopology, (Object)builder.build().describe().toString());
        KStream filteredJoinStream = joinedStream.filter((k, v) -> v.equals("foo"));
        Assert.assertEquals((Object)this.expectedJoinedFilteredTopology, (Object)builder.build().describe().toString());
        filteredJoinStream.mapValues(v -> v + "some value").to("output-topic");
        Assert.assertEquals((Object)this.expectedFullTopology, (Object)builder.build().describe().toString());
    }

    @Test
    public void shouldBeAbleToProcessNestedMultipleKeyChangingNodes() {
        Properties properties = new Properties();
        properties.setProperty("application.id", "test-application");
        properties.setProperty("bootstrap.servers", "localhost:9092");
        properties.setProperty("topology.optimization", "all");
        StreamsBuilder builder = new StreamsBuilder();
        KStream inputStream = builder.stream("inputTopic");
        KStream changedKeyStream = inputStream.selectKey((k, v) -> v.substring(0, 5));
        changedKeyStream.groupByKey(Grouped.as((String)"count-repartition")).count(Materialized.as((String)"count-store")).toStream().to("count-topic", Produced.with((Serde)Serdes.String(), (Serde)Serdes.Long()));
        changedKeyStream.groupByKey(Grouped.as((String)"windowed-repartition")).windowedBy((Windows)TimeWindows.of((Duration)Duration.ofSeconds(5L))).count(Materialized.as((String)"windowed-count-store")).toStream().map((k, v) -> KeyValue.pair((Object)k.key(), (Object)v)).to("windowed-count", Produced.with((Serde)Serdes.String(), (Serde)Serdes.Long()));
        builder.build(properties);
    }

    @Test
    public void shouldNotOptimizeWithValueOrKeyChangingOperatorsAfterInitialKeyChange() {
        Topology attemptedOptimize = this.getTopologyWithChangingValuesAfterChangingKey("all");
        Topology noOptimization = this.getTopologyWithChangingValuesAfterChangingKey("none");
        Assert.assertEquals((Object)attemptedOptimize.describe().toString(), (Object)noOptimization.describe().toString());
        Assert.assertEquals((long)2L, (long)this.getCountOfRepartitionTopicsFound(attemptedOptimize.describe().toString()));
        Assert.assertEquals((long)2L, (long)this.getCountOfRepartitionTopicsFound(noOptimization.describe().toString()));
    }

    @Test
    public void shouldNotOptimizeWhenAThroughOperationIsDone() {
        Topology attemptedOptimize = this.getTopologyWithThroughOperation("all");
        Topology noOptimziation = this.getTopologyWithThroughOperation("none");
        Assert.assertEquals((Object)attemptedOptimize.describe().toString(), (Object)noOptimziation.describe().toString());
        Assert.assertEquals((long)0L, (long)this.getCountOfRepartitionTopicsFound(attemptedOptimize.describe().toString()));
        Assert.assertEquals((long)0L, (long)this.getCountOfRepartitionTopicsFound(noOptimziation.describe().toString()));
    }

    @Test
    public void shouldOptimizeSeveralMergeNodesWithCommonKeyChangingParent() {
        StreamsBuilder streamsBuilder = new StreamsBuilder();
        KStream parentStream = streamsBuilder.stream("input_topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer())).selectKey(Integer::sum);
        KStream childStream1 = parentStream.mapValues(v -> v + 1);
        KStream childStream2 = parentStream.mapValues(v -> v + 2);
        KStream childStream3 = parentStream.mapValues(v -> v + 3);
        childStream1.merge(childStream2).merge(childStream3).to("output_topic");
        Properties properties = new Properties();
        properties.setProperty("topology.optimization", "all");
        Topology topology = streamsBuilder.build(properties);
        Assert.assertEquals((Object)this.expectedMergeOptimizedTopology, (Object)topology.describe().toString());
    }

    private Topology getTopologyWithChangingValuesAfterChangingKey(String optimizeConfig) {
        StreamsBuilder builder = new StreamsBuilder();
        Properties properties = new Properties();
        properties.put("topology.optimization", optimizeConfig);
        KStream inputStream = builder.stream("input");
        KStream mappedKeyStream = inputStream.selectKey((k, v) -> k + v);
        mappedKeyStream.mapValues(v -> v.toUpperCase(Locale.getDefault())).groupByKey().count().toStream().to("output");
        mappedKeyStream.flatMapValues(v -> Arrays.asList(v.split("\\s"))).groupByKey().windowedBy((Windows)TimeWindows.of((Duration)Duration.ofMillis(5000L))).count().toStream().to("windowed-output");
        return builder.build(properties);
    }

    private Topology getTopologyWithThroughOperation(String optimizeConfig) {
        StreamsBuilder builder = new StreamsBuilder();
        Properties properties = new Properties();
        properties.put("topology.optimization", optimizeConfig);
        KStream inputStream = builder.stream("input");
        KStream mappedKeyStream = inputStream.selectKey((k, v) -> k + v).through("through-topic");
        mappedKeyStream.groupByKey().count().toStream().to("output");
        mappedKeyStream.groupByKey().windowedBy((Windows)TimeWindows.of((Duration)Duration.ofMillis(5000L))).count().toStream().to("windowed-output");
        return builder.build(properties);
    }

    private int getCountOfRepartitionTopicsFound(String topologyString) {
        Matcher matcher = this.repartitionTopicPattern.matcher(topologyString);
        ArrayList<String> repartitionTopicsFound = new ArrayList<String>();
        while (matcher.find()) {
            repartitionTopicsFound.add(matcher.group());
        }
        return repartitionTopicsFound.size();
    }
}

