/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionWindowedDeserializerTest {
    private final SessionWindowedDeserializer<?> sessionWindowedDeserializer = new SessionWindowedDeserializer();
    private final Map<String, String> props = new HashMap<String, String>();

    @Before
    public void setUp() {
        this.props.put("default.windowed.key.serde.inner", Serdes.StringSerde.class.getName());
        this.props.put("default.windowed.value.serde.inner", Serdes.ByteArraySerde.class.getName());
    }

    @Test
    public void testWindowedKeyDeserializerNoArgConstructors() {
        this.sessionWindowedDeserializer.configure(this.props, true);
        Deserializer inner = this.sessionWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be StringDeserializer", (boolean)(inner instanceof StringDeserializer));
    }

    @Test
    public void testWindowedValueDeserializerNoArgConstructors() {
        this.sessionWindowedDeserializer.configure(this.props, false);
        Deserializer inner = this.sessionWindowedDeserializer.innerDeserializer();
        Assert.assertNotNull((String)"Inner deserializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner deserializer type should be ByteArrayDeserializer", (boolean)(inner instanceof ByteArrayDeserializer));
    }
}

