/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StreamsMetricsImpl.class})
public class ThreadMetricsTest {
    private static final String THREAD_ID = "thread-id";
    private static final String THREAD_LEVEL_GROUP = "stream-metrics";
    private static final String TASK_LEVEL_GROUP = "stream-task-metrics";
    private final Metrics dummyMetrics = new Metrics();
    private final Sensor dummySensor = this.dummyMetrics.sensor("dummy");
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createStrictMock(StreamsMetricsImpl.class);
    private final Map<String, String> dummyTagMap = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetCreateTaskSensor() {
        String operation = "task-created";
        String totalDescription = "The total number of newly created tasks";
        String rateDescription = "The average per-second number of newly created tasks";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-created", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"task-created", (String)"The total number of newly created tasks", (String)"The average per-second number of newly created tasks");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.createTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetCloseTaskSensor() {
        String operation = "task-closed";
        String totalDescription = "The total number of closed tasks";
        String rateDescription = "The average per-second number of closed tasks";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-closed", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"task-closed", (String)"The total number of closed tasks", (String)"The average per-second number of closed tasks");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.closeTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetCommitSensor() {
        String operation = "commit";
        String operationLatency = "commit-latency";
        String totalDescription = "The total number of commit calls";
        String rateDescription = "The average per-second number of commit calls";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"commit", (String)"The total number of commit calls", (String)"The average per-second number of commit calls");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"commit-latency");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.commitSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetPollSensor() {
        String operation = "poll";
        String operationLatency = "poll-latency";
        String totalDescription = "The total number of poll calls";
        String rateDescription = "The average per-second number of poll calls";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"poll", (String)"The total number of poll calls", (String)"The average per-second number of poll calls");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"poll-latency");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.pollSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetProcessSensor() {
        String operation = "process";
        String operationLatency = "process-latency";
        String totalDescription = "The total number of process calls";
        String rateDescription = "The average per-second number of process calls";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"process", (String)"The total number of process calls", (String)"The average per-second number of process calls");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"process-latency");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.processSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String operation = "punctuate";
        String operationLatency = "punctuate-latency";
        String totalDescription = "The total number of punctuate calls";
        String rateDescription = "The average per-second number of punctuate calls";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "punctuate", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"punctuate", (String)"The total number of punctuate calls", (String)"The average per-second number of punctuate calls");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"punctuate-latency");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.punctuateSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetSkipRecordSensor() {
        String operation = "skipped-records";
        String totalDescription = "The total number of skipped records";
        String rateDescription = "The average per-second number of skipped records";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "skipped-records", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)THREAD_LEVEL_GROUP, this.dummyTagMap, (String)"skipped-records", (String)"The total number of skipped records", (String)"The average per-second number of skipped records");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.skipRecordSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }

    @Test
    public void shouldGetCommitOverTasksSensor() {
        String operation = "commit";
        String operationLatency = "commit-latency";
        String totalDescription = "The total number of commit calls over all tasks";
        String rateDescription = "The average per-second number of commit calls over all tasks";
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.dummySensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID, new String[]{"task-id", "all"})).andReturn(this.dummyTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.dummySensor, (String)TASK_LEVEL_GROUP, this.dummyTagMap, (String)"commit", (String)"The total number of commit calls over all tasks", (String)"The average per-second number of commit calls over all tasks");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.dummySensor, (String)TASK_LEVEL_GROUP, this.dummyTagMap, (String)"commit-latency");
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = ThreadMetrics.commitOverTasksSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.dummySensor));
    }
}

