/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.CompositeRestoreListener;
import org.apache.kafka.streams.processor.internals.StateRestorer;
import org.apache.kafka.streams.state.internals.RecordConverters;
import org.apache.kafka.test.MockRestoreCallback;
import org.apache.kafka.test.MockStateRestoreListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateRestorerTest {
    private static final long OFFSET_LIMIT = 50L;
    private final MockRestoreCallback callback = new MockRestoreCallback();
    private final MockStateRestoreListener reportingListener = new MockStateRestoreListener();
    private final CompositeRestoreListener compositeRestoreListener = new CompositeRestoreListener((StateRestoreCallback)this.callback);
    private final StateRestorer restorer = new StateRestorer(new TopicPartition("topic", 1), this.compositeRestoreListener, null, 50L, true, "storeName", RecordConverters.identity());

    @Before
    public void setUp() {
        this.compositeRestoreListener.setUserRestoreListener((StateRestoreListener)this.reportingListener);
    }

    @Test
    public void shouldCallRestoreOnRestoreCallback() {
        this.restorer.restore(Collections.singletonList(new ConsumerRecord("", 0, 0L, (Object)new byte[0], (Object)new byte[0])));
        MatcherAssert.assertThat((Object)this.callback.restored.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldBeCompletedIfRecordOffsetGreaterThanEndOffset() {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(11L, 10L));
    }

    @Test
    public void shouldBeCompletedIfRecordOffsetGreaterThanOffsetLimit() {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(51L, 100L));
    }

    @Test
    public void shouldBeCompletedIfEndOffsetAndRecordOffsetAreZero() {
        Assert.assertTrue((boolean)this.restorer.hasCompleted(0L, 0L));
    }

    @Test
    public void shouldBeCompletedIfOffsetAndOffsetLimitAreZero() {
        StateRestorer restorer = new StateRestorer(new TopicPartition("topic", 1), this.compositeRestoreListener, null, 0L, true, "storeName", RecordConverters.identity());
        Assert.assertTrue((boolean)restorer.hasCompleted(0L, 10L));
    }

    @Test
    public void shouldSetRestoredOffsetToMinOfLimitAndOffset() {
        this.restorer.setRestoredOffset(20L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)50L));
    }

    @Test
    public void shouldSetStartingOffsetToMinOfLimitAndOffset() {
        this.restorer.setStartingOffset(20L);
        MatcherAssert.assertThat((Object)this.restorer.startingOffset(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredOffset(), (Matcher)CoreMatchers.equalTo((Object)50L));
    }

    @Test
    public void shouldReturnCorrectNumRestoredRecords() {
        this.restorer.setStartingOffset(20L);
        this.restorer.setRestoredOffset(40L);
        MatcherAssert.assertThat((Object)this.restorer.restoredNumRecords(), (Matcher)CoreMatchers.equalTo((Object)20L));
        this.restorer.setRestoredOffset(100L);
        MatcherAssert.assertThat((Object)this.restorer.restoredNumRecords(), (Matcher)CoreMatchers.equalTo((Object)30L));
    }
}

