/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.test.MockProcessor;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamKTableJoinTest {
    private static final KeyValueTimestamp[] EMPTY = new KeyValueTimestamp[0];
    private final String streamTopic = "streamTopic";
    private final String tableTopic = "tableTopic";
    private TestInputTopic<Integer, String> inputStreamTopic;
    private TestInputTopic<Integer, String> inputTableTopic;
    private final int[] expectedKeys = new int[]{0, 1, 2, 3};
    private MockProcessor<Integer, String> processor;
    private TopologyTestDriver driver;
    private StreamsBuilder builder;

    @Before
    public void setUp() {
        this.builder = new StreamsBuilder();
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        Consumed consumed = Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String());
        KStream stream = this.builder.stream("streamTopic", consumed);
        KTable table = this.builder.table("tableTopic", consumed);
        stream.join(table, MockValueJoiner.TOSTRING_JOINER).process(supplier, new String[0]);
        Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());
        this.driver = new TopologyTestDriver(this.builder.build(), props);
        this.inputStreamTopic = this.driver.createInputTopic("streamTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.inputTableTopic = this.driver.createInputTopic("tableTopic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
        this.processor = supplier.theCapturedProcessor();
    }

    @After
    public void cleanup() {
        this.driver.close();
    }

    private void pushToStream(int messageCount, String valuePrefix) {
        for (int i = 0; i < messageCount; ++i) {
            this.inputStreamTopic.pipeInput((Object)this.expectedKeys[i], (Object)(valuePrefix + this.expectedKeys[i]), (long)i);
        }
    }

    private void pushToTable(int messageCount, String valuePrefix) {
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < messageCount; ++i) {
            this.inputTableTopic.pipeInput((Object)this.expectedKeys[i], (Object)(valuePrefix + this.expectedKeys[i]), (long)r.nextInt(Integer.MAX_VALUE));
        }
    }

    private void pushNullValueToTable() {
        for (int i = 0; i < 2; ++i) {
            this.inputTableTopic.pipeInput((Object)this.expectedKeys[i], null);
        }
    }

    @Test
    public void shouldRequireCopartitionedStreams() {
        Collection copartitionGroups = TopologyWrapper.getInternalTopologyBuilder(this.builder.build()).copartitionGroups();
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("streamTopic", "tableTopic")), copartitionGroups.iterator().next());
    }

    @Test
    public void shouldNotJoinWithEmptyTableOnStreamUpdates() {
        this.pushToStream(2, "X");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldNotJoinOnTableUpdates() {
        this.pushToStream(2, "X");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
        this.pushToTable(4, "YY");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+YY0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+YY1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2+YY2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3+YY3", 3L));
        this.pushToTable(4, "YYY");
        this.processor.checkAndClearProcessResult(EMPTY);
    }

    @Test
    public void shouldJoinOnlyIfMatchFoundOnStreamUpdates() {
        this.pushToTable(2, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L));
    }

    @Test
    public void shouldClearTableEntryOnNullValueUpdates() {
        this.pushToTable(4, "Y");
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "X");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(0, "X0+Y0", 0L), new KeyValueTimestamp<Integer, String>(1, "X1+Y1", 1L), new KeyValueTimestamp<Integer, String>(2, "X2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "X3+Y3", 3L));
        this.pushNullValueToTable();
        this.processor.checkAndClearProcessResult(EMPTY);
        this.pushToStream(4, "XX");
        this.processor.checkAndClearProcessResult(new KeyValueTimestamp<Integer, String>(2, "XX2+Y2", 2L), new KeyValueTimestamp<Integer, String>(3, "XX3+Y3", 3L));
    }

    @Test
    public void shouldLogAndMeterWhenSkippingNullLeftKey() {
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.inputStreamTopic.pipeInput(null, (Object)"A");
        LogCaptureAppender.unregister(appender);
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByName(this.driver.metrics(), "skipped-records-total", "stream-metrics").metricValue());
        MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null key or value. key=[null] value=[A] topic=[streamTopic] partition=[0] offset=[0]"));
    }

    @Test
    public void shouldLogAndMeterWhenSkippingNullLeftValue() {
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.inputStreamTopic.pipeInput((Object)1, null);
        LogCaptureAppender.unregister(appender);
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByName(this.driver.metrics(), "skipped-records-total", "stream-metrics").metricValue());
        MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null key or value. key=[1] value=[null] topic=[streamTopic] partition=[0] offset=[0]"));
    }
}

