/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KTableKTableForeignKeyJoinIntegrationTest {
    private static final String LEFT_TABLE = "left_table";
    private static final String RIGHT_TABLE = "right_table";
    private static final String OUTPUT = "output-topic";
    private final Properties streamsConfig;
    private final boolean leftJoin;

    public KTableKTableForeignKeyJoinIntegrationTest(boolean leftJoin, String optimization) {
        this.leftJoin = leftJoin;
        this.streamsConfig = Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)"ktable-ktable-joinOnForeignKey"), Utils.mkEntry((Object)"bootstrap.servers", (Object)"asdf:0000"), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath()), Utils.mkEntry((Object)"topology.optimization", (Object)optimization)}));
    }

    @Parameterized.Parameters(name="leftJoin={0}, optimization={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false, "all"}, {false, "none"}, {true, "all"}, {true, "none"});
    }

    @Test
    public void doJoinFromLeftThenDeleteLeftEntity() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic right = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1");
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            right.pipeInput((Object)"rhs3", (Object)"rhsValue3");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2|rhs2");
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs3", (Object)"lhsValue3|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null)})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
        }
    }

    @Test
    public void doJoinFromRightThenDeleteRightEntity() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic right = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2|rhs2");
            left.pipeInput((Object)"lhs3", (Object)"lhsValue3|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,null)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,null)")}) : Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,null)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,null)")}) : Collections.emptyMap()));
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,null)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")}) : Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")}))));
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)")})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            right.pipeInput((Object)"rhs3", (Object)"rhsValue3");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            right.pipeInput((Object)"rhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)(this.leftJoin ? "(lhsValue1|rhs1,null)" : null)), Utils.mkEntry((Object)"lhs3", (Object)(this.leftJoin ? "(lhsValue3|rhs1,null)" : null))})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)"), Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,null)")}) : Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)")}))));
        }
    }

    @Test
    public void shouldEmitTombstoneWhenDeletingNonJoiningRecords() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            Map expected = this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)")}) : Collections.emptyMap();
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(expected));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null)})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        }
    }

    @Test
    public void shouldNotEmitTombstonesWhenDeletingNonExistingRecords() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        }
    }

    @Test
    public void joinShouldProduceNullsWhenValueHasNonMatchingForeignKey() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic right = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)")}) : Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,null)")}) : Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs2");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)(this.leftJoin ? "(lhsValue1|rhs2,null)" : null))})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs2,null)")}) : Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs3");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)(this.leftJoin ? "(lhsValue1|rhs3,null)" : null))})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs3,null)")}) : Collections.emptyMap()));
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs3,null)")}) : Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")})));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs2");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)(this.leftJoin ? "(lhsValue1|rhs2,null)" : null))})));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(this.leftJoin ? Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs2,null)")}) : Collections.emptyMap()));
        }
    }

    @Test
    public void shouldUnsubscribeOldForeignKeyIfLeftSideIsUpdated() {
        Topology topology = KTableKTableForeignKeyJoinIntegrationTest.getTopology(this.streamsConfig, "store", this.leftJoin);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic right = driver.createInputTopic(RIGHT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic(LEFT_TABLE, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic(OUTPUT, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1");
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs2");
            expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs2,rhsValue2)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1Delta");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            MatcherAssert.assertThat(KTableKTableForeignKeyJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs2,rhsValue2)")})));
        }
    }

    private static Map<String, String> asMap(KeyValueStore<String, String> store) {
        HashMap<String, String> result = new HashMap<String, String>();
        store.all().forEachRemaining(kv -> {
            String cfr_ignored_0 = (String)result.put((String)kv.key, (String)kv.value);
        });
        return result;
    }

    private static Topology getTopology(Properties streamsConfig, String queryableStoreName, boolean leftJoin) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable left = builder.table(LEFT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        KTable right = builder.table(RIGHT_TABLE, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        Function<String, String> extractor = value -> value.split("\\|")[1];
        ValueJoiner joiner = (value1, value2) -> "(" + value1 + "," + value2 + ")";
        Materialized materialized = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)queryableStoreName)).withValueSerde(Serdes.String()).withCachingDisabled();
        KTable joinResult = leftJoin ? left.leftJoin(right, extractor, joiner, materialized) : left.join(right, extractor, joiner, materialized);
        joinResult.toStream().to(OUTPUT);
        return builder.build(streamsConfig);
    }
}

