/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class GenericInMemoryTimestampedKeyValueStore<K extends Comparable, V>
extends WrappedStateStore<StateStore, K, ValueAndTimestamp<V>>
implements TimestampedKeyValueStore<K, V> {
    private final String name;
    private final NavigableMap<K, ValueAndTimestamp<V>> map;
    private volatile boolean open = false;

    public GenericInMemoryTimestampedKeyValueStore(String name) {
        super(null);
        this.name = name;
        this.map = new TreeMap<K, ValueAndTimestamp<V>>();
    }

    public String name() {
        return this.name;
    }

    public void init(ProcessorContext context, StateStore root) {
        if (root != null) {
            context.register(root, null);
        }
        this.open = true;
    }

    public boolean setFlushListener(CacheFlushListener<K, ValueAndTimestamp<V>> listener, boolean sendOldValues) {
        return false;
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized ValueAndTimestamp<V> get(K key) {
        return (ValueAndTimestamp)this.map.get(key);
    }

    public synchronized void put(K key, ValueAndTimestamp<V> value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public synchronized ValueAndTimestamp<V> putIfAbsent(K key, ValueAndTimestamp<V> value) {
        ValueAndTimestamp<V> originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    public synchronized void putAll(List<KeyValue<K, ValueAndTimestamp<V>>> entries) {
        for (KeyValue<K, ValueAndTimestamp<V>> entry : entries) {
            this.put((K)((Comparable)entry.key), (ValueAndTimestamp<V>)((ValueAndTimestamp)entry.value));
        }
    }

    public synchronized ValueAndTimestamp<V> delete(K key) {
        return (ValueAndTimestamp)this.map.remove(key);
    }

    public synchronized KeyValueIterator<K, ValueAndTimestamp<V>> range(K from, K to) {
        return new DelegatingPeekingKeyValueIterator(this.name, new GenericInMemoryKeyValueIterator(this.map.subMap(from, true, to, true).entrySet().iterator()));
    }

    public synchronized KeyValueIterator<K, ValueAndTimestamp<V>> all() {
        TreeMap<K, ValueAndTimestamp<V>> copy = new TreeMap<K, ValueAndTimestamp<V>>(this.map);
        return new DelegatingPeekingKeyValueIterator(this.name, new GenericInMemoryKeyValueIterator(copy.entrySet().iterator()));
    }

    public long approximateNumEntries() {
        return this.map.size();
    }

    public void flush() {
    }

    public void close() {
        this.map.clear();
        this.open = false;
    }

    private static class GenericInMemoryKeyValueIterator<K, V>
    implements KeyValueIterator<K, ValueAndTimestamp<V>> {
        private final Iterator<Map.Entry<K, ValueAndTimestamp<V>>> iter;

        private GenericInMemoryKeyValueIterator(Iterator<Map.Entry<K, ValueAndTimestamp<V>>> iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public KeyValue<K, ValueAndTimestamp<V>> next() {
            Map.Entry<K, ValueAndTimestamp<V>> entry = this.iter.next();
            return new KeyValue(entry.getKey(), entry.getValue());
        }

        public void remove() {
            this.iter.remove();
        }

        public void close() {
        }

        public K peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

