/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class CopartitionedTopicsValidatorTest {
    private final StreamsPartitionAssignor.CopartitionedTopicsValidator validator = new StreamsPartitionAssignor.CopartitionedTopicsValidator("thread");
    private final Map<TopicPartition, PartitionInfo> partitions = new HashMap<TopicPartition, PartitionInfo>();
    private final Cluster cluster = Cluster.empty();

    @Before
    public void before() {
        this.partitions.put(new TopicPartition("first", 0), new PartitionInfo("first", 0, null, null, null));
        this.partitions.put(new TopicPartition("first", 1), new PartitionInfo("first", 1, null, null, null));
        this.partitions.put(new TopicPartition("second", 0), new PartitionInfo("second", 0, null, null, null));
        this.partitions.put(new TopicPartition("second", 1), new PartitionInfo("second", 1, null, null, null));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowTopologyBuilderExceptionIfNoPartitionsFoundForCoPartitionedTopic() {
        this.validator.validate(Collections.singleton("topic"), Collections.emptyMap(), this.cluster);
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyBuilderExceptionIfPartitionCountsForCoPartitionedTopicsDontMatch() {
        this.partitions.remove(new TopicPartition("second", 0));
        this.validator.validate(Utils.mkSet((Object[])new String[]{"first", "second"}), Collections.emptyMap(), this.cluster.withPartitions(this.partitions));
    }

    @Test
    public void shouldEnforceCopartitioningOnRepartitionTopics() {
        StreamsPartitionAssignor.InternalTopicMetadata metadata = this.createTopicMetadata("repartitioned", 10);
        this.validator.validate(Utils.mkSet((Object[])new String[]{"first", "second", metadata.config.name()}), Collections.singletonMap(metadata.config.name(), metadata), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)metadata.numPartitions, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldSetNumPartitionsToMaximumPartitionsWhenAllTopicsAreRepartitionTopics() {
        StreamsPartitionAssignor.InternalTopicMetadata one = this.createTopicMetadata("one", 1);
        StreamsPartitionAssignor.InternalTopicMetadata two = this.createTopicMetadata("two", 15);
        StreamsPartitionAssignor.InternalTopicMetadata three = this.createTopicMetadata("three", 5);
        HashMap<String, StreamsPartitionAssignor.InternalTopicMetadata> repartitionTopicConfig = new HashMap<String, StreamsPartitionAssignor.InternalTopicMetadata>();
        repartitionTopicConfig.put(one.config.name(), one);
        repartitionTopicConfig.put(two.config.name(), two);
        repartitionTopicConfig.put(three.config.name(), three);
        this.validator.validate(Utils.mkSet((Object[])new String[]{one.config.name(), two.config.name(), three.config.name()}), repartitionTopicConfig, this.cluster);
        MatcherAssert.assertThat((Object)one.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)two.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)three.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
    }

    private StreamsPartitionAssignor.InternalTopicMetadata createTopicMetadata(String repartitionTopic, int partitions) {
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig(repartitionTopic, Collections.emptyMap());
        StreamsPartitionAssignor.InternalTopicMetadata metadata = new StreamsPartitionAssignor.InternalTopicMetadata((InternalTopicConfig)repartitionTopicConfig);
        metadata.numPartitions = partitions;
        return metadata;
    }
}

