/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.FullChangeSerde;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.suppress.KTableSuppressProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;

public class KTableSuppressProcessorMetricsTest {
    private static final long ARBITRARY_LONG = 5L;
    private static final MetricName EVICTION_TOTAL_METRIC = new MetricName("suppression-emit-total", "stream-processor-node-metrics", "The total number of occurrence of suppression-emit operations.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private static final MetricName EVICTION_RATE_METRIC = new MetricName("suppression-emit-rate", "stream-processor-node-metrics", "The average number of occurrence of suppression-emit operation per second.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private static final MetricName BUFFER_SIZE_AVG_METRIC = new MetricName("suppression-buffer-size-avg", "stream-buffer-metrics", "The average size of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private static final MetricName BUFFER_SIZE_CURRENT_METRIC = new MetricName("suppression-buffer-size-current", "stream-buffer-metrics", "The current size of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private static final MetricName BUFFER_SIZE_MAX_METRIC = new MetricName("suppression-buffer-size-max", "stream-buffer-metrics", "The max size of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private static final MetricName BUFFER_COUNT_AVG_METRIC = new MetricName("suppression-buffer-count-avg", "stream-buffer-metrics", "The average count of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private static final MetricName BUFFER_COUNT_CURRENT_METRIC = new MetricName("suppression-buffer-count-current", "stream-buffer-metrics", "The current count of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private static final MetricName BUFFER_COUNT_MAX_METRIC = new MetricName("suppression-buffer-count-max", "stream-buffer-metrics", "The max count of buffered records.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock-processor-context-virtual-thread"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));

    @Test
    public void shouldRecordMetrics() {
        String storeName = "test-store";
        StateStore buffer = new InMemoryTimeOrderedKeyValueBuffer.Builder("test-store", Serdes.String(), (Serde)FullChangeSerde.castOrWrap((Serde)Serdes.Long())).withLoggingDisabled().build();
        KTableImpl mock = (KTableImpl)EasyMock.mock(KTableImpl.class);
        Processor processor = new KTableSuppressProcessorSupplier((SuppressedInternal)Suppressed.untilTimeLimit((Duration)Duration.ofDays(100L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)1L)), "test-store", mock).get();
        MockInternalProcessorContext context = new MockInternalProcessorContext();
        context.setCurrentNode(new ProcessorNode("testNode"));
        buffer.init((ProcessorContext)context, buffer);
        processor.init((ProcessorContext)context);
        long timestamp = 100L;
        context.setRecordMetadata("", 0, 0L, null, 100L);
        String key = "longKey";
        Change value = new Change(null, (Object)5L);
        processor.process((Object)"longKey", (Object)value);
        Map metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, EVICTION_RATE_METRIC, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, EVICTION_TOTAL_METRIC, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_AVG_METRIC, Is.is((Object)29.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_CURRENT_METRIC, Is.is((Object)59.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_MAX_METRIC, Is.is((Object)59.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_AVG_METRIC, Is.is((Object)0.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_CURRENT_METRIC, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_MAX_METRIC, Is.is((Object)1.0));
        context.setRecordMetadata("", 0, 1L, null, 101L);
        processor.process((Object)"key", (Object)value);
        metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, EVICTION_RATE_METRIC, Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, EVICTION_TOTAL_METRIC, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_AVG_METRIC, Is.is((Object)57.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_CURRENT_METRIC, Is.is((Object)55.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_SIZE_MAX_METRIC, Is.is((Object)114.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_AVG_METRIC, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_CURRENT_METRIC, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, BUFFER_COUNT_MAX_METRIC, Is.is((Object)2.0));
    }

    private static <T> void verifyMetric(Map<MetricName, ? extends Metric> metrics, MetricName metricName, Matcher<T> matcher) {
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricName().description(), (Matcher)Is.is((Object)metricName.description()));
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricValue(), matcher);
    }
}

