/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Iterator;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.internals.TransformerSupplierAdapter;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.junit.Before;
import org.junit.Test;

public class TransformerSupplierAdapterTest
extends EasyMockSupport {
    private ProcessorContext context;
    private Transformer<String, String, KeyValue<Integer, Integer>> transformer;
    private TransformerSupplier<String, String, KeyValue<Integer, Integer>> transformerSupplier;
    final String key = "Hello";
    final String value = "World";

    @Before
    public void before() {
        this.context = (ProcessorContext)this.mock(ProcessorContext.class);
        this.transformer = (Transformer)this.mock(Transformer.class);
        this.transformerSupplier = (TransformerSupplier)this.mock(TransformerSupplier.class);
    }

    @Test
    public void shouldCallInitOfAdapteeTransformer() {
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn(this.transformer);
        this.transformer.init(this.context);
        this.replayAll();
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        adaptedTransformer.init(this.context);
        this.verifyAll();
    }

    @Test
    public void shouldCallCloseOfAdapteeTransformer() {
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn(this.transformer);
        this.transformer.close();
        this.replayAll();
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        adaptedTransformer.close();
        this.verifyAll();
    }

    @Test
    public void shouldCallTransformOfAdapteeTransformerAndReturnSingletonIterable() {
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn(this.transformer);
        EasyMock.expect((Object)this.transformer.transform((Object)"Hello", (Object)"World")).andReturn((Object)KeyValue.pair((Object)0, (Object)1));
        this.replayAll();
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        Iterator iterator = ((Iterable)adaptedTransformer.transform((Object)"Hello", (Object)"World")).iterator();
        this.verifyAll();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)true));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldCallTransformOfAdapteeTransformerAndReturnEmptyIterable() {
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn(this.transformer);
        EasyMock.expect((Object)this.transformer.transform((Object)"Hello", (Object)"World")).andReturn(null);
        this.replayAll();
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adaptedTransformer = adapter.get();
        Iterator iterator = ((Iterable)adaptedTransformer.transform((Object)"Hello", (Object)"World")).iterator();
        this.verifyAll();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldAlwaysGetNewAdapterTransformer() {
        Transformer transformer1 = (Transformer)this.mock(Transformer.class);
        Transformer transformer2 = (Transformer)this.mock(Transformer.class);
        Transformer transformer3 = (Transformer)this.mock(Transformer.class);
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn((Object)transformer1);
        transformer1.init(this.context);
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn((Object)transformer2);
        transformer2.init(this.context);
        EasyMock.expect((Object)this.transformerSupplier.get()).andReturn((Object)transformer3);
        transformer3.init(this.context);
        this.replayAll();
        TransformerSupplierAdapter adapter = new TransformerSupplierAdapter(this.transformerSupplier);
        Transformer adapterTransformer1 = adapter.get();
        adapterTransformer1.init(this.context);
        Transformer adapterTransformer2 = adapter.get();
        adapterTransformer2.init(this.context);
        Transformer adapterTransformer3 = adapter.get();
        adapterTransformer3.init(this.context);
        this.verifyAll();
        MatcherAssert.assertThat((Object)adapterTransformer1, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer2)));
        MatcherAssert.assertThat((Object)adapterTransformer2, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer3)));
        MatcherAssert.assertThat((Object)adapterTransformer3, (Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)adapterTransformer1)));
    }
}

