/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamSelectKeyTest {
    private final String topicName = "topic_key_select";
    private final ConsumerRecordFactory<String, Integer> recordFactory = new ConsumerRecordFactory("topic_key_select", (Serializer)new StringSerializer(), (Serializer)new IntegerSerializer(), 0L);
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.Integer());

    @Test
    public void testSelectKey() {
        StreamsBuilder builder = new StreamsBuilder();
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        String[] expected = new String[]{"ONE:1 (ts: 0)", "TWO:2 (ts: 0)", "THREE:3 (ts: 0)"};
        int[] expectedValues = new int[]{1, 2, 3};
        KStream stream = builder.stream("topic_key_select", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer()));
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        stream.selectKey((key, value) -> (String)keyMap.get(value)).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedValue : expectedValues) {
                driver.pipeInput(this.recordFactory.create((Object)expectedValue));
            }
        }
        Assert.assertEquals((long)3L, (long)supplier.theCapturedProcessor().processed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)supplier.theCapturedProcessor().processed.get(i));
        }
    }

    @Test
    public void testTypeVariance() {
        new StreamsBuilder().stream("empty").foreach((key, value) -> {});
    }
}

