/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MeteredTimestampedKeyValueStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map<String, String> tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"test"), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-id", (Object)"metered")});
    @Mock(type=MockType.NICE)
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContext context;
    private MeteredTimestampedKeyValueStore<String, String> metered;
    private final String key = "key";
    private final Bytes keyBytes = Bytes.wrap((byte[])"key".getBytes());
    private final String value = "value";
    private final ValueAndTimestamp<String> valueAndTimestamp = ValueAndTimestamp.make((Object)"value", (long)97L);
    private final byte[] valueAndTimestampBytes = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000avalue".getBytes();
    private final KeyValue<Bytes, byte[]> byteKeyValueTimestampPair = KeyValue.pair((Object)this.keyBytes, (Object)this.valueAndTimestampBytes);
    private final Metrics metrics = new Metrics();

    @Before
    public void before() {
        this.metered = new MeteredTimestampedKeyValueStore(this.inner, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new ValueAndTimestampSerde(Serdes.String()));
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.metrics()).andReturn((Object)new MockStreamsMetrics(this.metrics));
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.inner.name()).andReturn((Object)"metered").anyTimes();
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter("kafka.streams");
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=stream-%s-metrics,client-id=%s,task-id=%s,%s-id=%s", "scope", "test", this.taskId.toString(), "scope", "metered")));
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=stream-%s-metrics,client-id=%s,task-id=%s,%s-id=%s", "scope", "test", this.taskId.toString(), "scope", "all")));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put(EasyMock.eq((Object)this.keyBytes), (Object)EasyMock.aryEq((byte[])this.valueAndTimestampBytes));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put((Object)"key", this.valueAndTimestamp);
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        EasyMock.expect((Object)this.inner.get((Object)this.keyBytes)).andReturn((Object)this.valueAndTimestampBytes);
        this.init();
        MatcherAssert.assertThat((Object)this.metered.get((Object)"key"), (Matcher)CoreMatchers.equalTo(this.valueAndTimestamp));
        KafkaMetric metric = this.metric("get-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        EasyMock.expect((Object)this.inner.putIfAbsent(EasyMock.eq((Object)this.keyBytes), (Object)EasyMock.aryEq((byte[])this.valueAndTimestampBytes))).andReturn(null);
        this.init();
        this.metered.putIfAbsent((Object)"key", this.valueAndTimestamp);
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, "stream-scope-metrics", "", this.tags));
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        this.inner.putAll((List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall();
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair((Object)"key", this.valueAndTimestamp)));
        KafkaMetric metric = this.metric("put-all-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        EasyMock.expect((Object)this.inner.delete((Object)this.keyBytes)).andReturn((Object)this.valueAndTimestampBytes);
        this.init();
        this.metered.delete((Object)"key");
        KafkaMetric metric = this.metric("delete-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        EasyMock.expect((Object)this.inner.range((Object)this.keyBytes, (Object)this.keyBytes)).andReturn(new KeyValueIteratorStub(Collections.singletonList(this.byteKeyValueTimestampPair).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.range((Object)"key", (Object)"key");
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo(this.valueAndTimestamp));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        EasyMock.expect((Object)this.inner.all()).andReturn(new KeyValueIteratorStub(Collections.singletonList(this.byteKeyValueTimestampPair).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.all();
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo(this.valueAndTimestamp));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", "stream-scope-metrics", "", this.tags));
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFlushInnerWhenFlushTimeRecords() {
        this.inner.flush();
        EasyMock.expectLastCall().once();
        this.init();
        this.metered.flush();
        KafkaMetric metric = this.metric("flush-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedKeyValueStore cachedKeyValueStore = (CachedKeyValueStore)EasyMock.mock(CachedKeyValueStore.class);
        EasyMock.expect((Object)cachedKeyValueStore.setFlushListener((CacheFlushListener)EasyMock.anyObject(CacheFlushListener.class), EasyMock.eq((boolean)false))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cachedKeyValueStore});
        this.metered = new MeteredTimestampedKeyValueStore((KeyValueStore)cachedKeyValueStore, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new ValueAndTimestampSerde(Serdes.String()));
        Assert.assertTrue((boolean)this.metered.setFlushListener(null, false));
        EasyMock.verify((Object[])new Object[]{cachedKeyValueStore});
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.metered.setFlushListener(null, false));
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }

    @Test
    public void shouldNotThrowExceptionIfSerdesCorrectlySetFromProcessorContext() {
        EasyMock.expect((Object)this.context.keySerde()).andStubReturn((Object)Serdes.String());
        EasyMock.expect((Object)this.context.valueSerde()).andStubReturn((Object)Serdes.Long());
        MeteredTimestampedKeyValueStore store = new MeteredTimestampedKeyValueStore(this.inner, "scope", (Time)new MockTime(), null, null);
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        store.init(this.context, this.inner);
        try {
            store.put((Object)"key", (Object)ValueAndTimestamp.make((Object)42L, (long)60000L));
        }
        catch (StreamsException exception) {
            if (exception.getCause() instanceof ClassCastException) {
                Assert.fail((String)"Serdes are not correctly set from processor context.");
            }
            throw exception;
        }
    }

    @Test
    public void shouldNotThrowExceptionIfSerdesCorrectlySetFromConstructorParameters() {
        EasyMock.expect((Object)this.context.keySerde()).andStubReturn((Object)Serdes.String());
        EasyMock.expect((Object)this.context.valueSerde()).andStubReturn((Object)Serdes.Long());
        MeteredTimestampedKeyValueStore store = new MeteredTimestampedKeyValueStore(this.inner, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new ValueAndTimestampSerde(Serdes.Long()));
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        store.init(this.context, this.inner);
        try {
            store.put((Object)"key", (Object)ValueAndTimestamp.make((Object)42L, (long)60000L));
        }
        catch (StreamsException exception) {
            if (exception.getCause() instanceof ClassCastException) {
                Assert.fail((String)"Serdes are not correctly set from constructor parameters.");
            }
            throw exception;
        }
    }

    private static interface CachedKeyValueStore
    extends KeyValueStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

