/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MeteredSessionStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map<String, String> tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"test"), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-id", (Object)"metered")});
    private final Metrics metrics = new Metrics();
    private MeteredSessionStore<String, String> metered;
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContext context;
    private final String key = "a";
    private final byte[] keyBytes = "a".getBytes();
    private final Windowed<Bytes> windowedKeyBytes = new Windowed((Object)Bytes.wrap((byte[])this.keyBytes), (Window)new SessionWindow(0L, 0L));

    @Before
    public void before() {
        this.metered = new MeteredSessionStore(this.inner, "scope", Serdes.String(), Serdes.String(), (Time)new MockTime());
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.metrics()).andReturn((Object)new MockStreamsMetrics(this.metrics));
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.inner.name()).andReturn((Object)"metered").anyTimes();
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter("kafka.streams");
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=stream-%s-metrics,client-id=%s,task-id=%s,%s-id=%s", "scope", "test", this.taskId.toString(), "scope", "metered")));
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=stream-%s-metrics,client-id=%s,task-id=%s,%s-id=%s", "scope", "test", this.taskId.toString(), "scope", "all")));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put((Windowed)EasyMock.eq(this.windowedKeyBytes), (Object)EasyMock.aryEq((byte[])this.keyBytes));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)"a");
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFindSessionsFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.inner.findSessions((Object)Bytes.wrap((byte[])this.keyBytes), 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, (Object)this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.findSessions((Object)"a", 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFindSessionRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.inner.findSessions((Object)Bytes.wrap((byte[])this.keyBytes), (Object)Bytes.wrap((byte[])this.keyBytes), 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, (Object)this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.findSessions((Object)"a", (Object)"a", 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRemoveFromStoreAndRecordRemoveMetric() {
        this.inner.remove(this.windowedKeyBytes);
        EasyMock.expectLastCall();
        this.init();
        this.metered.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)));
        KafkaMetric metric = this.metric("remove-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFetchForKeyAndRecordFetchMetric() {
        EasyMock.expect((Object)this.inner.fetch((Object)Bytes.wrap((byte[])this.keyBytes))).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, (Object)this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.fetch((Object)"a");
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFetchRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.inner.fetch((Object)Bytes.wrap((byte[])this.keyBytes), (Object)Bytes.wrap((byte[])this.keyBytes))).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, (Object)this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.fetch((Object)"a", (Object)"a");
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRecordRestoreTimeOnInit() {
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfFetchSessionReturnsNull() {
        EasyMock.expect((Object)this.inner.fetchSession((Object)Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)).andReturn(null);
        this.init();
        Assert.assertNull((Object)this.metered.fetchSession((Object)"a", 0L, Long.MAX_VALUE));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        this.metered.put(null, (Object)"a");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnRemoveIfKeyIsNull() {
        this.metered.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchIfKeyIsNull() {
        this.metered.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchRangeIfFromIsNull() {
        this.metered.fetch(null, (Object)"to");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchRangeIfToIsNull() {
        this.metered.fetch((Object)"from", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsIfKeyIsNull() {
        this.metered.findSessions(null, 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsRangeIfFromIsNull() {
        this.metered.findSessions(null, (Object)"a", 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsRangeIfToIsNull() {
        this.metered.findSessions((Object)"a", null, 0L, 0L);
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedSessionStore cachedSessionStore = (CachedSessionStore)EasyMock.mock(CachedSessionStore.class);
        EasyMock.expect((Object)cachedSessionStore.setFlushListener((CacheFlushListener)EasyMock.anyObject(CacheFlushListener.class), EasyMock.eq((boolean)false))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cachedSessionStore});
        this.metered = new MeteredSessionStore((SessionStore)cachedSessionStore, "scope", Serdes.String(), Serdes.String(), (Time)new MockTime());
        Assert.assertTrue((boolean)this.metered.setFlushListener(null, false));
        EasyMock.verify((Object[])new Object[]{cachedSessionStore});
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.metered.setFlushListener(null, false));
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, "stream-scope-metrics", "", this.tags));
    }

    private static interface CachedSessionStore
    extends SessionStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

