/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyTestDriverWrapper;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KTableFilterTest {
    private final Consumed<String, Integer> consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Integer());
    private final ConsumerRecordFactory<String, Integer> recordFactory = new ConsumerRecordFactory((Serializer)new StringSerializer(), (Serializer)new IntegerSerializer(), 0L);
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.Integer());
    private final Predicate<String, Integer> predicate = (key, value) -> value % 2 == 0;

    @Before
    public void setUp() {
        this.props.setProperty("cache.max.bytes.buffering", "0");
    }

    private void doTestKTable(StreamsBuilder builder, KTable<String, Integer> table2, KTable<String, Integer> table3, String topic) {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        table2.toStream().process(supplier, new String[0]);
        table3.toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            driver.pipeInput(this.recordFactory.create(topic, (Object)"A", (Object)1, 10L));
            driver.pipeInput(this.recordFactory.create(topic, (Object)"B", (Object)2, 5L));
            driver.pipeInput(this.recordFactory.create(topic, (Object)"C", (Object)3, 8L));
            driver.pipeInput(this.recordFactory.create(topic, (Object)"D", (Object)4, 14L));
            driver.pipeInput(this.recordFactory.create(topic, (Object)"A", null, 18L));
            driver.pipeInput(this.recordFactory.create(topic, (Object)"B", null, 15L));
        }
        List processors = supplier.capturedProcessors(2);
        processors.get(0).checkAndClearProcessResult("A:null (ts: 10)", "B:2 (ts: 5)", "C:null (ts: 8)", "D:4 (ts: 14)", "A:null (ts: 18)", "B:null (ts: 15)");
        processors.get(1).checkAndClearProcessResult("A:1 (ts: 10)", "B:null (ts: 5)", "C:3 (ts: 8)", "D:null (ts: 14)", "A:null (ts: 18)", "B:null (ts: 15)");
    }

    @Test
    public void shouldPassThroughWithoutMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.filter(this.predicate);
        KTable table3 = table1.filterNot(this.predicate);
        Assert.assertNull((Object)table1.queryableStoreName());
        Assert.assertNull((Object)table2.queryableStoreName());
        Assert.assertNull((Object)table3.queryableStoreName());
        this.doTestKTable(builder, (KTable<String, Integer>)table2, (KTable<String, Integer>)table3, "topic1");
    }

    @Test
    public void shouldPassThroughOnMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.filter(this.predicate, Materialized.as((String)"store2"));
        KTable table3 = table1.filterNot(this.predicate);
        Assert.assertNull((Object)table1.queryableStoreName());
        Assert.assertEquals((Object)"store2", (Object)table2.queryableStoreName());
        Assert.assertNull((Object)table3.queryableStoreName());
        this.doTestKTable(builder, (KTable<String, Integer>)table2, (KTable<String, Integer>)table3, "topic1");
    }

    private void doTestValueGetter(StreamsBuilder builder, KTableImpl<String, Integer, Integer> table2, KTableImpl<String, Integer, Integer> table3, String topic1) {
        Topology topology = builder.build();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        InternalTopologyBuilder topologyBuilder = TopologyWrapper.getInternalTopologyBuilder(topology);
        topologyBuilder.connectProcessorAndStateStores(table2.name, getterSupplier2.storeNames());
        topologyBuilder.connectProcessorAndStateStores(table3.name, getterSupplier3.storeNames());
        try (TopologyTestDriverWrapper driver = new TopologyTestDriverWrapper(topology, this.props);){
            KTableValueGetter getter2 = getterSupplier2.get();
            KTableValueGetter getter3 = getterSupplier3.get();
            getter2.init(driver.setCurrentNodeForProcessorContext(table2.name));
            getter3.init(driver.setCurrentNodeForProcessorContext(table3.name));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)1, 5L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)1, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"C", (Object)1, 15L));
            Assert.assertNull((Object)getter2.get((Object)"A"));
            Assert.assertNull((Object)getter2.get((Object)"B"));
            Assert.assertNull((Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)5L), (Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)10L), (Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)15L), (Object)getter3.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)2, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)2, 5L));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)10L), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)5L), (Object)getter2.get((Object)"B"));
            Assert.assertNull((Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertNull((Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)15L), (Object)getter3.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)3, 15L));
            Assert.assertNull((Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)5L), (Object)getter2.get((Object)"B"));
            Assert.assertNull((Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)3, (long)15L), (Object)getter3.get((Object)"A"));
            Assert.assertNull((Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)15L), (Object)getter3.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", null, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", null, 20L));
            Assert.assertNull((Object)getter2.get((Object)"A"));
            Assert.assertNull((Object)getter2.get((Object)"B"));
            Assert.assertNull((Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertNull((Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)15L), (Object)getter3.get((Object)"C"));
        }
    }

    @Test
    public void shouldGetValuesOnMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.filter(this.predicate, Materialized.as((String)"store2"));
        KTableImpl table3 = (KTableImpl)table1.filterNot(this.predicate, Materialized.as((String)"store3"));
        KTableImpl table4 = (KTableImpl)table1.filterNot(this.predicate);
        Assert.assertNull((Object)table1.queryableStoreName());
        Assert.assertEquals((Object)"store2", (Object)table2.queryableStoreName());
        Assert.assertEquals((Object)"store3", (Object)table3.queryableStoreName());
        Assert.assertNull((Object)table4.queryableStoreName());
        this.doTestValueGetter(builder, (KTableImpl<String, Integer, Integer>)table2, (KTableImpl<String, Integer, Integer>)table3, "topic1");
    }

    private void doTestNotSendingOldValue(StreamsBuilder builder, KTableImpl<String, Integer, Integer> table1, KTableImpl<String, Integer, Integer> table2, String topic1) {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        builder.build().addProcessor("proc1", supplier, new String[]{table1.name});
        builder.build().addProcessor("proc2", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)1, 5L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)1, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"C", (Object)1, 15L));
            List processors = supplier.capturedProcessors(2);
            processors.get(0).checkAndClearProcessResult("A:(1<-null) (ts: 5)", "B:(1<-null) (ts: 10)", "C:(1<-null) (ts: 15)");
            processors.get(1).checkAndClearProcessResult("A:(null<-null) (ts: 5)", "B:(null<-null) (ts: 10)", "C:(null<-null) (ts: 15)");
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)2, 15L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)2, 8L));
            processors.get(0).checkAndClearProcessResult("A:(2<-null) (ts: 15)", "B:(2<-null) (ts: 8)");
            processors.get(1).checkAndClearProcessResult("A:(2<-null) (ts: 15)", "B:(2<-null) (ts: 8)");
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)3, 20L));
            processors.get(0).checkAndClearProcessResult("A:(3<-null) (ts: 20)");
            processors.get(1).checkAndClearProcessResult("A:(null<-null) (ts: 20)");
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", null, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", null, 20L));
            processors.get(0).checkAndClearProcessResult("A:(null<-null) (ts: 10)", "B:(null<-null) (ts: 20)");
            processors.get(1).checkAndClearProcessResult("A:(null<-null) (ts: 10)", "B:(null<-null) (ts: 20)");
        }
    }

    @Test
    public void shouldNotSendOldValuesWithoutMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.filter(this.predicate);
        this.doTestNotSendingOldValue(builder, (KTableImpl<String, Integer, Integer>)table1, (KTableImpl<String, Integer, Integer>)table2, "topic1");
    }

    @Test
    public void shouldNotSendOldValuesOnMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.filter(this.predicate, Materialized.as((String)"store2"));
        this.doTestNotSendingOldValue(builder, (KTableImpl<String, Integer, Integer>)table1, (KTableImpl<String, Integer, Integer>)table2, "topic1");
    }

    private void doTestSendingOldValue(StreamsBuilder builder, KTableImpl<String, Integer, Integer> table1, KTableImpl<String, Integer, Integer> table2, String topic1) {
        table2.enableSendingOldValues();
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        Topology topology = builder.build();
        topology.addProcessor("proc1", supplier, new String[]{table1.name});
        topology.addProcessor("proc2", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)1, 5L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)1, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"C", (Object)1, 15L));
            List processors = supplier.capturedProcessors(2);
            processors.get(0).checkAndClearProcessResult("A:(1<-null) (ts: 5)", "B:(1<-null) (ts: 10)", "C:(1<-null) (ts: 15)");
            processors.get(1).checkEmptyAndClearProcessResult();
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)2, 15L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)2, 8L));
            processors.get(0).checkAndClearProcessResult("A:(2<-1) (ts: 15)", "B:(2<-1) (ts: 8)");
            processors.get(1).checkAndClearProcessResult("A:(2<-null) (ts: 15)", "B:(2<-null) (ts: 8)");
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)3, 20L));
            processors.get(0).checkAndClearProcessResult("A:(3<-2) (ts: 20)");
            processors.get(1).checkAndClearProcessResult("A:(null<-2) (ts: 20)");
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", null, 10L));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", null, 20L));
            processors.get(0).checkAndClearProcessResult("A:(null<-3) (ts: 10)", "B:(null<-2) (ts: 20)");
            processors.get(1).checkAndClearProcessResult("B:(null<-2) (ts: 20)");
        }
    }

    @Test
    public void shouldSendOldValuesWhenEnabledWithoutMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.filter(this.predicate);
        this.doTestSendingOldValue(builder, (KTableImpl<String, Integer, Integer>)table1, (KTableImpl<String, Integer, Integer>)table2, "topic1");
    }

    @Test
    public void shouldSendOldValuesWhenEnabledOnMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.filter(this.predicate, Materialized.as((String)"store2"));
        this.doTestSendingOldValue(builder, (KTableImpl<String, Integer, Integer>)table1, (KTableImpl<String, Integer, Integer>)table2, "topic1");
    }

    private void doTestSkipNullOnMaterialization(StreamsBuilder builder, KTableImpl<String, String, String> table1, KTableImpl<String, String, String> table2, String topic1) {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        Topology topology = builder.build();
        topology.addProcessor("proc1", supplier, new String[]{table1.name});
        topology.addProcessor("proc2", supplier, new String[]{table2.name});
        ConsumerRecordFactory stringRecordFactory = new ConsumerRecordFactory((Serializer)new StringSerializer(), (Serializer)new StringSerializer(), 0L);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            driver.pipeInput(stringRecordFactory.create(topic1, (Object)"A", (Object)"reject", 5L));
            driver.pipeInput(stringRecordFactory.create(topic1, (Object)"B", (Object)"reject", 10L));
            driver.pipeInput(stringRecordFactory.create(topic1, (Object)"C", (Object)"reject", 20L));
        }
        List processors = supplier.capturedProcessors(2);
        processors.get(0).checkAndClearProcessResult("A:(reject<-null) (ts: 5)", "B:(reject<-null) (ts: 10)", "C:(reject<-null) (ts: 20)");
        processors.get(1).checkEmptyAndClearProcessResult();
    }

    @Test
    public void shouldSkipNullToRepartitionWithoutMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        KTableImpl table1 = (KTableImpl)builder.table("topic1", consumed);
        KTableImpl table2 = (KTableImpl)table1.filter((key, value) -> value.equalsIgnoreCase("accept")).groupBy(MockMapper.noOpKeyValueMapper()).reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER);
        this.doTestSkipNullOnMaterialization(builder, (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, String>)table2, "topic1");
    }

    @Test
    public void shouldSkipNullToRepartitionOnMaterialization() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        KTableImpl table1 = (KTableImpl)builder.table("topic1", consumed);
        KTableImpl table2 = (KTableImpl)table1.filter((key, value) -> value.equalsIgnoreCase("accept"), Materialized.as((String)"store2")).groupBy(MockMapper.noOpKeyValueMapper()).reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, Materialized.as((String)"mock-result"));
        this.doTestSkipNullOnMaterialization(builder, (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, String>)table2, "topic1");
    }

    @Test
    public void testTypeVariance() {
        Predicate numberKeyPredicate = (key, value) -> false;
        new StreamsBuilder().table("empty").filter(numberKeyPredicate).filterNot(numberKeyPredicate).toStream().to("nirvana");
    }
}

