/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.KStreamTransformValues;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.SingletonNoOpValueTransformer;
import org.apache.kafka.test.StreamsTestUtils;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class KStreamTransformValuesTest {
    private final String topicName = "topic";
    private final MockProcessorSupplier<Integer, Integer> supplier = new MockProcessorSupplier();
    private final ConsumerRecordFactory<Integer, Integer> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer(), 0L);
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.Integer());
    @Mock(value=MockType.NICE)
    private ProcessorContext context;

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerSupplier valueTransformerSupplier = () -> new ValueTransformer<Number, Integer>(){
            private int total = 0;

            public void init(ProcessorContext context) {
            }

            public Integer transform(Number value) {
                this.total += value.intValue();
                return this.total;
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create("topic", (Object)expectedKey, (Object)(expectedKey * 10), (long)expectedKey / 2L));
            }
        }
        Object[] expected = new String[]{"1:10 (ts: 0)", "10:110 (ts: 5)", "100:1110 (ts: 50)", "1000:11110 (ts: 500)"};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed.toArray());
    }

    @Test
    public void testTransformWithKey() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerWithKeySupplier valueTransformerSupplier = () -> new ValueTransformerWithKey<Integer, Number, Integer>(){
            private int total = 0;

            public void init(ProcessorContext context) {
            }

            public Integer transform(Integer readOnlyKey, Number value) {
                this.total += value.intValue() + readOnlyKey;
                return this.total;
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create("topic", (Object)expectedKey, (Object)(expectedKey * 10), (long)expectedKey / 2L));
            }
        }
        Object[] expected = new String[]{"1:11 (ts: 0)", "10:121 (ts: 5)", "100:1221 (ts: 50)", "1000:12221 (ts: 500)"};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed.toArray());
    }

    @Test
    public void shouldInitializeTransformerWithForwardDisabledProcessorContext() {
        SingletonNoOpValueTransformer transformer = new SingletonNoOpValueTransformer();
        KStreamTransformValues transformValues = new KStreamTransformValues(transformer);
        Processor processor = transformValues.get();
        processor.init(this.context);
        MatcherAssert.assertThat((Object)transformer.context, (Matcher)CoreMatchers.isA(ForwardingDisabledProcessorContext.class));
    }
}

