/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.FullChangeSerde;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class FullChangeSerdeTest {
    private final FullChangeSerde<String> serde = FullChangeSerde.castOrWrap((Serde)Serdes.String());

    @Test
    public void shouldRoundTripNull() {
        byte[] serialized = this.serde.serializer().serialize(null, null);
        MatcherAssert.assertThat((Object)this.serde.deserializer().deserialize(null, serialized), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldRoundTripNullChange() {
        byte[] serialized = this.serde.serializer().serialize(null, (Object)new Change(null, null));
        MatcherAssert.assertThat((Object)this.serde.deserializer().deserialize(null, serialized), (Matcher)Is.is((Object)new Change(null, null)));
    }

    @Test
    public void shouldRoundTripOldNull() {
        byte[] serialized = this.serde.serializer().serialize(null, (Object)new Change((Object)"new", null));
        MatcherAssert.assertThat((Object)this.serde.deserializer().deserialize(null, serialized), (Matcher)Is.is((Object)new Change((Object)"new", null)));
    }

    @Test
    public void shouldRoundTripNewNull() {
        byte[] serialized = this.serde.serializer().serialize(null, (Object)new Change(null, (Object)"old"));
        MatcherAssert.assertThat((Object)this.serde.deserializer().deserialize(null, serialized), (Matcher)Is.is((Object)new Change(null, (Object)"old")));
    }

    @Test
    public void shouldRoundTripChange() {
        byte[] serialized = this.serde.serializer().serialize(null, (Object)new Change((Object)"new", (Object)"old"));
        MatcherAssert.assertThat((Object)this.serde.deserializer().deserialize(null, serialized), (Matcher)Is.is((Object)new Change((Object)"new", (Object)"old")));
    }

    @Test
    public void shouldConfigureSerde() {
        Serde mock = (Serde)EasyMock.mock(Serde.class);
        mock.configure(Collections.emptyMap(), false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mock});
        FullChangeSerde serde = FullChangeSerde.castOrWrap((Serde)mock);
        serde.configure(Collections.emptyMap(), false);
        EasyMock.verify((Object[])new Object[]{mock});
    }

    @Test
    public void shouldCloseSerde() {
        Serde mock = (Serde)EasyMock.mock(Serde.class);
        mock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mock});
        FullChangeSerde serde = FullChangeSerde.castOrWrap((Serde)mock);
        serde.close();
        EasyMock.verify((Object[])new Object[]{mock});
    }

    @Test
    public void shouldConfigureSerializer() {
        Serde mockSerde = (Serde)EasyMock.mock(Serde.class);
        Serializer mockSerializer = (Serializer)EasyMock.mock(Serializer.class);
        EasyMock.expect((Object)mockSerde.serializer()).andReturn((Object)mockSerializer);
        EasyMock.replay((Object[])new Object[]{mockSerde});
        mockSerializer.configure(Collections.emptyMap(), false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockSerializer});
        Serializer serializer = FullChangeSerde.castOrWrap((Serde)mockSerde).serializer();
        serializer.configure(Collections.emptyMap(), false);
        EasyMock.verify((Object[])new Object[]{mockSerde});
        EasyMock.verify((Object[])new Object[]{mockSerializer});
    }

    @Test
    public void shouldCloseSerializer() {
        Serde mockSerde = (Serde)EasyMock.mock(Serde.class);
        Serializer mockSerializer = (Serializer)EasyMock.mock(Serializer.class);
        EasyMock.expect((Object)mockSerde.serializer()).andReturn((Object)mockSerializer);
        EasyMock.replay((Object[])new Object[]{mockSerde});
        mockSerializer.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockSerializer});
        Serializer serializer = FullChangeSerde.castOrWrap((Serde)mockSerde).serializer();
        serializer.close();
        EasyMock.verify((Object[])new Object[]{mockSerde});
        EasyMock.verify((Object[])new Object[]{mockSerializer});
    }

    @Test
    public void shouldConfigureDeserializer() {
        Serde mockSerde = (Serde)EasyMock.mock(Serde.class);
        Deserializer mockDeserializer = (Deserializer)EasyMock.mock(Deserializer.class);
        EasyMock.expect((Object)mockSerde.deserializer()).andReturn((Object)mockDeserializer);
        EasyMock.replay((Object[])new Object[]{mockSerde});
        mockDeserializer.configure(Collections.emptyMap(), false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockDeserializer});
        Deserializer serializer = FullChangeSerde.castOrWrap((Serde)mockSerde).deserializer();
        serializer.configure(Collections.emptyMap(), false);
        EasyMock.verify((Object[])new Object[]{mockSerde});
        EasyMock.verify((Object[])new Object[]{mockDeserializer});
    }

    @Test
    public void shouldCloseDeserializer() {
        Serde mockSerde = (Serde)EasyMock.mock(Serde.class);
        Deserializer mockDeserializer = (Deserializer)EasyMock.mock(Deserializer.class);
        EasyMock.expect((Object)mockSerde.deserializer()).andReturn((Object)mockDeserializer);
        EasyMock.replay((Object[])new Object[]{mockSerde});
        mockDeserializer.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockDeserializer});
        Deserializer serializer = FullChangeSerde.castOrWrap((Serde)mockSerde).deserializer();
        serializer.close();
        EasyMock.verify((Object[])new Object[]{mockSerde});
        EasyMock.verify((Object[])new Object[]{mockDeserializer});
    }
}

