/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingWindowBytesStore
extends WrappedStateStore<WindowStore<Bytes, byte[]>>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    private StoreChangeLogger<Bytes, byte[]> changeLogger;
    private ProcessorContext context;
    private int seqnum = 0;

    ChangeLoggingWindowBytesStore(WindowStore<Bytes, byte[]> bytesStore, boolean retainDuplicates) {
        super(bytesStore);
        this.retainDuplicates = retainDuplicates;
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long from, long to) {
        return ((WindowStore)this.wrapped()).fetch(key, from, to);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        return ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, from, to);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        return ((WindowStore)this.wrapped()).all();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
    }

    @Override
    public void put(Bytes key, byte[] value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        ((WindowStore)this.wrapped()).put(key, value, windowStartTimestamp);
        this.changeLogger.logChange(WindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, this.maybeUpdateSeqnumForDups()), value);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        super.init(context, root);
        String topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name());
        this.changeLogger = new StoreChangeLogger(this.name(), context, new StateSerdes(topic, Serdes.Bytes(), Serdes.ByteArray()));
    }

    private int maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
        return this.seqnum;
    }
}

