/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamsMetricsImplTest {
    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        new StreamsMetricsImpl(null, "");
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String sensorName = "sensor1";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        Sensor sensor1 = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG);
        streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = streamsMetrics.addThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor3);
        Assert.assertEquals(Collections.emptyMap(), (Object)streamsMetrics.parentSensors());
    }

    @Test
    public void testMutiLevelSensorRemoval() {
        Metrics registry = new Metrics();
        StreamsMetricsImpl metrics = new StreamsMetricsImpl(registry, "");
        for (MetricName defaultMetric : registry.metrics().keySet()) {
            registry.removeMetric(defaultMetric);
        }
        String taskName = "taskName";
        String operation = "operation";
        Map taskTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tkey", (Object)"value")});
        String processorNodeName = "processorNodeName";
        Map nodeTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"nkey", (Object)"value")});
        Sensor parent1 = metrics.taskLevelSensor("taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgMaxLatency((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCount((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        int numberOfTaskMetrics = registry.metrics().size();
        Sensor sensor1 = metrics.nodeLevelSensor("taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent1});
        StreamsMetricsImpl.addAvgMaxLatency((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCount((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        metrics.removeAllNodeLevelSensors("taskName", "processorNodeName");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor parent2 = metrics.taskLevelSensor("taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgMaxLatency((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCount((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor sensor2 = metrics.nodeLevelSensor("taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent2});
        StreamsMetricsImpl.addAvgMaxLatency((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCount((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        metrics.removeAllNodeLevelSensors("taskName", "processorNodeName");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        metrics.removeAllTaskLevelSensors("taskName");
        Assert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testLatencyMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(defaultMetrics + 4 + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }

    @Test
    public void testThroughputMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }

    @Test
    public void testTotalMetricDoesntDecrease() {
        MockTime time = new MockTime(1L);
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS);
        Metrics metrics = new Metrics(config, (Time)time);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "");
        String scope = "scope";
        String entity = "entity";
        String operation = "op";
        Sensor sensor = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "op", Sensor.RecordingLevel.INFO, new String[0]);
        double latency = 100.0;
        MetricName totalMetricName = metrics.metricName("op-total", "stream-scope-metrics", "", new String[]{"client-id", "", "scope-id", "entity"});
        KafkaMetric totalMetric = metrics.metric(totalMetricName);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)Math.round(totalMetric.measurable().measure(config, time.milliseconds())));
            sensor.record(100.0, time.milliseconds());
        }
    }
}

