/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamMapValuesTest {
    private String topicName = "topic";
    private final MockProcessorSupplier<Integer, Integer> supplier = new MockProcessorSupplier();
    private final ConsumerRecordFactory<Integer, String> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapper<CharSequence, Integer> mapper = new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.length();
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.mapValues((ValueMapper)mapper).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(this.topicName, (Object)expectedKey, (Object)Integer.toString(expectedKey)));
            }
        }
        Object[] expected = new String[]{"1:1", "10:2", "100:3", "1000:4"};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed.toArray());
    }

    @Test
    public void testMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey<Integer, CharSequence, Integer> mapper = new ValueMapperWithKey<Integer, CharSequence, Integer>(){

            public Integer apply(Integer readOnlyKey, CharSequence value) {
                return value.length() + readOnlyKey;
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.mapValues((ValueMapperWithKey)mapper).process(this.supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(this.topicName, (Object)expectedKey, (Object)Integer.toString(expectedKey)));
            }
        }
        Object[] expected = new String[]{"1:2", "10:12", "100:103", "1000:1004"};
        Assert.assertArrayEquals((Object[])expected, (Object[])this.supplier.theCapturedProcessor().processed.toArray());
    }
}

