/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFlatMapValuesTest {
    private String topicName = "topic";
    private final ConsumerRecordFactory<Integer, Integer> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapper<Number, Iterable<String>> mapper = new ValueMapper<Number, Iterable<String>>(){

            public Iterable<String> apply(Number value) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("v" + value);
                result.add("V" + value);
                return result;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        stream.flatMapValues((ValueMapper)mapper).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(this.topicName, (Object)expectedKey, (Object)expectedKey, 0L));
            }
        }
        Object[] expected = new String[]{"0:v0", "0:V0", "1:v1", "1:V1", "2:v2", "2:V2", "3:v3", "3:V3"};
        Assert.assertArrayEquals((Object[])expected, (Object[])supplier.theCapturedProcessor().processed.toArray());
    }

    @Test
    public void testFlatMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey<Integer, Number, Iterable<String>> mapper = new ValueMapperWithKey<Integer, Number, Iterable<String>>(){

            public Iterable<String> apply(Integer readOnlyKey, Number value) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("v" + value);
                result.add("k" + readOnlyKey);
                return result;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        stream.flatMapValues((ValueMapperWithKey)mapper).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(this.topicName, (Object)expectedKey, (Object)expectedKey, 0L));
            }
        }
        Object[] expected = new String[]{"0:v0", "0:k0", "1:v1", "1:k1", "2:v2", "2:k2", "3:v3", "3:k3"};
        Assert.assertArrayEquals((Object[])expected, (Object[])supplier.theCapturedProcessor().processed.toArray());
    }
}

