/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.state.internals.ContextualRecord;

class LRUCacheEntry {
    private final ContextualRecord record;
    private final long sizeBytes;
    private boolean isDirty;

    LRUCacheEntry(byte[] value) {
        this(value, null, false, -1L, -1L, -1, "");
    }

    LRUCacheEntry(byte[] value, Headers headers, boolean isDirty, long offset, long timestamp, int partition, String topic) {
        ProcessorRecordContext context = new ProcessorRecordContext(timestamp, offset, partition, topic, headers);
        this.record = new ContextualRecord(value, context);
        this.isDirty = isDirty;
        this.sizeBytes = 1L + this.record.sizeBytes();
    }

    void markClean() {
        this.isDirty = false;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    long size() {
        return this.sizeBytes;
    }

    byte[] value() {
        return this.record.value();
    }

    public ProcessorRecordContext context() {
        return this.record.recordContext();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LRUCacheEntry that = (LRUCacheEntry)o;
        return this.sizeBytes == that.sizeBytes && this.isDirty() == that.isDirty() && Objects.equals(this.record, that.record);
    }

    public int hashCode() {
        return Objects.hash(this.record, this.sizeBytes, this.isDirty());
    }
}

