/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentInfo {
    private static final Logger log = LoggerFactory.getLogger(AssignmentInfo.class);
    public static final int LATEST_SUPPORTED_VERSION = 4;
    static final int UNKNOWN = -1;
    private final int usedVersion;
    private final int latestSupportedVersion;
    private int errCode;
    private List<TaskId> activeTasks;
    private Map<TaskId, Set<TopicPartition>> standbyTasks;
    private Map<HostInfo, Set<TopicPartition>> partitionsByHost;

    private AssignmentInfo(int version, int latestSupportedVersion) {
        this.usedVersion = version;
        this.latestSupportedVersion = latestSupportedVersion;
        this.errCode = 0;
    }

    public AssignmentInfo(List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> hostState) {
        this(4, activeTasks, standbyTasks, hostState, 0);
    }

    public AssignmentInfo() {
        this(4, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), 0);
    }

    public AssignmentInfo(int version, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> hostState, int errCode) {
        this(version, 4, activeTasks, standbyTasks, hostState, errCode);
        if (version < 1 || version > 4) {
            throw new IllegalArgumentException("version must be between 1 and 4; was: " + version);
        }
    }

    AssignmentInfo(int version, int latestSupportedVersion, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> hostState, int errCode) {
        this.usedVersion = version;
        this.latestSupportedVersion = latestSupportedVersion;
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.partitionsByHost = hostState;
        this.errCode = errCode;
    }

    public int version() {
        return this.usedVersion;
    }

    public int errCode() {
        return this.errCode;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public List<TaskId> activeTasks() {
        return this.activeTasks;
    }

    public Map<TaskId, Set<TopicPartition>> standbyTasks() {
        return this.standbyTasks;
    }

    public Map<HostInfo, Set<TopicPartition>> partitionsByHost() {
        return this.partitionsByHost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(baos);){
            switch (this.usedVersion) {
                case 1: {
                    this.encodeVersionOne(out);
                    break;
                }
                case 2: {
                    this.encodeVersionTwo(out);
                    break;
                }
                case 3: {
                    this.encodeVersionThree(out);
                    break;
                }
                case 4: {
                    this.encodeVersionFour(out);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown metadata version: " + this.usedVersion + "; latest supported version: " + 4);
                }
            }
            out.flush();
            out.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to encode AssignmentInfo", ex);
        }
    }

    private void encodeVersionOne(DataOutputStream out) throws IOException {
        out.writeInt(1);
        this.encodeActiveAndStandbyTaskAssignment(out);
    }

    private void encodeActiveAndStandbyTaskAssignment(DataOutputStream out) throws IOException {
        out.writeInt(this.activeTasks.size());
        for (TaskId taskId : this.activeTasks) {
            taskId.writeTo(out);
        }
        out.writeInt(this.standbyTasks.size());
        for (Map.Entry entry : this.standbyTasks.entrySet()) {
            TaskId id = (TaskId)entry.getKey();
            id.writeTo(out);
            Set partitions = (Set)entry.getValue();
            this.writeTopicPartitions(out, partitions);
        }
    }

    private void encodeVersionTwo(DataOutputStream out) throws IOException {
        out.writeInt(2);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
    }

    private void encodePartitionsByHost(DataOutputStream out) throws IOException {
        out.writeInt(this.partitionsByHost.size());
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : this.partitionsByHost.entrySet()) {
            HostInfo hostInfo = entry.getKey();
            out.writeUTF(hostInfo.host());
            out.writeInt(hostInfo.port());
            this.writeTopicPartitions(out, entry.getValue());
        }
    }

    private void writeTopicPartitions(DataOutputStream out, Set<TopicPartition> partitions) throws IOException {
        out.writeInt(partitions.size());
        for (TopicPartition partition : partitions) {
            out.writeUTF(partition.topic());
            out.writeInt(partition.partition());
        }
    }

    private void encodeVersionThree(DataOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeInt(4);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
    }

    private void encodeVersionFour(DataOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(4);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
        out.writeInt(this.errCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AssignmentInfo decode(ByteBuffer data) {
        data.rewind();
        try (DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(data));){
            AssignmentInfo assignmentInfo;
            int usedVersion = in.readInt();
            switch (usedVersion) {
                case 1: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeVersionOneData(assignmentInfo, in);
                    break;
                }
                case 2: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeVersionTwoData(assignmentInfo, in);
                    break;
                }
                case 3: {
                    int latestSupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, latestSupportedVersion);
                    AssignmentInfo.decodeVersionThreeData(assignmentInfo, in);
                    break;
                }
                case 4: {
                    int latestSupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, latestSupportedVersion);
                    AssignmentInfo.decodeVersionFourData(assignmentInfo, in);
                    break;
                }
                default: {
                    TaskAssignmentException fatalException = new TaskAssignmentException("Unable to decode assignment data: used version: " + usedVersion + "; latest supported version: " + 4);
                    log.error(fatalException.getMessage(), (Throwable)((Object)fatalException));
                    throw fatalException;
                }
            }
            AssignmentInfo assignmentInfo2 = assignmentInfo;
            return assignmentInfo2;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to decode AssignmentInfo", ex);
        }
    }

    private static void decodeVersionOneData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
    }

    private static void decodeActiveTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.activeTasks = new ArrayList<TaskId>(count);
        for (int i = 0; i < count; ++i) {
            assignmentInfo.activeTasks.add(TaskId.readFrom(in));
        }
    }

    private static void decodeStandbyTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(count);
        for (int i = 0; i < count; ++i) {
            TaskId id = TaskId.readFrom(in);
            assignmentInfo.standbyTasks.put(id, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static void decodeVersionTwoData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        AssignmentInfo.decodeGlobalAssignmentData(assignmentInfo, in);
    }

    private static void decodeGlobalAssignmentData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
            assignmentInfo.partitionsByHost.put(hostInfo, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(in.readUTF(), in.readInt()));
        }
        return partitions;
    }

    private static void decodeVersionThreeData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        AssignmentInfo.decodeGlobalAssignmentData(assignmentInfo, in);
    }

    private static void decodeVersionFourData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeVersionThreeData(assignmentInfo, in);
        assignmentInfo.errCode = in.readInt();
    }

    public int hashCode() {
        return this.usedVersion ^ this.latestSupportedVersion ^ this.activeTasks.hashCode() ^ this.standbyTasks.hashCode() ^ this.partitionsByHost.hashCode() ^ this.errCode;
    }

    public boolean equals(Object o) {
        if (o instanceof AssignmentInfo) {
            AssignmentInfo other = (AssignmentInfo)o;
            return this.usedVersion == other.usedVersion && this.latestSupportedVersion == other.latestSupportedVersion && this.errCode == other.errCode && this.activeTasks.equals(other.activeTasks) && this.standbyTasks.equals(other.standbyTasks) && this.partitionsByHost.equals(other.partitionsByHost);
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.usedVersion + ", supported version=" + this.latestSupportedVersion + ", active tasks=" + this.activeTasks + ", standby tasks=" + this.standbyTasks + ", global assignment=" + this.partitionsByHost + "]";
    }
}

