/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.junit.Assert;
import org.junit.Test;

public class GlobalStateStoreProviderTest {
    @Test
    public void shouldReturnSingleItemListIfStoreExists() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", new NoOpReadOnlyStore()));
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)stores.size(), (long)1L);
    }

    @Test
    public void shouldReturnEmptyItemListIfStoreDoesntExist() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.emptyMap());
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertTrue((boolean)stores.isEmpty());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfStoreIsntOpen() {
        NoOpReadOnlyStore store = new NoOpReadOnlyStore();
        store.close();
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", store));
        provider.stores("global", QueryableStoreTypes.keyValueStore());
    }
}

