/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorContextImplTest {
    private ProcessorContextImpl context;
    private static final String KEY = "key";
    private static final long VAL = 42L;
    private static final String STORE_NAME = "underlying-store";
    private boolean flushExecuted;
    private boolean putExecuted;
    private boolean putIfAbsentExecuted;
    private boolean putAllExecuted;
    private boolean deleteExecuted;
    private boolean removeExecuted;
    private boolean put3argExecuted;
    private KeyValueIterator<String, Long> rangeIter;
    private KeyValueIterator<String, Long> allIter;
    private List<KeyValueIterator<Windowed<String>, Long>> iters = new ArrayList<KeyValueIterator<Windowed<String>, Long>>(7);
    private WindowStoreIterator<Long> windowStoreIter;

    @Before
    public void setup() {
        this.flushExecuted = false;
        this.putExecuted = false;
        this.putIfAbsentExecuted = false;
        this.putAllExecuted = false;
        this.deleteExecuted = false;
        this.removeExecuted = false;
        this.put3argExecuted = false;
        this.rangeIter = (KeyValueIterator)EasyMock.mock(KeyValueIterator.class);
        this.allIter = (KeyValueIterator)EasyMock.mock(KeyValueIterator.class);
        this.windowStoreIter = (WindowStoreIterator)EasyMock.mock(WindowStoreIterator.class);
        for (int i = 0; i < 7; ++i) {
            this.iters.add(i, (KeyValueIterator<Windowed<String>, Long>)EasyMock.mock(KeyValueIterator.class));
        }
        StreamsConfig streamsConfig = (StreamsConfig)EasyMock.mock(StreamsConfig.class);
        EasyMock.expect((Object)streamsConfig.getString("application.id")).andReturn((Object)"add-id");
        EasyMock.expect((Object)streamsConfig.defaultValueSerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.expect((Object)streamsConfig.defaultKeySerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.replay((Object[])new Object[]{streamsConfig});
        ProcessorStateManager stateManager = (ProcessorStateManager)EasyMock.mock(ProcessorStateManager.class);
        EasyMock.expect((Object)stateManager.getGlobalStore("GlobalKeyValueStore")).andReturn(this.keyValueStoreMock());
        EasyMock.expect((Object)stateManager.getGlobalStore("GlobalWindowStore")).andReturn(this.windowStoreMock());
        EasyMock.expect((Object)stateManager.getGlobalStore("GlobalSessionStore")).andReturn(this.sessionStoreMock());
        EasyMock.expect((Object)stateManager.getGlobalStore(EasyMock.anyString())).andReturn(null);
        EasyMock.expect((Object)stateManager.getStore("LocalKeyValueStore")).andReturn(this.keyValueStoreMock());
        EasyMock.expect((Object)stateManager.getStore("LocalWindowStore")).andReturn(this.windowStoreMock());
        EasyMock.expect((Object)stateManager.getStore("LocalSessionStore")).andReturn(this.sessionStoreMock());
        EasyMock.replay((Object[])new Object[]{stateManager});
        this.context = new ProcessorContextImpl((TaskId)EasyMock.mock(TaskId.class), (StreamTask)EasyMock.mock(StreamTask.class), streamsConfig, (RecordCollector)EasyMock.mock(RecordCollector.class), stateManager, (StreamsMetricsImpl)EasyMock.mock(StreamsMetricsImpl.class), (ThreadCache)EasyMock.mock(ThreadCache.class));
        this.context.setCurrentNode(new ProcessorNode("fake", null, new HashSet<String>(Arrays.asList("LocalKeyValueStore", "LocalWindowStore", "LocalSessionStore"))));
    }

    @Test
    public void globalKeyValueStoreShouldBeReadOnly() {
        this.doTest("GlobalKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((KeyValueStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)1L), "put()");
            this.checkThrowsUnsupportedOperation(() -> {
                Long cfr_ignored_0 = (Long)store.putIfAbsent((Object)"1", (Object)1L);
            }, "putIfAbsent()");
            this.checkThrowsUnsupportedOperation(() -> store.putAll(Collections.emptyList()), "putAll()");
            this.checkThrowsUnsupportedOperation(() -> {
                Long cfr_ignored_0 = (Long)store.delete((Object)"1");
            }, "delete()");
            Assert.assertEquals((Object)42L, (Object)store.get((Object)KEY));
            Assert.assertEquals(this.rangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assert.assertEquals(this.allIter, (Object)store.all());
            Assert.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void globalWindowStoreShouldBeReadOnly() {
        this.doTest("GlobalWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((WindowStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)1L, 1L), "put()");
            this.checkThrowsUnsupportedOperation(() -> store.put((Object)"1", (Object)1L), "put()");
            Assert.assertEquals(this.iters.get(0), (Object)store.fetchAll(0L, 0L));
            Assert.assertEquals(this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assert.assertEquals(this.iters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assert.assertEquals((Object)42L, (Object)store.fetch((Object)KEY, 1L));
            Assert.assertEquals(this.iters.get(2), (Object)store.all());
        });
    }

    @Test
    public void globalSessionStoreShouldBeReadOnly() {
        this.doTest("GlobalSessionStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            this.checkThrowsUnsupportedOperation(() -> ((SessionStore)store).flush(), "flush()");
            this.checkThrowsUnsupportedOperation(() -> store.remove(null), "remove()");
            this.checkThrowsUnsupportedOperation(() -> store.put(null, null), "put()");
            Assert.assertEquals(this.iters.get(3), (Object)store.findSessions((Object)KEY, 1L, 2L));
            Assert.assertEquals(this.iters.get(4), (Object)store.findSessions((Object)KEY, (Object)KEY, 1L, 2L));
            Assert.assertEquals(this.iters.get(5), (Object)store.fetch((Object)KEY));
            Assert.assertEquals(this.iters.get(6), (Object)store.fetch((Object)KEY, (Object)KEY));
        });
    }

    @Test
    public void localKeyValueStoreShouldNotAllowInitOrClose() {
        this.doTest("LocalKeyValueStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assert.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)1L);
            Assert.assertTrue((boolean)this.putExecuted);
            store.putIfAbsent((Object)"1", (Object)1L);
            Assert.assertTrue((boolean)this.putIfAbsentExecuted);
            store.putAll(Collections.emptyList());
            Assert.assertTrue((boolean)this.putAllExecuted);
            store.delete((Object)"1");
            Assert.assertTrue((boolean)this.deleteExecuted);
            Assert.assertEquals((Object)42L, (Object)store.get((Object)KEY));
            Assert.assertEquals(this.rangeIter, (Object)store.range((Object)"one", (Object)"two"));
            Assert.assertEquals(this.allIter, (Object)store.all());
            Assert.assertEquals((long)42L, (long)store.approximateNumEntries());
        });
    }

    @Test
    public void localWindowStoreShouldNotAllowInitOrClose() {
        this.doTest("LocalWindowStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assert.assertTrue((boolean)this.flushExecuted);
            store.put((Object)"1", (Object)1L);
            Assert.assertTrue((boolean)this.putExecuted);
            store.put((Object)"1", (Object)1L, 1L);
            Assert.assertTrue((boolean)this.put3argExecuted);
            Assert.assertEquals(this.iters.get(0), (Object)store.fetchAll(0L, 0L));
            Assert.assertEquals(this.windowStoreIter, (Object)store.fetch((Object)KEY, 0L, 1L));
            Assert.assertEquals(this.iters.get(1), (Object)store.fetch((Object)KEY, (Object)KEY, 0L, 1L));
            Assert.assertEquals((Object)42L, (Object)store.fetch((Object)KEY, 1L));
            Assert.assertEquals(this.iters.get(2), (Object)store.all());
        });
    }

    @Test
    public void localSessionStoreShouldNotAllowInitOrClose() {
        this.doTest("LocalSessionStore", store -> {
            this.verifyStoreCannotBeInitializedOrClosed((StateStore)store);
            store.flush();
            Assert.assertTrue((boolean)this.flushExecuted);
            store.remove(null);
            Assert.assertTrue((boolean)this.removeExecuted);
            store.put(null, null);
            Assert.assertTrue((boolean)this.putExecuted);
            Assert.assertEquals(this.iters.get(3), (Object)store.findSessions((Object)KEY, 1L, 2L));
            Assert.assertEquals(this.iters.get(4), (Object)store.findSessions((Object)KEY, (Object)KEY, 1L, 2L));
            Assert.assertEquals(this.iters.get(5), (Object)store.fetch((Object)KEY));
            Assert.assertEquals(this.iters.get(6), (Object)store.fetch((Object)KEY, (Object)KEY));
        });
    }

    private KeyValueStore<String, Long> keyValueStoreMock() {
        KeyValueStore keyValueStoreMock = (KeyValueStore)EasyMock.mock(KeyValueStore.class);
        this.initStateStoreMock((StateStore)keyValueStoreMock);
        EasyMock.expect((Object)keyValueStoreMock.get((Object)KEY)).andReturn((Object)42L);
        EasyMock.expect((Object)keyValueStoreMock.approximateNumEntries()).andReturn((Object)42L);
        EasyMock.expect((Object)keyValueStoreMock.range((Object)"one", (Object)"two")).andReturn(this.rangeIter);
        EasyMock.expect((Object)keyValueStoreMock.all()).andReturn(this.allIter);
        keyValueStoreMock.put((Object)EasyMock.anyString(), (Object)EasyMock.anyLong());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.putExecuted = true;
            return null;
        });
        keyValueStoreMock.putIfAbsent((Object)EasyMock.anyString(), (Object)EasyMock.anyLong());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.putIfAbsentExecuted = true;
            return null;
        });
        keyValueStoreMock.putAll((List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall().andAnswer(() -> {
            this.putAllExecuted = true;
            return null;
        });
        keyValueStoreMock.delete((Object)EasyMock.anyString());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.deleteExecuted = true;
            return null;
        });
        EasyMock.replay((Object[])new Object[]{keyValueStoreMock});
        return keyValueStoreMock;
    }

    private WindowStore<String, Long> windowStoreMock() {
        WindowStore windowStore = (WindowStore)EasyMock.mock(WindowStore.class);
        this.initStateStoreMock((StateStore)windowStore);
        EasyMock.expect((Object)windowStore.fetchAll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(this.iters.get(0));
        EasyMock.expect((Object)windowStore.fetch((Object)EasyMock.anyString(), (Object)EasyMock.anyString(), EasyMock.anyLong(), EasyMock.anyLong())).andReturn(this.iters.get(1));
        EasyMock.expect((Object)windowStore.fetch((Object)EasyMock.anyString(), EasyMock.anyLong(), EasyMock.anyLong())).andReturn(this.windowStoreIter);
        EasyMock.expect((Object)windowStore.fetch((Object)EasyMock.anyString(), EasyMock.anyLong())).andReturn((Object)42L);
        EasyMock.expect((Object)windowStore.all()).andReturn(this.iters.get(2));
        windowStore.put((Object)EasyMock.anyString(), (Object)EasyMock.anyLong());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.putExecuted = true;
            return null;
        });
        windowStore.put((Object)EasyMock.anyString(), (Object)EasyMock.anyLong(), EasyMock.anyLong());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.put3argExecuted = true;
            return null;
        });
        EasyMock.replay((Object[])new Object[]{windowStore});
        return windowStore;
    }

    private SessionStore<String, Long> sessionStoreMock() {
        SessionStore sessionStore = (SessionStore)EasyMock.mock(SessionStore.class);
        this.initStateStoreMock((StateStore)sessionStore);
        EasyMock.expect((Object)sessionStore.findSessions((Object)EasyMock.anyString(), EasyMock.anyLong(), EasyMock.anyLong())).andReturn(this.iters.get(3));
        EasyMock.expect((Object)sessionStore.findSessions((Object)EasyMock.anyString(), (Object)EasyMock.anyString(), EasyMock.anyLong(), EasyMock.anyLong())).andReturn(this.iters.get(4));
        EasyMock.expect((Object)sessionStore.fetch((Object)EasyMock.anyString())).andReturn(this.iters.get(5));
        EasyMock.expect((Object)sessionStore.fetch((Object)EasyMock.anyString(), (Object)EasyMock.anyString())).andReturn(this.iters.get(6));
        sessionStore.put((Windowed)EasyMock.anyObject(Windowed.class), (Object)EasyMock.anyLong());
        EasyMock.expectLastCall().andAnswer(() -> {
            this.putExecuted = true;
            return null;
        });
        sessionStore.remove((Windowed)EasyMock.anyObject(Windowed.class));
        EasyMock.expectLastCall().andAnswer(() -> {
            this.removeExecuted = true;
            return null;
        });
        EasyMock.replay((Object[])new Object[]{sessionStore});
        return sessionStore;
    }

    private void initStateStoreMock(StateStore stateStore) {
        EasyMock.expect((Object)stateStore.name()).andReturn((Object)STORE_NAME);
        EasyMock.expect((Object)stateStore.persistent()).andReturn((Object)true);
        EasyMock.expect((Object)stateStore.isOpen()).andReturn((Object)true);
        stateStore.flush();
        EasyMock.expectLastCall().andAnswer(() -> {
            this.flushExecuted = true;
            return null;
        });
    }

    private <T extends StateStore> void doTest(final String name, final Consumer<T> checker) {
        Processor<String, Long> processor = new Processor<String, Long>(){

            public void init(ProcessorContext context) {
                StateStore store = context.getStateStore(name);
                checker.accept(store);
            }

            public void process(String k, Long v) {
            }

            public void close() {
            }
        };
        processor.init((ProcessorContext)this.context);
    }

    private void verifyStoreCannotBeInitializedOrClosed(StateStore store) {
        Assert.assertEquals((Object)STORE_NAME, (Object)store.name());
        Assert.assertTrue((boolean)store.persistent());
        Assert.assertTrue((boolean)store.isOpen());
        this.checkThrowsUnsupportedOperation(() -> store.init(null, null), "init()");
        this.checkThrowsUnsupportedOperation(() -> ((StateStore)store).close(), "close()");
    }

    private void checkThrowsUnsupportedOperation(Runnable check, String name) {
        try {
            check.run();
            Assert.fail((String)(name + " should throw exception"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

