/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamTransformTest {
    private String topicName = "topic";
    private final ConsumerRecordFactory<Integer, Integer> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.Integer());
    @Rule
    public final KStreamTestDriver kstreamDriver = new KStreamTestDriver();

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        TransformerSupplier<Number, Number, KeyValue<Integer, Integer>> transformerSupplier = new TransformerSupplier<Number, Number, KeyValue<Integer, Integer>>(){

            public Transformer<Number, Number, KeyValue<Integer, Integer>> get() {
                return new Transformer<Number, Number, KeyValue<Integer, Integer>>(){
                    private int total = 0;

                    public void init(ProcessorContext context) {
                    }

                    public KeyValue<Integer, Integer> transform(Number key, Number value) {
                        this.total += value.intValue();
                        return KeyValue.pair((Object)(key.intValue() * 2), (Object)this.total);
                    }

                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transform((TransformerSupplier)transformerSupplier, new String[0]).process(processor, new String[0]);
        this.kstreamDriver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.kstreamDriver.process(this.topicName, expectedKey, expectedKey * 10);
        }
        String[] expected = new String[]{"2:10", "20:110", "200:1110", "2000:11110"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.theCapturedProcessor().processed.get(i));
        }
    }

    @Test
    public void testTransformWithNewDriverAndPunctuator() {
        StreamsBuilder builder = new StreamsBuilder();
        TransformerSupplier<Number, Number, KeyValue<Integer, Integer>> transformerSupplier = new TransformerSupplier<Number, Number, KeyValue<Integer, Integer>>(){

            public Transformer<Number, Number, KeyValue<Integer, Integer>> get() {
                return new Transformer<Number, Number, KeyValue<Integer, Integer>>(){
                    private int total = 0;

                    public void init(final ProcessorContext context) {
                        context.schedule(Duration.ofMillis(1L), PunctuationType.WALL_CLOCK_TIME, new Punctuator(){

                            public void punctuate(long timestamp) {
                                context.forward((Object)-1, (Object)((int)timestamp));
                            }
                        });
                    }

                    public KeyValue<Integer, Integer> transform(Number key, Number value) {
                        this.total += value.intValue();
                        return KeyValue.pair((Object)(key.intValue() * 2), (Object)this.total);
                    }

                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.topicName, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transform((TransformerSupplier)transformerSupplier, new String[0]).process(processor, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props, 0L);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(this.topicName, (Object)expectedKey, (Object)(expectedKey * 10), 0L));
            }
            driver.advanceWallClockTime(2L);
            driver.advanceWallClockTime(1L);
        }
        Assert.assertEquals((long)6L, (long)processor.theCapturedProcessor().processed.size());
        String[] expected = new String[]{"2:10", "20:110", "200:1110", "2000:11110", "-1:2", "-1:3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.theCapturedProcessor().processed.get(i));
        }
    }
}

