/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Collections;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamSourceNode;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class TableSourceNode<K, V, S extends StateStore>
extends StreamSourceNode<K, V> {
    private final StoreBuilder<S> storeBuilder;
    private final ProcessorParameters<K, V> processorParameters;
    private final String sourceName;
    private final boolean isGlobalKTable;

    TableSourceNode(String nodeName, String sourceName, String topic, ConsumedInternal<K, V> consumedInternal, StoreBuilder<S> storeBuilder, ProcessorParameters<K, V> processorParameters, boolean isGlobalKTable) {
        super(nodeName, Collections.singletonList(topic), consumedInternal);
        this.processorParameters = processorParameters;
        this.sourceName = sourceName;
        this.isGlobalKTable = isGlobalKTable;
        this.storeBuilder = storeBuilder;
    }

    public boolean isGlobalKTable() {
        return this.isGlobalKTable;
    }

    @Override
    public String toString() {
        return "TableSourceNode{storeBuilder=" + this.storeBuilder + ", processorParameters=" + this.processorParameters + ", sourceName='" + this.sourceName + '\'' + ", isGlobalKTable=" + this.isGlobalKTable + "} " + super.toString();
    }

    public static <K, V, S extends StateStore> TableSourceNodeBuilder<K, V, S> tableSourceNodeBuilder() {
        return new TableSourceNodeBuilder();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String topicName = this.getTopicNames().iterator().next();
        if (this.isGlobalKTable) {
            topologyBuilder.addGlobalStore(this.storeBuilder, this.sourceName, this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), topicName, this.processorParameters.processorName(), this.processorParameters.processorSupplier());
        } else {
            topologyBuilder.addSource(this.consumedInternal().offsetResetPolicy(), this.sourceName, this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), topicName);
            topologyBuilder.addProcessor(this.processorParameters.processorName(), this.processorParameters.processorSupplier(), this.sourceName);
            topologyBuilder.addStateStore(this.storeBuilder, this.nodeName());
            topologyBuilder.markSourceStoreAndTopic(this.storeBuilder, topicName);
        }
    }

    public static final class TableSourceNodeBuilder<K, V, S extends StateStore> {
        private String nodeName;
        private String sourceName;
        private String topic;
        private ConsumedInternal<K, V> consumedInternal;
        private StoreBuilder<S> storeBuilder;
        private ProcessorParameters<K, V> processorParameters;
        private boolean isGlobalKTable = false;

        private TableSourceNodeBuilder() {
        }

        public TableSourceNodeBuilder<K, V, S> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> withStoreBuilder(StoreBuilder<S> storeBuilder) {
            this.storeBuilder = storeBuilder;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> withConsumedInternal(ConsumedInternal consumedInternal) {
            this.consumedInternal = consumedInternal;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> withProcessorParameters(ProcessorParameters<K, V> processorParameters) {
            this.processorParameters = processorParameters;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public TableSourceNodeBuilder<K, V, S> isGlobalKTable(boolean isGlobaKTable) {
            this.isGlobalKTable = isGlobaKTable;
            return this;
        }

        public TableSourceNode<K, V, S> build() {
            return new TableSourceNode<K, V, S>(this.nodeName, this.sourceName, this.topic, this.consumedInternal, this.storeBuilder, this.processorParameters, this.isGlobalKTable);
        }
    }
}

