/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.NamedCache;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.Assert;
import org.junit.Test;

public class ThreadCacheTest {
    final String namespace = "0.0-namespace";
    final String namespace1 = "0.1-namespace";
    final String namespace2 = "0.2-namespace";
    private final LogContext logContext = new LogContext("testCache ");

    @Test
    public void basicPutGet() throws IOException {
        Bytes key;
        List<KeyValue> toInsert = Arrays.asList(new KeyValue((Object)"K1", (Object)"V1"), new KeyValue((Object)"K2", (Object)"V2"), new KeyValue((Object)"K3", (Object)"V3"), new KeyValue((Object)"K4", (Object)"V4"), new KeyValue((Object)"K5", (Object)"V5"));
        KeyValue kv = toInsert.get(0);
        ThreadCache cache = new ThreadCache(this.logContext, (long)(toInsert.size() * ThreadCacheTest.memoryCacheEntrySize(((String)kv.key).getBytes(), ((String)kv.value).getBytes(), "")), (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        for (KeyValue kvToInsert : toInsert) {
            key = Bytes.wrap((byte[])((String)kvToInsert.key).getBytes());
            byte[] value = ((String)kvToInsert.value).getBytes();
            cache.put("0.0-namespace", key, new LRUCacheEntry(value, null, true, 1L, 1L, 1, ""));
        }
        for (KeyValue kvToInsert : toInsert) {
            key = Bytes.wrap((byte[])((String)kvToInsert.key).getBytes());
            LRUCacheEntry entry = cache.get("0.0-namespace", key);
            Assert.assertEquals((Object)entry.isDirty(), (Object)true);
            Assert.assertEquals((Object)new String(entry.value()), (Object)kvToInsert.value);
        }
        Assert.assertEquals((long)cache.gets(), (long)5L);
        Assert.assertEquals((long)cache.puts(), (long)5L);
        Assert.assertEquals((long)cache.evicts(), (long)0L);
        Assert.assertEquals((long)cache.flushes(), (long)0L);
    }

    private void checkOverheads(double entryFactor, double systemFactor, long desiredCacheSize, int keySizeBytes, int valueSizeBytes) {
        Runtime runtime = Runtime.getRuntime();
        long numElements = desiredCacheSize / (long)ThreadCacheTest.memoryCacheEntrySize(new byte[keySizeBytes], new byte[valueSizeBytes], "");
        System.gc();
        long prevRuntimeMemory = runtime.totalMemory() - runtime.freeMemory();
        ThreadCache cache = new ThreadCache(this.logContext, desiredCacheSize, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        long size = cache.sizeBytes();
        Assert.assertEquals((long)size, (long)0L);
        int i = 0;
        while ((long)i < numElements) {
            String keyStr = "K" + i;
            Bytes key = Bytes.wrap((byte[])keyStr.getBytes());
            byte[] value = new byte[valueSizeBytes];
            cache.put("0.0-namespace", key, new LRUCacheEntry(value, null, true, 1L, 1L, 1, ""));
            ++i;
        }
        System.gc();
        double ceiling = (double)desiredCacheSize + (double)desiredCacheSize * entryFactor;
        long usedRuntimeMemory = runtime.totalMemory() - runtime.freeMemory() - prevRuntimeMemory;
        Assert.assertTrue(((double)cache.sizeBytes() <= ceiling ? 1 : 0) != 0);
        Assert.assertTrue((String)("Used memory size " + usedRuntimeMemory + " greater than expected " + (double)cache.sizeBytes() * systemFactor), ((double)cache.sizeBytes() * systemFactor >= (double)usedRuntimeMemory ? 1 : 0) != 0);
    }

    @Test
    public void cacheOverheadsSmallValues() {
        Runtime runtime = Runtime.getRuntime();
        double factor = 0.05;
        double systemFactor = 3.0;
        long desiredCacheSize = Math.min(0x6400000L, runtime.maxMemory());
        int keySizeBytes = 8;
        int valueSizeBytes = 100;
        this.checkOverheads(0.05, 3.0, desiredCacheSize, 8, 100);
    }

    @Test
    public void cacheOverheadsLargeValues() {
        Runtime runtime = Runtime.getRuntime();
        double factor = 0.05;
        double systemFactor = 2.0;
        long desiredCacheSize = Math.min(0x6400000L, runtime.maxMemory());
        int keySizeBytes = 8;
        int valueSizeBytes = 1000;
        this.checkOverheads(0.05, 2.0, desiredCacheSize, 8, 1000);
    }

    static int memoryCacheEntrySize(byte[] key, byte[] value, String topic) {
        return key.length + value.length + 1 + 8 + 8 + 4 + topic.length() + key.length + 8 + 8 + 8;
    }

    @Test
    public void evict() throws IOException {
        final ArrayList received = new ArrayList();
        List<KeyValue> expected = Collections.singletonList(new KeyValue((Object)"K1", (Object)"V1"));
        List<KeyValue> toInsert = Arrays.asList(new KeyValue((Object)"K1", (Object)"V1"), new KeyValue((Object)"K2", (Object)"V2"), new KeyValue((Object)"K3", (Object)"V3"), new KeyValue((Object)"K4", (Object)"V4"), new KeyValue((Object)"K5", (Object)"V5"));
        KeyValue kv = toInsert.get(0);
        ThreadCache cache = new ThreadCache(this.logContext, (long)ThreadCacheTest.memoryCacheEntrySize(((String)kv.key).getBytes(), ((String)kv.value).getBytes(), ""), (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                for (ThreadCache.DirtyEntry dirtyEntry : dirty) {
                    received.add(new KeyValue((Object)dirtyEntry.key().toString(), (Object)new String(dirtyEntry.newValue())));
                }
            }
        });
        for (KeyValue kvToInsert : toInsert) {
            Bytes key = Bytes.wrap((byte[])((String)kvToInsert.key).getBytes());
            byte[] value = ((String)kvToInsert.value).getBytes();
            cache.put("0.0-namespace", key, new LRUCacheEntry(value, null, true, 1L, 1L, 1, ""));
        }
        for (int i = 0; i < expected.size(); ++i) {
            KeyValue expectedRecord = expected.get(i);
            KeyValue actualRecord = (KeyValue)received.get(i);
            Assert.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
        Assert.assertEquals((long)cache.evicts(), (long)4L);
    }

    @Test
    public void shouldDelete() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        cache.put("0.0-namespace", key, this.dirtyEntry(key.get()));
        Assert.assertEquals((Object)key.get(), (Object)cache.delete("0.0-namespace", key).value());
        Assert.assertNull((Object)cache.get("0.0-namespace", key));
    }

    @Test
    public void shouldNotFlushAfterDelete() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        final ArrayList received = new ArrayList();
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                received.addAll(dirty);
            }
        });
        cache.put("0.0-namespace", key, this.dirtyEntry(key.get()));
        Assert.assertEquals((Object)key.get(), (Object)cache.delete("0.0-namespace", key).value());
        cache.flush("0.0-namespace");
        Assert.assertEquals((long)0L, (long)received.size());
        Assert.assertEquals((long)cache.flushes(), (long)1L);
    }

    @Test
    public void shouldNotBlowUpOnNonExistentKeyWhenDeleting() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.put("0.0-namespace", key, this.dirtyEntry(key.get()));
        Assert.assertNull((Object)cache.delete("0.0-namespace", Bytes.wrap((byte[])new byte[]{1})));
    }

    @Test
    public void shouldNotBlowUpOnNonExistentNamespaceWhenDeleting() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Assert.assertNull((Object)cache.delete("0.0-namespace", Bytes.wrap((byte[])new byte[]{1})));
    }

    @Test
    public void shouldNotClashWithOverlappingNames() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Bytes nameByte = Bytes.wrap((byte[])new byte[]{0});
        Bytes name1Byte = Bytes.wrap((byte[])new byte[]{1});
        cache.put("0.1-namespace", nameByte, this.dirtyEntry(nameByte.get()));
        cache.put("0.2-namespace", nameByte, this.dirtyEntry(name1Byte.get()));
        Assert.assertArrayEquals((byte[])nameByte.get(), (byte[])cache.get("0.1-namespace", nameByte).value());
        Assert.assertArrayEquals((byte[])name1Byte.get(), (byte[])cache.get("0.2-namespace", nameByte).value());
    }

    @Test
    public void shouldPeekNextKey() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Bytes theByte = Bytes.wrap((byte[])new byte[]{0});
        cache.put("0.0-namespace", theByte, this.dirtyEntry(theByte.get()));
        ThreadCache.MemoryLRUCacheBytesIterator iterator = cache.range("0.0-namespace", theByte, Bytes.wrap((byte[])new byte[]{1}));
        Assert.assertEquals((Object)theByte, (Object)iterator.peekNextKey());
        Assert.assertEquals((Object)theByte, (Object)iterator.peekNextKey());
    }

    @Test
    public void shouldGetSameKeyAsPeekNext() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Bytes theByte = Bytes.wrap((byte[])new byte[]{0});
        cache.put("0.0-namespace", theByte, this.dirtyEntry(theByte.get()));
        ThreadCache.MemoryLRUCacheBytesIterator iterator = cache.range("0.0-namespace", theByte, Bytes.wrap((byte[])new byte[]{1}));
        Assert.assertEquals((Object)iterator.peekNextKey(), (Object)iterator.next().key);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowIfNoPeekNextKey() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        ThreadCache.MemoryLRUCacheBytesIterator iterator = cache.range("0.0-namespace", Bytes.wrap((byte[])new byte[]{0}), Bytes.wrap((byte[])new byte[]{1}));
        iterator.peekNextKey();
    }

    @Test
    public void shouldReturnFalseIfNoNextKey() {
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        ThreadCache.MemoryLRUCacheBytesIterator iterator = cache.range("0.0-namespace", Bytes.wrap((byte[])new byte[]{0}), Bytes.wrap((byte[])new byte[]{1}));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldPeekAndIterateOverRange() {
        byte[][] bytes;
        ThreadCache cache = new ThreadCache(this.logContext, 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}}) {
            cache.put("0.0-namespace", Bytes.wrap((byte[])aByte), this.dirtyEntry(aByte));
        }
        ThreadCache.MemoryLRUCacheBytesIterator iterator = cache.range("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), Bytes.wrap((byte[])new byte[]{4}));
        int bytesIndex = 1;
        while (iterator.hasNext()) {
            Bytes peekedKey = iterator.peekNextKey();
            KeyValue next = iterator.next();
            Assert.assertArrayEquals((byte[])bytes[bytesIndex], (byte[])peekedKey.get());
            Assert.assertArrayEquals((byte[])bytes[bytesIndex], (byte[])((Bytes)next.key).get());
            ++bytesIndex;
        }
        Assert.assertEquals((long)5L, (long)bytesIndex);
    }

    @Test
    public void shouldSkipEntriesWhereValueHasBeenEvictedFromCache() {
        int entrySize = ThreadCacheTest.memoryCacheEntrySize(new byte[1], new byte[1], "");
        ThreadCache cache = new ThreadCache(this.logContext, (long)(entrySize * 5), (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
            }
        });
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}};
        for (int i = 0; i < 5; ++i) {
            cache.put("0.0-namespace", Bytes.wrap((byte[])bytes[i]), this.dirtyEntry(bytes[i]));
        }
        Assert.assertEquals((long)5L, (long)cache.size());
        ThreadCache.MemoryLRUCacheBytesIterator range = cache.range("0.0-namespace", Bytes.wrap((byte[])new byte[]{0}), Bytes.wrap((byte[])new byte[]{5}));
        cache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{6}), this.dirtyEntry(new byte[]{6}));
        Assert.assertEquals((Object)Bytes.wrap((byte[])new byte[]{1}), (Object)range.peekNextKey());
    }

    @Test
    public void shouldFlushDirtyEntriesForNamespace() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        final ArrayList received = new ArrayList();
        cache.addDirtyEntryFlushListener("0.1-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                for (ThreadCache.DirtyEntry dirtyEntry : dirty) {
                    received.add(dirtyEntry.key().get());
                }
            }
        });
        List<byte[]> expected = Arrays.asList({0}, {1}, {2});
        for (byte[] bytes : expected) {
            cache.put("0.1-namespace", Bytes.wrap((byte[])bytes), this.dirtyEntry(bytes));
        }
        cache.put("0.2-namespace", Bytes.wrap((byte[])new byte[]{4}), this.dirtyEntry(new byte[]{4}));
        cache.flush("0.1-namespace");
        Assert.assertEquals(expected, received);
    }

    @Test
    public void shouldNotFlushCleanEntriesForNamespace() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        final ArrayList received = new ArrayList();
        cache.addDirtyEntryFlushListener("0.1-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                for (ThreadCache.DirtyEntry dirtyEntry : dirty) {
                    received.add(dirtyEntry.key().get());
                }
            }
        });
        List<byte[]> toInsert = Arrays.asList({0}, {1}, {2});
        for (byte[] bytes : toInsert) {
            cache.put("0.1-namespace", Bytes.wrap((byte[])bytes), this.cleanEntry(bytes));
        }
        cache.put("0.2-namespace", Bytes.wrap((byte[])new byte[]{4}), this.cleanEntry(new byte[]{4}));
        cache.flush("0.1-namespace");
        Assert.assertEquals((Object)Collections.EMPTY_LIST, received);
    }

    private void shouldEvictImmediatelyIfCacheSizeIsZeroOrVerySmall(ThreadCache cache) {
        final ArrayList received = new ArrayList();
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                received.addAll(dirty);
            }
        });
        cache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{0}), this.dirtyEntry(new byte[]{0}));
        Assert.assertEquals((long)1L, (long)received.size());
        cache.flush("0.0-namespace");
        Assert.assertEquals((long)1L, (long)received.size());
    }

    @Test
    public void shouldEvictImmediatelyIfCacheSizeIsVerySmall() {
        ThreadCache cache = new ThreadCache(this.logContext, 1L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.shouldEvictImmediatelyIfCacheSizeIsZeroOrVerySmall(cache);
    }

    @Test
    public void shouldEvictImmediatelyIfCacheSizeIsZero() {
        ThreadCache cache = new ThreadCache(this.logContext, 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.shouldEvictImmediatelyIfCacheSizeIsZeroOrVerySmall(cache);
    }

    @Test
    public void shouldEvictAfterPutAll() {
        final ArrayList received = new ArrayList();
        ThreadCache cache = new ThreadCache(this.logContext, 1L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                received.addAll(dirty);
            }
        });
        cache.putAll("0.0-namespace", Arrays.asList(KeyValue.pair((Object)Bytes.wrap((byte[])new byte[]{0}), (Object)this.dirtyEntry(new byte[]{5})), KeyValue.pair((Object)Bytes.wrap((byte[])new byte[]{1}), (Object)this.dirtyEntry(new byte[]{6}))));
        Assert.assertEquals((long)cache.evicts(), (long)2L);
        Assert.assertEquals((long)received.size(), (long)2L);
    }

    @Test
    public void shouldPutAll() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.putAll("0.0-namespace", Arrays.asList(KeyValue.pair((Object)Bytes.wrap((byte[])new byte[]{0}), (Object)this.dirtyEntry(new byte[]{5})), KeyValue.pair((Object)Bytes.wrap((byte[])new byte[]{1}), (Object)this.dirtyEntry(new byte[]{6}))));
        Assert.assertArrayEquals((byte[])new byte[]{5}, (byte[])cache.get("0.0-namespace", Bytes.wrap((byte[])new byte[]{0})).value());
        Assert.assertArrayEquals((byte[])new byte[]{6}, (byte[])cache.get("0.0-namespace", Bytes.wrap((byte[])new byte[]{1})).value());
    }

    @Test
    public void shouldNotForwardCleanEntryOnEviction() {
        ThreadCache cache = new ThreadCache(this.logContext, 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        final ArrayList received = new ArrayList();
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                received.addAll(dirty);
            }
        });
        cache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), this.cleanEntry(new byte[]{0}));
        Assert.assertEquals((long)0L, (long)received.size());
    }

    @Test
    public void shouldPutIfAbsent() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        Bytes key = Bytes.wrap((byte[])new byte[]{10});
        byte[] value = new byte[]{30};
        Assert.assertNull((Object)cache.putIfAbsent("0.0-namespace", key, this.dirtyEntry(value)));
        Assert.assertArrayEquals((byte[])value, (byte[])cache.putIfAbsent("0.0-namespace", key, this.dirtyEntry(new byte[]{8})).value());
        Assert.assertArrayEquals((byte[])value, (byte[])cache.get("0.0-namespace", key).value());
    }

    @Test
    public void shouldEvictAfterPutIfAbsent() {
        final ArrayList received = new ArrayList();
        ThreadCache cache = new ThreadCache(this.logContext, 1L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                received.addAll(dirty);
            }
        });
        cache.putIfAbsent("0.0-namespace", Bytes.wrap((byte[])new byte[]{0}), this.dirtyEntry(new byte[]{5}));
        cache.putIfAbsent("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), this.dirtyEntry(new byte[]{6}));
        cache.putIfAbsent("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), this.dirtyEntry(new byte[]{6}));
        Assert.assertEquals((long)cache.evicts(), (long)3L);
        Assert.assertEquals((long)received.size(), (long)3L);
    }

    @Test
    public void shouldNotLoopForEverWhenEvictingAndCurrentCacheIsEmpty() {
        int maxCacheSizeInBytes = 100;
        final ThreadCache threadCache = new ThreadCache(this.logContext, 100L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        threadCache.addDirtyEntryFlushListener("0.0-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
                threadCache.put("0.1-namespace", Bytes.wrap((byte[])new byte[]{0}), ThreadCacheTest.this.dirtyEntry(new byte[2]));
            }
        });
        threadCache.addDirtyEntryFlushListener("0.1-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
            }
        });
        threadCache.addDirtyEntryFlushListener("0.2-namespace", new ThreadCache.DirtyEntryFlushListener(){

            public void apply(List<ThreadCache.DirtyEntry> dirty) {
            }
        });
        threadCache.put("0.2-namespace", Bytes.wrap((byte[])new byte[]{1}), this.dirtyEntry(new byte[1]));
        threadCache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), this.dirtyEntry(new byte[1]));
        int remaining = (int)(100L - threadCache.sizeBytes());
        threadCache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{2}), this.dirtyEntry(new byte[remaining + 100]));
    }

    @Test
    public void shouldCleanupNamedCacheOnClose() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        cache.put("0.1-namespace", Bytes.wrap((byte[])new byte[]{1}), this.cleanEntry(new byte[]{1}));
        cache.put("0.2-namespace", Bytes.wrap((byte[])new byte[]{1}), this.cleanEntry(new byte[]{1}));
        Assert.assertEquals((long)cache.size(), (long)2L);
        cache.close("0.2-namespace");
        Assert.assertEquals((long)cache.size(), (long)1L);
        Assert.assertNull((Object)cache.get("0.2-namespace", Bytes.wrap((byte[])new byte[]{1})));
    }

    @Test
    public void shouldReturnNullIfKeyIsNull() {
        ThreadCache threadCache = new ThreadCache(this.logContext, 10L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        threadCache.put("0.0-namespace", Bytes.wrap((byte[])new byte[]{1}), this.cleanEntry(new byte[]{1}));
        Assert.assertNull((Object)threadCache.get("0.0-namespace", null));
    }

    @Test
    public void shouldCalculateSizeInBytes() {
        ThreadCache cache = new ThreadCache(this.logContext, 100000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        NamedCache.LRUNode node = new NamedCache.LRUNode(Bytes.wrap((byte[])new byte[]{1}), this.dirtyEntry(new byte[]{0}));
        cache.put("0.1-namespace", Bytes.wrap((byte[])new byte[]{1}), this.cleanEntry(new byte[]{0}));
        Assert.assertEquals((long)cache.sizeBytes(), (long)node.size());
    }

    private LRUCacheEntry dirtyEntry(byte[] key) {
        return new LRUCacheEntry(key, null, true, -1L, -1L, -1, "");
    }

    private LRUCacheEntry cleanEntry(byte[] key) {
        return new LRUCacheEntry(key);
    }
}

