/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.state.HostInfo;
import org.junit.Assert;
import org.junit.Test;

public class AssignmentInfoTest {
    private final List<TaskId> activeTasks = Arrays.asList(new TaskId(0, 0), new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0));
    private final Map<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(){
        {
            this.put(new TaskId(1, 1), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}));
            this.put(new TaskId(2, 0), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t3", 0), new TopicPartition("t3", 0)}));
        }
    };
    private final Map<HostInfo, Set<TopicPartition>> globalAssignment = new HashMap<HostInfo, Set<TopicPartition>>(){
        {
            this.put(new HostInfo("localhost", 80), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t3", 3)}));
        }
    };

    @Test
    public void shouldUseLatestSupportedVersionByDefault() {
        AssignmentInfo info = new AssignmentInfo(this.activeTasks, this.standbyTasks, this.globalAssignment);
        Assert.assertEquals((long)4L, (long)info.version());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion1() {
        new AssignmentInfo(0, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion2() {
        new AssignmentInfo(5, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        AssignmentInfo info = new AssignmentInfo(1, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(1, -1, this.activeTasks, this.standbyTasks, Collections.emptyMap(), 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        AssignmentInfo info = new AssignmentInfo(2, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(2, -1, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion3() {
        AssignmentInfo info = new AssignmentInfo(3, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(3, 4, this.activeTasks, this.standbyTasks, this.globalAssignment, 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion4() {
        AssignmentInfo info = new AssignmentInfo(4, this.activeTasks, this.standbyTasks, this.globalAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(4, 4, this.activeTasks, this.standbyTasks, this.globalAssignment, 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }
}

