/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AssignedStreamsTasks;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AssignedStreamsTasksTest {
    private final StreamTask t1 = (StreamTask)EasyMock.createMock(StreamTask.class);
    private final StreamTask t2 = (StreamTask)EasyMock.createMock(StreamTask.class);
    private final TopicPartition tp1 = new TopicPartition("t1", 0);
    private final TopicPartition tp2 = new TopicPartition("t2", 0);
    private final TopicPartition changeLog1 = new TopicPartition("cl1", 0);
    private final TopicPartition changeLog2 = new TopicPartition("cl2", 0);
    private final TaskId taskId1 = new TaskId(0, 0);
    private final TaskId taskId2 = new TaskId(1, 0);
    private AssignedStreamsTasks assignedTasks;

    @Before
    public void before() {
        this.assignedTasks = new AssignedStreamsTasks(new LogContext("log "));
        EasyMock.expect((Object)this.t1.id()).andReturn((Object)this.taskId1).anyTimes();
        EasyMock.expect((Object)this.t2.id()).andReturn((Object)this.taskId2).anyTimes();
    }

    @Test
    public void shouldInitializeNewTasks() {
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1));
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldMoveInitializedTasksNeedingRestoreToRestoring() {
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1));
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet());
        EasyMock.expect((Object)this.t2.initializeStateStores()).andReturn((Object)true);
        this.t2.initializeTopology();
        EasyMock.expectLastCall().once();
        Set<TopicPartition> t2partitions = Collections.singleton(this.tp2);
        EasyMock.expect((Object)this.t2.partitions()).andReturn(t2partitions);
        EasyMock.expect((Object)this.t2.changelogPartitions()).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.t1, this.t2});
        this.assignedTasks.addNewTask((Task)this.t1);
        this.assignedTasks.addNewTask((Task)this.t2);
        this.assignedTasks.initializeNewTasks();
        Collection restoring = this.assignedTasks.restoringTasks();
        MatcherAssert.assertThat((Object)restoring.size(), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertSame(restoring.iterator().next(), (Object)this.t1);
    }

    @Test
    public void shouldMoveInitializedTasksThatDontNeedRestoringToRunning() {
        EasyMock.expect((Object)this.t2.initializeStateStores()).andReturn((Object)true);
        this.t2.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t2.partitions()).andReturn(Collections.singleton(this.tp2));
        EasyMock.expect((Object)this.t2.changelogPartitions()).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.t2});
        this.assignedTasks.addNewTask((Task)this.t2);
        this.assignedTasks.initializeNewTasks();
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId2)));
    }

    @Test
    public void shouldTransitionFullyRestoredTasksToRunning() {
        Set task1Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.tp1});
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn((Object)task1Partitions).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn((Object)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog1, this.changeLog2})).anyTimes();
        EasyMock.expect((Object)this.t1.hasStateStores()).andReturn((Object)true).anyTimes();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.assignedTasks.updateRestored((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog1}));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.emptySet()));
        this.assignedTasks.updateRestored((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog2}));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
    }

    @Test
    public void shouldSuspendRunningTasks() {
        this.mockRunningTaskSuspension();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.assignedTasks.previousTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseRestoringTasks() {
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1));
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet());
        this.t1.close(false, false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldClosedUnInitializedTasksOnSuspend() {
        this.t1.close(false, false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.assignedTasks.addNewTask((Task)this.t1);
        MatcherAssert.assertThat((Object)this.assignedTasks.suspend(), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotSuspendSuspendedTasks() {
        this.mockRunningTaskSuspension();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.assignedTasks.suspend(), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnSuspendWhenRuntimeException() {
        this.mockTaskInitialization();
        this.t1.suspend();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("KABOOM!"));
        this.t1.close(false, false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.assignedTasks.previousTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnSuspendIfTaskMigratedException() {
        this.mockTaskInitialization();
        this.t1.suspend();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)this.assignedTasks.previousTaskIds().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldResumeMatchingSuspendedTasks() {
        this.mockRunningTaskSuspension();
        this.t1.resume();
        EasyMock.expectLastCall();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)this.assignedTasks.maybeResumeSuspendedTask(this.taskId1, Collections.singleton(this.tp1)));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnResumeSuspendedIfTaskMigratedException() {
        this.mockRunningTaskSuspension();
        this.t1.resume();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        try {
            this.assignedTasks.maybeResumeSuspendedTask(this.taskId1, Collections.singleton(this.tp1));
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    private void mockTaskInitialization() {
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)true);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1));
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptyList());
    }

    @Test
    public void shouldCommitRunningTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.assignedTasks.commit();
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnCommitIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.commit();
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldThrowExceptionOnCommitWhenNotCommitFailedOrProducerFenced() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException(""));
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.commit();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCommitRunningTasksIfNeeded() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitRequested()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.maybeCommitPerUserRequested(), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnMaybeCommitIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitRequested()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.maybeCommitPerUserRequested();
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnProcessesIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)true);
        this.t1.process();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.process(0L);
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotProcessUnprocessableTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.process(0L), (Matcher)IsEqual.equalTo((Object)0));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldAlwaysProcessProcessableTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.process()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.process(0L), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldPunctuateRunningTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.maybePunctuateSystemTime()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.punctuate(), (Matcher)IsEqual.equalTo((Object)2));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnMaybePunctuateStreamTimeIfTaskMigratedException() {
        this.mockTaskInitialization();
        this.t1.maybePunctuateStreamTime();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.punctuate();
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo((Object)Collections.EMPTY_SET));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnMaybePunctuateSystemTimeIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        this.t1.maybePunctuateSystemTime();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.punctuate();
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldReturnNumberOfPunctuations() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.maybePunctuateSystemTime()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.punctuate(), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    private void addAndInitTask() {
        this.assignedTasks.addNewTask((Task)this.t1);
        this.assignedTasks.initializeNewTasks();
    }

    private RuntimeException suspendTask() {
        this.addAndInitTask();
        return this.assignedTasks.suspend();
    }

    private void mockRunningTaskSuspension() {
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)true);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.hasStateStores()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptyList()).anyTimes();
        this.t1.suspend();
        EasyMock.expectLastCall();
    }
}

