/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.CacheFlushListener;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class CachingSessionStore<K, AGG>
extends WrappedStateStore.AbstractStateStore
implements SessionStore<Bytes, byte[]>,
CachedStateStore<Windowed<K>, AGG> {
    private final SessionStore<Bytes, byte[]> bytesStore;
    private final SessionKeySchema keySchema;
    private final Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    private final SegmentedCacheFunction cacheFunction;
    private String cacheName;
    private ThreadCache cache;
    private StateSerdes<K, AGG> serdes;
    private InternalProcessorContext context;
    private CacheFlushListener<Windowed<K>, AGG> flushListener;
    private boolean sendOldValues;
    private String topic;

    CachingSessionStore(SessionStore<Bytes, byte[]> bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde, long segmentInterval) {
        super(bytesStore);
        this.bytesStore = bytesStore;
        this.keySerde = keySerde;
        this.aggSerde = aggSerde;
        this.keySchema = new SessionKeySchema();
        this.cacheFunction = new SegmentedCacheFunction(this.keySchema, segmentInterval);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), root.name());
        this.initInternal((InternalProcessorContext)context);
        this.bytesStore.init(context, root);
    }

    private void initInternal(final InternalProcessorContext context) {
        this.context = context;
        this.keySchema.init(this.topic);
        this.serdes = new StateSerdes(this.topic, (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.aggSerde == null ? context.valueSerde() : this.aggSerde));
        this.cacheName = context.taskId() + "-" + this.bytesStore.name();
        this.cache = context.getCache();
        this.cache.addDirtyEntryFlushListener(this.cacheName, new ThreadCache.DirtyEntryFlushListener(){

            @Override
            public void apply(List<ThreadCache.DirtyEntry> entries) {
                for (ThreadCache.DirtyEntry entry : entries) {
                    CachingSessionStore.this.putAndMaybeForward(entry, context);
                }
            }
        });
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRangeFixedSize(key, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRangeFixedSize(key, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = this.bytesStore.findSessions(key, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(key, key, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator(filteredCacheIterator, storeIterator, this.cacheFunction);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRange(keyFrom, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRange(keyTo, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = this.bytesStore.findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator(filteredCacheIterator, storeIterator, this.cacheFunction);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        this.validateStoreOpen();
        this.put(sessionKey, null);
    }

    @Override
    public void put(Windowed<Bytes> key, byte[] value) {
        this.validateStoreOpen();
        Bytes binaryKey = Bytes.wrap((byte[])SessionKeySchema.toBinary(key));
        LRUCacheEntry entry = new LRUCacheEntry(value, this.context.headers(), true, this.context.offset(), this.context.timestamp(), this.context.partition(), this.context.topic());
        this.cache.put(this.cacheName, this.cacheFunction.cacheKey(binaryKey), entry);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext context) {
        Bytes binaryKey = this.cacheFunction.key(entry.key());
        ProcessorRecordContext current = context.recordContext();
        context.setRecordContext(entry.entry().context());
        try {
            Windowed<K> key = SessionKeySchema.from(binaryKey.get(), this.serdes.keyDeserializer(), this.topic);
            Bytes rawKey = Bytes.wrap((byte[])this.serdes.rawKey(key.key()));
            if (this.flushListener != null) {
                Object oldValue;
                AGG newValue = this.serdes.valueFrom(entry.newValue());
                Object v = oldValue = newValue == null || this.sendOldValues ? (Object)this.fetchPrevious(rawKey, key.window()) : null;
                if (newValue != null || oldValue != null) {
                    this.flushListener.apply(key, newValue, oldValue);
                }
            }
            this.bytesStore.put(new Windowed<Bytes>(rawKey, key.window()), entry.newValue());
        }
        finally {
            context.setRecordContext(current);
        }
    }

    private AGG fetchPrevious(Bytes rawKey, Window window) {
        try (KeyValueIterator<Windowed<Bytes>, byte[]> iterator = this.bytesStore.findSessions(rawKey, window.start(), window.end());){
            if (!iterator.hasNext()) {
                AGG AGG = null;
                return AGG;
            }
            AGG AGG = this.serdes.valueFrom((byte[])((KeyValue)iterator.next()).value);
            return AGG;
        }
    }

    @Override
    public void flush() {
        this.cache.flush(this.cacheName);
        this.bytesStore.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.cache.close(this.cacheName);
        this.bytesStore.close();
    }

    @Override
    public void setFlushListener(CacheFlushListener<Windowed<K>, AGG> flushListener, boolean sendOldValues) {
        this.flushListener = flushListener;
        this.sendOldValues = sendOldValues;
    }
}

