/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionInfo {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionInfo.class);
    public static final int LATEST_SUPPORTED_VERSION = 4;
    static final int UNKNOWN = -1;
    private final int usedVersion;
    private final int latestSupportedVersion;
    private UUID processId;
    private Set<TaskId> prevTasks;
    private Set<TaskId> standbyTasks;
    private String userEndPoint;

    private SubscriptionInfo(int version, int latestSupportedVersion) {
        this.usedVersion = version;
        this.latestSupportedVersion = latestSupportedVersion;
    }

    public SubscriptionInfo(UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        this(4, processId, prevTasks, standbyTasks, userEndPoint);
    }

    public SubscriptionInfo(int version, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        this(version, 4, processId, prevTasks, standbyTasks, userEndPoint);
        if (version < 1 || version > 4) {
            throw new IllegalArgumentException("version must be between 1 and 4; was: " + version);
        }
    }

    protected SubscriptionInfo(int version, int latestSupportedVersion, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        this.usedVersion = version;
        this.latestSupportedVersion = latestSupportedVersion;
        this.processId = processId;
        this.prevTasks = prevTasks;
        this.standbyTasks = standbyTasks;
        this.userEndPoint = userEndPoint;
    }

    public int version() {
        return this.usedVersion;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public UUID processId() {
        return this.processId;
    }

    public Set<TaskId> prevTasks() {
        return this.prevTasks;
    }

    public Set<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public String userEndPoint() {
        return this.userEndPoint;
    }

    public ByteBuffer encode() {
        ByteBuffer buf;
        switch (this.usedVersion) {
            case 1: {
                buf = this.encodeVersionOne();
                break;
            }
            case 2: {
                buf = this.encodeVersionTwo();
                break;
            }
            case 3: {
                buf = this.encodeVersionThree();
                break;
            }
            case 4: {
                buf = this.encodeVersionFour();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown metadata version: " + this.usedVersion + "; latest supported version: " + 4);
            }
        }
        buf.rewind();
        return buf;
    }

    private ByteBuffer encodeVersionOne() {
        ByteBuffer buf = ByteBuffer.allocate(this.getVersionOneByteLength());
        buf.putInt(1);
        this.encodeClientUUID(buf);
        this.encodeTasks(buf, this.prevTasks);
        this.encodeTasks(buf, this.standbyTasks);
        return buf;
    }

    private int getVersionOneByteLength() {
        return 24 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8;
    }

    protected void encodeClientUUID(ByteBuffer buf) {
        buf.putLong(this.processId.getMostSignificantBits());
        buf.putLong(this.processId.getLeastSignificantBits());
    }

    protected void encodeTasks(ByteBuffer buf, Collection<TaskId> taskIds) {
        buf.putInt(taskIds.size());
        for (TaskId id : taskIds) {
            id.writeTo(buf);
        }
    }

    protected byte[] prepareUserEndPoint() {
        if (this.userEndPoint == null) {
            return new byte[0];
        }
        return this.userEndPoint.getBytes(Charset.forName("UTF-8"));
    }

    private ByteBuffer encodeVersionTwo() {
        byte[] endPointBytes = this.prepareUserEndPoint();
        ByteBuffer buf = ByteBuffer.allocate(this.getVersionTwoByteLength(endPointBytes));
        buf.putInt(2);
        this.encodeClientUUID(buf);
        this.encodeTasks(buf, this.prevTasks);
        this.encodeTasks(buf, this.standbyTasks);
        this.encodeUserEndPoint(buf, endPointBytes);
        return buf;
    }

    private int getVersionTwoByteLength(byte[] endPointBytes) {
        return 24 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8 + 4 + endPointBytes.length;
    }

    protected void encodeUserEndPoint(ByteBuffer buf, byte[] endPointBytes) {
        if (endPointBytes != null) {
            buf.putInt(endPointBytes.length);
            buf.put(endPointBytes);
        }
    }

    private ByteBuffer encodeVersionThree() {
        byte[] endPointBytes = this.prepareUserEndPoint();
        ByteBuffer buf = ByteBuffer.allocate(this.getVersionThreeAndFourByteLength(endPointBytes));
        buf.putInt(3);
        buf.putInt(4);
        this.encodeClientUUID(buf);
        this.encodeTasks(buf, this.prevTasks);
        this.encodeTasks(buf, this.standbyTasks);
        this.encodeUserEndPoint(buf, endPointBytes);
        return buf;
    }

    private ByteBuffer encodeVersionFour() {
        byte[] endPointBytes = this.prepareUserEndPoint();
        ByteBuffer buf = ByteBuffer.allocate(this.getVersionThreeAndFourByteLength(endPointBytes));
        buf.putInt(4);
        buf.putInt(4);
        this.encodeClientUUID(buf);
        this.encodeTasks(buf, this.prevTasks);
        this.encodeTasks(buf, this.standbyTasks);
        this.encodeUserEndPoint(buf, endPointBytes);
        return buf;
    }

    protected int getVersionThreeAndFourByteLength(byte[] endPointBytes) {
        return 28 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8 + 4 + endPointBytes.length;
    }

    public static SubscriptionInfo decode(ByteBuffer data) {
        SubscriptionInfo subscriptionInfo;
        data.rewind();
        int usedVersion = data.getInt();
        switch (usedVersion) {
            case 1: {
                subscriptionInfo = new SubscriptionInfo(usedVersion, -1);
                SubscriptionInfo.decodeVersionOneData(subscriptionInfo, data);
                break;
            }
            case 2: {
                subscriptionInfo = new SubscriptionInfo(usedVersion, -1);
                SubscriptionInfo.decodeVersionTwoData(subscriptionInfo, data);
                break;
            }
            case 3: 
            case 4: {
                int latestSupportedVersion = data.getInt();
                subscriptionInfo = new SubscriptionInfo(usedVersion, latestSupportedVersion);
                SubscriptionInfo.decodeVersionThreeData(subscriptionInfo, data);
                break;
            }
            default: {
                int latestSupportedVersion = data.getInt();
                subscriptionInfo = new SubscriptionInfo(usedVersion, latestSupportedVersion);
                log.info("Unable to decode subscription data: used version: {}; latest supported version: {}", (Object)usedVersion, (Object)4);
            }
        }
        return subscriptionInfo;
    }

    private static void decodeVersionOneData(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        SubscriptionInfo.decodeClientUUID(subscriptionInfo, data);
        SubscriptionInfo.decodeTasks(subscriptionInfo, data);
    }

    private static void decodeClientUUID(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        subscriptionInfo.processId = new UUID(data.getLong(), data.getLong());
    }

    private static void decodeTasks(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        subscriptionInfo.prevTasks = new HashSet<TaskId>();
        int numPrevTasks = data.getInt();
        for (int i = 0; i < numPrevTasks; ++i) {
            subscriptionInfo.prevTasks.add(TaskId.readFrom(data));
        }
        subscriptionInfo.standbyTasks = new HashSet<TaskId>();
        int numStandbyTasks = data.getInt();
        for (int i = 0; i < numStandbyTasks; ++i) {
            subscriptionInfo.standbyTasks.add(TaskId.readFrom(data));
        }
    }

    private static void decodeVersionTwoData(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        SubscriptionInfo.decodeClientUUID(subscriptionInfo, data);
        SubscriptionInfo.decodeTasks(subscriptionInfo, data);
        SubscriptionInfo.decodeUserEndPoint(subscriptionInfo, data);
    }

    private static void decodeUserEndPoint(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        int bytesLength = data.getInt();
        if (bytesLength != 0) {
            byte[] bytes = new byte[bytesLength];
            data.get(bytes);
            subscriptionInfo.userEndPoint = new String(bytes, Charset.forName("UTF-8"));
        }
    }

    private static void decodeVersionThreeData(SubscriptionInfo subscriptionInfo, ByteBuffer data) {
        SubscriptionInfo.decodeClientUUID(subscriptionInfo, data);
        SubscriptionInfo.decodeTasks(subscriptionInfo, data);
        SubscriptionInfo.decodeUserEndPoint(subscriptionInfo, data);
    }

    public int hashCode() {
        int hashCode = this.usedVersion ^ this.latestSupportedVersion ^ this.processId.hashCode() ^ this.prevTasks.hashCode() ^ this.standbyTasks.hashCode();
        if (this.userEndPoint == null) {
            return hashCode;
        }
        return hashCode ^ this.userEndPoint.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SubscriptionInfo) {
            SubscriptionInfo other = (SubscriptionInfo)o;
            return this.usedVersion == other.usedVersion && this.latestSupportedVersion == other.latestSupportedVersion && this.processId.equals(other.processId) && this.prevTasks.equals(other.prevTasks) && this.standbyTasks.equals(other.standbyTasks) && this.userEndPoint != null ? this.userEndPoint.equals(other.userEndPoint) : other.userEndPoint == null;
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.usedVersion + ", supported version=" + this.latestSupportedVersion + ", process ID=" + this.processId + ", prev tasks=" + this.prevTasks + ", standby tasks=" + this.standbyTasks + ", user endpoint=" + this.userEndPoint + "]";
    }
}

