/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public final class StreamsTestUtils {
    private StreamsTestUtils() {
    }

    public static Properties getStreamsConfig(String applicationId, String bootstrapServers, String keySerdeClassName, String valueSerdeClassName, Properties additional) {
        Properties props = new Properties();
        props.put("application.id", applicationId);
        props.put("bootstrap.servers", bootstrapServers);
        props.put("default.key.serde", keySerdeClassName);
        props.put("default.value.serde", valueSerdeClassName);
        props.put("state.dir", TestUtils.tempDirectory().getPath());
        props.put("metrics.recording.level", Sensor.RecordingLevel.DEBUG.name);
        props.putAll((Map<?, ?>)additional);
        return props;
    }

    public static Properties getStreamsConfig(Serde keyDeserializer, Serde valueDeserializer) {
        return StreamsTestUtils.getStreamsConfig(UUID.randomUUID().toString(), "localhost:9091", keyDeserializer.getClass().getName(), valueDeserializer.getClass().getName(), new Properties());
    }

    public static Properties getStreamsConfig(String applicationId) {
        return StreamsTestUtils.getStreamsConfig(applicationId, "localhost:9091", Serdes.ByteArraySerde.class.getName(), Serdes.ByteArraySerde.class.getName(), new Properties());
    }

    public static Properties getStreamsConfig() {
        return StreamsTestUtils.getStreamsConfig(UUID.randomUUID().toString());
    }

    public static <K, V> List<KeyValue<K, V>> toList(Iterator<KeyValue<K, V>> iterator) {
        ArrayList<KeyValue<K, V>> results = new ArrayList<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }

    public static <K> void verifyKeyValueList(List<KeyValue<K, byte[]>> expected, List<KeyValue<K, byte[]>> actual) {
        MatcherAssert.assertThat((Object)actual.size(), (Matcher)CoreMatchers.equalTo((Object)expected.size()));
        for (int i = 0; i < actual.size(); ++i) {
            KeyValue<K, byte[]> expectedKv = expected.get(i);
            KeyValue<K, byte[]> actualKv = actual.get(i);
            MatcherAssert.assertThat((Object)actualKv.key, (Matcher)CoreMatchers.equalTo((Object)expectedKv.key));
            MatcherAssert.assertThat((Object)actualKv.value, (Matcher)CoreMatchers.equalTo((Object)expectedKv.value));
        }
    }

    public static void verifyWindowedKeyValue(KeyValue<Windowed<Bytes>, byte[]> actual, Windowed<Bytes> expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)((Windowed)actual.key).window(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.window()));
        MatcherAssert.assertThat((Object)((Windowed)actual.key).key(), (Matcher)CoreMatchers.equalTo((Object)expectedKey.key()));
        MatcherAssert.assertThat((Object)actual.value, (Matcher)CoreMatchers.equalTo((Object)expectedValue.getBytes()));
    }

    public static Metric getMetricByName(Map<MetricName, ? extends Metric> metrics, String name, String group) {
        Metric metric = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            if (!entry.getKey().name().equals(name) || !entry.getKey().group().equals(group)) continue;
            if (metric == null) {
                metric = entry.getValue();
                continue;
            }
            throw new IllegalStateException("Found two metrics with name=[" + name + "]: \n" + metric.metricName().toString() + " AND \n" + entry.getKey().toString());
        }
        if (metric == null) {
            throw new IllegalStateException("Didn't find metric with name=[" + name + "]");
        }
        return metric;
    }

    public static Metric getMetricByNameFilterByTags(Map<MetricName, ? extends Metric> metrics, String name, String group, Map<String, String> filterTags) {
        Metric metric = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            if (!entry.getKey().name().equals(name) || !entry.getKey().group().equals(group)) continue;
            boolean filtersMatch = true;
            for (Map.Entry<String, String> filter : filterTags.entrySet()) {
                if (filter.getValue().equals(entry.getKey().tags().get(filter.getKey()))) continue;
                filtersMatch = false;
            }
            if (!filtersMatch) continue;
            if (metric == null) {
                metric = entry.getValue();
                continue;
            }
            throw new IllegalStateException("Found two metrics with name=[" + name + "] and tags=[" + filterTags + "]: \n" + metric.metricName().toString() + " AND \n" + entry.getKey().toString());
        }
        if (metric == null) {
            throw new IllegalStateException("Didn't find metric with name=[" + name + "] and tags=[" + filterTags + "]");
        }
        return metric;
    }
}

