/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBSessionStoreTest {
    private SessionStore<String, Long> sessionStore;
    private InternalMockProcessorContext context;

    @Before
    public void before() {
        SessionKeySchema schema = new SessionKeySchema();
        schema.init("topic");
        RocksDBSegmentedBytesStore bytesStore = new RocksDBSegmentedBytesStore("session-store", "metrics-scope", 10000L, 60000L, (SegmentedBytesStore.KeySchema)schema);
        this.sessionStore = new RocksDBSessionStore((SegmentedBytesStore)bytesStore, Serdes.String(), Serdes.Long());
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.sessionStore.init((ProcessorContext)this.context, this.sessionStore);
    }

    @After
    public void close() {
        this.sessionStore.close();
    }

    @Test
    public void shouldPutAndFindSessionsInRange() {
        String key = "a";
        Windowed a1 = new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L));
        Windowed a2 = new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, (Object)1L);
        this.sessionStore.put(a2, (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)a1, (Object)1L), KeyValue.pair((Object)a2, (Object)2L));
        KeyValueIterator values = this.sessionStore.findSessions((Object)"a", 0L, 1000L);
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList(values));
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        List results = RocksDBSessionStoreTest.toList(this.sessionStore.fetch((Object)"a"));
        Assert.assertEquals(expected, results);
    }

    @Test
    public void shouldFindValuesWithinMergingSessionWindowRange() {
        String key = "a";
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L);
        KeyValueIterator results = this.sessionStore.findSessions((Object)"a", -1L, 1000L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L));
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList(results));
    }

    @Test
    public void shouldRemove() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)));
        Assert.assertFalse((boolean)this.sessionStore.findSessions((Object)"a", 0L, 1000L).hasNext());
        Assert.assertTrue((boolean)this.sessionStore.findSessions((Object)"a", 1500L, 2500L).hasNext());
    }

    @Test
    public void shouldFindSessionsToMerge() {
        Windowed session1 = new Windowed((Object)"a", (Window)new SessionWindow(0L, 100L));
        Windowed session2 = new Windowed((Object)"a", (Window)new SessionWindow(101L, 200L));
        Windowed session3 = new Windowed((Object)"a", (Window)new SessionWindow(201L, 300L));
        Windowed session4 = new Windowed((Object)"a", (Window)new SessionWindow(301L, 400L));
        Windowed session5 = new Windowed((Object)"a", (Window)new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, (Object)1L);
        this.sessionStore.put(session2, (Object)2L);
        this.sessionStore.put(session3, (Object)3L);
        this.sessionStore.put(session4, (Object)4L);
        this.sessionStore.put(session5, (Object)5L);
        KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 150L, 300L);
        Assert.assertEquals((Object)session2, (Object)((KeyValue)results.next()).key);
        Assert.assertEquals((Object)session3, (Object)((KeyValue)results.next()).key);
        Assert.assertFalse((boolean)results.hasNext());
    }

    @Test
    public void shouldFetchExactKeys() {
        RocksDBSegmentedBytesStore bytesStore = new RocksDBSegmentedBytesStore("session-store", "metrics-scope", 0x7A00000000000000L, 0x7A00000000000000L, (SegmentedBytesStore.KeySchema)new SessionKeySchema());
        this.sessionStore = new RocksDBSessionStore((SegmentedBytesStore)bytesStore, Serdes.String(), Serdes.Long());
        this.sessionStore.init((ProcessorContext)this.context, this.sessionStore);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(8791026472627208190L, 0x79FFFFFFFFFFFFFFL)), (Object)5L);
        KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", 0L, Long.MAX_VALUE);
        ArrayList<Object> results = new ArrayList<Object>();
        while (iterator.hasNext()) {
            results.add(((KeyValue)iterator.next()).value);
        }
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 3L, 5L)));
        iterator = this.sessionStore.findSessions((Object)"aa", 0L, Long.MAX_VALUE);
        results = new ArrayList();
        while (iterator.hasNext()) {
            results.add(((KeyValue)iterator.next()).value);
        }
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(2L, 4L)));
        KeyValueIterator rangeIterator = this.sessionStore.findSessions((Object)"a", (Object)"aa", 0L, Long.MAX_VALUE);
        ArrayList<Object> rangeResults = new ArrayList<Object>();
        while (rangeIterator.hasNext()) {
            rangeResults.add(((KeyValue)rangeIterator.next()).value);
        }
        MatcherAssert.assertThat(rangeResults, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 3L, 2L, 4L, 5L)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullKey() {
        this.sessionStore.findSessions(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullFromKey() {
        this.sessionStore.findSessions(null, (Object)"anyKeyTo", 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullToKey() {
        this.sessionStore.findSessions((Object)"anyKeyFrom", null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullFromKey() {
        this.sessionStore.fetch(null, (Object)"anyToKey");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullToKey() {
        this.sessionStore.fetch((Object)"anyFromKey", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        this.sessionStore.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRemoveNullKey() {
        this.sessionStore.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.sessionStore.put(null, (Object)1L);
    }

    static <K, V> List<KeyValue<Windowed<K>, V>> toList(KeyValueIterator<Windowed<K>, V> iterator) {
        ArrayList<KeyValue<Windowed<K>, V>> results = new ArrayList<KeyValue<Windowed<K>, V>>();
        while (iterator.hasNext()) {
            results.add((KeyValue<Windowed<K>, V>)iterator.next());
        }
        return results;
    }
}

