/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Test;

public class StoresTest {
    @Test(expected=NullPointerException.class)
    public void shouldThrowIfPersistentKeyValueStoreStoreNameIsNull() {
        Stores.persistentKeyValueStore(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIMemoryKeyValueStoreStoreNameIsNull() {
        Stores.inMemoryKeyValueStore(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfILruMapStoreNameIsNull() {
        Stores.lruMap(null, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfILruMapStoreCapacityIsNegative() {
        Stores.lruMap((String)"anyName", (int)-1);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIPersistentWindowStoreStoreNameIsNull() {
        Stores.persistentWindowStore(null, (Duration)Duration.ZERO, (Duration)Duration.ZERO, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreRetentionPeriodIsNegative() {
        Stores.persistentWindowStore((String)"anyName", (Duration)Duration.ofMillis(-1L), (Duration)Duration.ZERO, (boolean)false);
    }

    @Deprecated
    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreIfNumberOfSegmentsSmallerThanOne() {
        Stores.persistentWindowStore((String)"anyName", (long)0L, (int)1, (long)0L, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreIfWindowSizeIsNegative() {
        Stores.persistentWindowStore((String)"anyName", (Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(-1L), (boolean)false);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIPersistentSessionStoreStoreNameIsNull() {
        Stores.persistentSessionStore(null, (Duration)Duration.ofMillis(0L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentSessionStoreRetentionPeriodIsNegative() {
        Stores.persistentSessionStore((String)"anyName", (Duration)Duration.ofMillis(-1L));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForWindowStoreBuilder() {
        Stores.windowStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForKeyValueStoreBuilder() {
        Stores.keyValueStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForSessionStoreBuilder() {
        Stores.sessionStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray());
    }

    @Test
    public void shouldCreateInMemoryKeyValueStore() {
        MatcherAssert.assertThat((Object)Stores.inMemoryKeyValueStore((String)"memory").get(), (Matcher)IsInstanceOf.instanceOf(InMemoryKeyValueStore.class));
    }

    @Test
    public void shouldCreateMemoryNavigableCache() {
        MatcherAssert.assertThat((Object)Stores.lruMap((String)"map", (int)10).get(), (Matcher)IsInstanceOf.instanceOf(MemoryNavigableLRUCache.class));
    }

    @Test
    public void shouldCreateRocksDbStore() {
        MatcherAssert.assertThat((Object)Stores.persistentKeyValueStore((String)"store").get(), (Matcher)IsInstanceOf.instanceOf(RocksDBStore.class));
    }

    @Test
    public void shouldCreateRocksDbWindowStore() {
        MatcherAssert.assertThat((Object)Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)false).get(), (Matcher)IsInstanceOf.instanceOf(RocksDBWindowStore.class));
    }

    @Test
    public void shouldCreateRocksDbSessionStore() {
        MatcherAssert.assertThat((Object)Stores.persistentSessionStore((String)"store", (Duration)Duration.ofMillis(1L)).get(), (Matcher)IsInstanceOf.instanceOf(RocksDBSessionStore.class));
    }

    @Test
    public void shouldBuildWindowStore() {
        WindowStore store = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L), (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildKeyValueStore() {
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"name"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildSessionStore() {
        SessionStore store = (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)"name", (Duration)Duration.ofMillis(10L)), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }
}

