/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.junit.Assert;
import org.junit.Test;

public class StreamsMetricsImplTest {
    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        new StreamsMetricsImpl(null, "");
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String sensorName = "sensor1";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        Sensor sensor1 = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG);
        streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = streamsMetrics.addThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor3);
    }

    @Test
    public void testLatencyMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(defaultMetrics + 4 + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }

    @Test
    public void testThroughputMetrics() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "");
        int defaultMetrics = streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = streamsMetrics.addThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 4), (long)streamsMetrics.metrics().size());
        streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)streamsMetrics.metrics().size());
    }

    @Test
    public void testTotalMetricDoesntDecrease() {
        MockTime time = new MockTime(1L);
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS);
        Metrics metrics = new Metrics(config, (Time)time);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "");
        String scope = "scope";
        String entity = "entity";
        String operation = "op";
        Sensor sensor = streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "op", Sensor.RecordingLevel.INFO, new String[0]);
        double latency = 100.0;
        MetricName totalMetricName = metrics.metricName("op-total", "stream-scope-metrics", "", new String[]{"client-id", "", "scope-id", "entity"});
        KafkaMetric totalMetric = metrics.metric(totalMetricName);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)Math.round(totalMetric.measurable().measure(config, time.milliseconds())));
            sensor.record(100.0, time.milliseconds());
        }
    }
}

