/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorNodeTest {
    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringInit() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.init(null);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringClose() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.close();
    }

    @Test
    public void testMetrics() {
        StateSerdes anyStateSerde = StateSerdes.withBuiltinTypes((String)"anyName", Bytes.class, Bytes.class);
        Metrics metrics = new Metrics();
        InternalMockProcessorContext context = new InternalMockProcessorContext(anyStateSerde, (RecordCollector)new RecordCollectorImpl(null, new LogContext("processnode-test "), (ProductionExceptionHandler)new DefaultProductionExceptionHandler(), metrics.sensor("skipped-records")), metrics);
        ProcessorNode node = new ProcessorNode("name", (Processor)new NoOpProcessor(), Collections.emptySet());
        node.init((InternalProcessorContext)context);
        String[] latencyOperations = new String[]{"process", "punctuate", "create", "destroy"};
        String throughputOperation = "forward";
        String groupName = "stream-processor-node-metrics";
        LinkedHashMap<String, String> metricTags = new LinkedHashMap<String, String>();
        metricTags.put("processor-node-id", node.name());
        metricTags.put("task-id", context.taskId().toString());
        metricTags.put("client-id", "mock");
        for (String opName : latencyOperations) {
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-avg", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-max", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-rate", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-total", "stream-processor-node-metrics", metricTags);
        }
        Assert.assertNotNull(metrics.metrics().get(metrics.metricName("forward-rate", "stream-processor-node-metrics", "The average number of occurrence of forward operation per second.", metricTags)));
        metricTags.put("processor-node-id", "all");
        for (String opName : latencyOperations) {
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-avg", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-max", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-rate", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-total", "stream-processor-node-metrics", metricTags);
        }
        Assert.assertNotNull(metrics.metrics().get(metrics.metricName("forward-rate", "stream-processor-node-metrics", "The average number of occurrence of forward operation per second.", metricTags)));
    }

    private static class NoOpProcessor
    implements Processor<Object, Object> {
        private NoOpProcessor() {
        }

        public void init(ProcessorContext context) {
        }

        public void process(Object key, Object value) {
        }

        public void close() {
        }
    }

    private static class ExceptionalProcessor
    implements Processor {
        private ExceptionalProcessor() {
        }

        public void init(ProcessorContext context) {
            throw new RuntimeException();
        }

        public void process(Object key, Object value) {
            throw new RuntimeException();
        }

        public void close() {
            throw new RuntimeException();
        }
    }
}

