/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class InternalStreamsBuilderTest {
    private static final String APP_ID = "app-id";
    private final InternalStreamsBuilder builder = new InternalStreamsBuilder(new InternalTopologyBuilder());
    private final ConsumedInternal<String, String> consumed = new ConsumedInternal();
    private final String storePrefix = "prefix-";
    private final MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>> materialized = new MaterializedInternal(Materialized.as((String)"test-store"));

    public InternalStreamsBuilderTest() {
        this.materialized.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
    }

    @Test
    public void testNewName() {
        Assert.assertEquals((Object)"X-0000000000", (Object)this.builder.newProcessorName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)this.builder.newProcessorName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)this.builder.newProcessorName("Z-"));
        InternalStreamsBuilder newBuilder = new InternalStreamsBuilder(new InternalTopologyBuilder());
        Assert.assertEquals((Object)"X-0000000000", (Object)newBuilder.newProcessorName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)newBuilder.newProcessorName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)newBuilder.newProcessorName("Z-"));
    }

    @Test
    public void testNewStoreName() {
        Assert.assertEquals((Object)"X-STATE-STORE-0000000000", (Object)this.builder.newStoreName("X-"));
        Assert.assertEquals((Object)"Y-STATE-STORE-0000000001", (Object)this.builder.newStoreName("Y-"));
        Assert.assertEquals((Object)"Z-STATE-STORE-0000000002", (Object)this.builder.newStoreName("Z-"));
        InternalStreamsBuilder newBuilder = new InternalStreamsBuilder(new InternalTopologyBuilder());
        Assert.assertEquals((Object)"X-STATE-STORE-0000000000", (Object)newBuilder.newStoreName("X-"));
        Assert.assertEquals((Object)"Y-STATE-STORE-0000000001", (Object)newBuilder.newStoreName("Y-"));
        Assert.assertEquals((Object)"Z-STATE-STORE-0000000002", (Object)newBuilder.newStoreName("Z-"));
    }

    @Test
    public void shouldHaveCorrectSourceTopicsForTableFromMergedStream() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        KStream source1 = this.builder.stream(Collections.singleton("topic-1"), this.consumed);
        KStream source2 = this.builder.stream(Collections.singleton("topic-2"), this.consumed);
        KStream source3 = this.builder.stream(Collections.singleton("topic-3"), this.consumed);
        KStream processedSource1 = source1.mapValues((ValueMapper)new ValueMapper<String, String>(){

            public String apply(String value) {
                return value;
            }
        }).filter((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream processedSource2 = source2.filter((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream merged = processedSource1.merge(processedSource2).merge(source3);
        merged.groupByKey().count(Materialized.as((String)"my-table"));
        this.builder.buildAndOptimizeTopology();
        Map actual = this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics();
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"topic-1", "topic-2", "topic-3"}), actual.get("my-table"));
    }

    @Test
    public void shouldStillMaterializeSourceKTableIfMaterializedIsntQueryable() {
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.with(null, null));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        KTable table1 = this.builder.table("topic2", this.consumed, materializedInternal);
        this.builder.buildAndOptimizeTopology();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).build(null);
        Assert.assertEquals((long)1L, (long)topology.stateStores().size());
        String storeName = "prefix-STATE-STORE-0000000000";
        Assert.assertEquals((Object)"prefix-STATE-STORE-0000000000", (Object)((StateStore)topology.stateStores().get(0)).name());
        Assert.assertEquals((long)1L, (long)topology.storeToChangelogTopic().size());
        Assert.assertEquals((Object)"app-id-prefix-STATE-STORE-0000000000-changelog", topology.storeToChangelogTopic().get("prefix-STATE-STORE-0000000000"));
        Assert.assertNull((Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildGlobalTableWithNonQueryableStoreName() {
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.with(null, null));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        GlobalKTable table1 = this.builder.globalTable("topic2", this.consumed, materializedInternal);
        Assert.assertNull((Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildGlobalTableWithQueryaIbleStoreName() {
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.as((String)"globalTable"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        GlobalKTable table1 = this.builder.globalTable("topic2", this.consumed, materializedInternal);
        Assert.assertEquals((Object)"globalTable", (Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildSimpleGlobalTableTopology() {
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.as((String)"globalTable"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        this.builder.globalTable("table", this.consumed, materializedInternal);
        this.builder.buildAndOptimizeTopology();
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).buildGlobalStateTopology();
        List stateStores = topology.globalStateStores();
        Assert.assertEquals((long)1L, (long)stateStores.size());
        Assert.assertEquals((Object)"globalTable", (Object)((StateStore)stateStores.get(0)).name());
    }

    private void doBuildGlobalTopologyWithAllGlobalTables() {
        ProcessorTopology topology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).buildGlobalStateTopology();
        List stateStores = topology.globalStateStores();
        Set sourceTopics = topology.sourceTopics();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"table", "table2"}), (Object)sourceTopics);
        Assert.assertEquals((long)2L, (long)stateStores.size());
    }

    @Test
    public void shouldBuildGlobalTopologyWithAllGlobalTables() {
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.as((String)"global1"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        this.builder.globalTable("table", this.consumed, materializedInternal);
        materializedInternal = new MaterializedInternal(Materialized.as((String)"global2"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        this.builder.globalTable("table2", this.consumed, materializedInternal);
        this.builder.buildAndOptimizeTopology();
        this.doBuildGlobalTopologyWithAllGlobalTables();
    }

    @Test
    public void shouldAddGlobalTablesToEachGroup() {
        String one = "globalTable";
        String two = "globalTable2";
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.as((String)"globalTable"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        GlobalKTable globalTable = this.builder.globalTable("table", this.consumed, materializedInternal);
        MaterializedInternal materializedInternal2 = new MaterializedInternal(Materialized.as((String)"globalTable2"));
        materializedInternal2.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        GlobalKTable globalTable2 = this.builder.globalTable("table2", this.consumed, materializedInternal2);
        MaterializedInternal materializedInternalNotGlobal = new MaterializedInternal(Materialized.as((String)"not-global"));
        materializedInternalNotGlobal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        this.builder.table("not-global", this.consumed, materializedInternalNotGlobal);
        KeyValueMapper kvMapper = (key, value) -> value;
        KStream stream = this.builder.stream(Collections.singleton("t1"), this.consumed);
        stream.leftJoin(globalTable, kvMapper, MockValueJoiner.TOSTRING_JOINER);
        KStream stream2 = this.builder.stream(Collections.singleton("t2"), this.consumed);
        stream2.leftJoin(globalTable2, kvMapper, MockValueJoiner.TOSTRING_JOINER);
        Map nodeGroups = this.builder.internalTopologyBuilder.nodeGroups();
        for (Integer groupId : nodeGroups.keySet()) {
            ProcessorTopology topology = this.builder.internalTopologyBuilder.build(groupId);
            List stateStores = topology.globalStateStores();
            HashSet<String> names = new HashSet<String>();
            for (StateStore stateStore : stateStores) {
                names.add(stateStore.name());
            }
            Assert.assertEquals((long)2L, (long)stateStores.size());
            Assert.assertTrue((boolean)names.contains("globalTable"));
            Assert.assertTrue((boolean)names.contains("globalTable2"));
        }
    }

    @Test
    public void shouldMapStateStoresToCorrectSourceTopics() {
        KStream playEvents = this.builder.stream(Collections.singleton("events"), this.consumed);
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.as((String)"table-store"));
        materializedInternal.generateStoreNameIfNeeded((InternalNameProvider)this.builder, "prefix-");
        KTable table = this.builder.table("table-topic", this.consumed, materializedInternal);
        KStream mapped = playEvents.map(MockMapper.selectValueKeyValueMapper());
        mapped.leftJoin(table, MockValueJoiner.TOSTRING_JOINER).groupByKey().count(Materialized.as((String)"count"));
        this.builder.buildAndOptimizeTopology();
        this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID)));
        Assert.assertEquals(Collections.singletonList("table-topic"), this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics().get("table-store"));
        Assert.assertEquals(Collections.singletonList("app-id-KSTREAM-MAP-0000000003-repartition"), this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics().get("count"));
    }

    @Test
    public void shouldAddTopicToEarliestAutoOffsetResetList() {
        String topicName = "topic-1";
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream(Collections.singleton("topic-1"), consumed);
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTopicToLatestAutoOffsetResetList() {
        String topicName = "topic-1";
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST));
        this.builder.stream(Collections.singleton("topic-1"), consumed);
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTableToEarliestAutoOffsetResetList() {
        String topicName = "topic-1";
        this.builder.table("topic-1", new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST)), this.materialized);
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTableToLatestAutoOffsetResetList() {
        String topicName = "topic-1";
        this.builder.table("topic-1", new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST)), this.materialized);
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldNotAddTableToOffsetResetLists() {
        String topicName = "topic-1";
        this.builder.table("topic-1", this.consumed, this.materialized);
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldNotAddRegexTopicsToOffsetResetLists() {
        Pattern topicPattern = Pattern.compile("topic-\\d");
        String topic = "topic-5";
        this.builder.stream(topicPattern, this.consumed);
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-5").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-5").matches());
    }

    @Test
    public void shouldAddRegexTopicToEarliestAutoOffsetResetList() {
        Pattern topicPattern = Pattern.compile("topic-\\d+");
        String topicTwo = "topic-500000";
        this.builder.stream(topicPattern, new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST)));
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-500000").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-500000").matches());
    }

    @Test
    public void shouldAddRegexTopicToLatestAutoOffsetResetList() {
        Pattern topicPattern = Pattern.compile("topic-\\d+");
        String topicTwo = "topic-1000000";
        this.builder.stream(topicPattern, new ConsumedInternal(Consumed.with((Topology.AutoOffsetReset)Topology.AutoOffsetReset.LATEST)));
        this.builder.buildAndOptimizeTopology();
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1000000").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1000000").matches());
    }

    @Test
    public void shouldHaveNullTimestampExtractorWhenNoneSupplied() {
        this.builder.stream(Collections.singleton("topic"), this.consumed);
        this.builder.buildAndOptimizeTopology();
        this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID)));
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.build(null);
        Assert.assertNull((Object)processorTopology.source("topic").getTimestampExtractor());
    }

    @Test
    public void shouldUseProvidedTimestampExtractor() {
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with((TimestampExtractor)new MockTimestampExtractor()));
        this.builder.stream(Collections.singleton("topic"), consumed);
        this.builder.buildAndOptimizeTopology();
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).build(null);
        Assert.assertThat((Object)processorTopology.source("topic").getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void ktableShouldHaveNullTimestampExtractorWhenNoneSupplied() {
        this.builder.table("topic", this.consumed, this.materialized);
        this.builder.buildAndOptimizeTopology();
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).build(null);
        Assert.assertNull((Object)processorTopology.source("topic").getTimestampExtractor());
    }

    @Test
    public void ktableShouldUseProvidedTimestampExtractor() {
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with((TimestampExtractor)new MockTimestampExtractor()));
        this.builder.table("topic", consumed, this.materialized);
        this.builder.buildAndOptimizeTopology();
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.rewriteTopology(new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APP_ID))).build(null);
        Assert.assertThat((Object)processorTopology.source("topic").getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    public static InternalTopologyBuilder internalTopologyBuilder(InternalStreamsBuilder internalStreamsBuilder) {
        return internalStreamsBuilder.internalTopologyBuilder;
    }
}

