/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WindowKeySchemaTest {
    private final String key = "key";
    private final String topic = "topic";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Serde<String> serde = Serdes.String();
    private final Window window = new TimeWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final WindowKeySchema windowKeySchema = new WindowKeySchema();
    private final Serde<Windowed<String>> keySerde = new WindowedSerdes.TimeWindowedSerde(this.serde);
    private final StateSerdes<String, byte[]> stateSerdes = new StateSerdes("dummy", this.serde, Serdes.ByteArray());

    @Before
    public void before() {
        this.windowKeySchema.init("topic");
    }

    @Test
    public void testHasNextConditionUsingNullKeys() {
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new TimeWindow(0L, 1L)), (int)0), (Object)1), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new TimeWindow(0L, 1L)), (int)0), (Object)2), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new TimeWindow(0L, 1L)), (int)0), (Object)3), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new TimeWindow(10L, 20L)), (int)4), (Object)4), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new TimeWindow(10L, 20L)), (int)5), (Object)5), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new TimeWindow(10L, 20L)), (int)6), (Object)6));
        DelegatingPeekingKeyValueIterator iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));
        HasNextCondition hasNextCondition = this.windowKeySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE);
        ArrayList<Object> results = new ArrayList<Object>();
        while (hasNextCondition.hasNext((KeyValueIterator)iterator)) {
            results.add(iterator.next().value);
        }
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testUpperBoundWithLargeTimestamps() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, -113}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, -113, -97}, (long)Long.MAX_VALUE, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerAndSmallerThanFirstTimestampByte() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{12, 12, 9}), 0xAFFFFFFFFFFFFFFL);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{12, 12}, (long)0xAFFFFFFFFFFFFFFL, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() {
        Bytes upper = this.windowKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11, 12}, (long)0L, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundWithMonZeroTimestamp() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 42L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() {
        Bytes lower = this.windowKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0x7FFFFFFFFFFFFFFEL);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, (long)0x7FFFFFFFFFFFFFFEL, (int)0)) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)WindowKeySchema.toStoreKeyBinary((byte[])new byte[]{10, 11, 12}, (long)0L, (int)0)));
    }

    @Test
    public void shouldSerializeDeserialize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = (Windowed)this.keySerde.deserializer().deserialize("topic", bytes);
        Assert.assertEquals((Object)new Windowed((Object)"key", (Window)new TimeWindow(50L, Long.MAX_VALUE)), (Object)result);
    }

    @Test
    public void testSerializeDeserializeOverflowWindowSize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = new TimeWindowedDeserializer(this.serde.deserializer(), 0x7FFFFFFFFFFFFFFEL).deserialize("topic", bytes);
        Assert.assertEquals((Object)new Windowed((Object)"key", (Window)new TimeWindow(50L, Long.MAX_VALUE)), (Object)result);
    }

    @Test
    public void shouldSerializeDeserializeExpectedWindowSize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = new TimeWindowedDeserializer(this.serde.deserializer(), 50L).deserialize("topic", bytes);
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldSerializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.serializer().serialize("topic", null));
    }

    @Test
    public void shouldDeSerializeEmtpyByteArrayToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @Test
    public void shouldDeSerializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Windowed result = WindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, this.stateSerdes);
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldExtractEndTimeFromBinary() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((long)0L, (long)WindowKeySchema.extractStoreSequence((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((long)50L, (long)WindowKeySchema.extractStoreTimestamp((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractWindowFromBindary() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals((Object)this.window, (Object)WindowKeySchema.extractStoreWindow((byte[])serialized.get(), (long)50L));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])WindowKeySchema.extractStoreKeyBytes((byte[])serialized.get()));
    }

    @Test
    public void shouldExtractKeyFromBinary() {
        Bytes serialized = WindowKeySchema.toStoreKeyBinary(this.windowedKey, (int)0, this.stateSerdes);
        Assert.assertEquals(this.windowedKey, (Object)WindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, this.stateSerdes));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Windowed windowedBytesKey = new Windowed((Object)Bytes.wrap((byte[])"key".getBytes()), this.window);
        Bytes serialized = WindowKeySchema.toStoreKeyBinary((Windowed)windowedBytesKey, (int)0);
        Assert.assertEquals((Object)windowedBytesKey, (Object)WindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L));
    }
}

