/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.testutil;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LogCaptureAppender
extends AppenderSkeleton {
    private final LinkedList<LoggingEvent> events = new LinkedList();

    public static LogCaptureAppender createAndRegister() {
        LogCaptureAppender logCaptureAppender = new LogCaptureAppender();
        Logger.getRootLogger().addAppender((Appender)logCaptureAppender);
        return logCaptureAppender;
    }

    public static void unregister(LogCaptureAppender logCaptureAppender) {
        Logger.getRootLogger().removeAppender((Appender)logCaptureAppender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        LinkedList<LoggingEvent> linkedList = this.events;
        synchronized (linkedList) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages() {
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<LoggingEvent> linkedList = this.events;
        synchronized (linkedList) {
            for (LoggingEvent event : this.events) {
                result.add(event.getRenderedMessage());
            }
        }
        return result;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

