/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorTopologyTest {
    private static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    private static final Deserializer<String> STRING_DESERIALIZER = new StringDeserializer();
    private static final String INPUT_TOPIC_1 = "input-topic-1";
    private static final String INPUT_TOPIC_2 = "input-topic-2";
    private static final String OUTPUT_TOPIC_1 = "output-topic-1";
    private static final String OUTPUT_TOPIC_2 = "output-topic-2";
    private static final String THROUGH_TOPIC_1 = "through-topic-1";
    private static final Header HEADER = new RecordHeader("key", "value".getBytes());
    private static final Headers HEADERS = new RecordHeaders(new Header[]{HEADER});
    private final TopologyWrapper topology = new TopologyWrapper();
    private final MockProcessorSupplier mockProcessorSupplier = new MockProcessorSupplier();
    private final ConsumerRecordFactory<String, String> recordFactory = new ConsumerRecordFactory(STRING_SERIALIZER, STRING_SERIALIZER, 0L);
    private TopologyTestDriver driver;
    private final Properties props = new Properties();

    @Before
    public void setup() {
        File localState = TestUtils.tempDirectory();
        this.props.setProperty("application.id", "processor-topology-test");
        this.props.setProperty("bootstrap.servers", "localhost:9091");
        this.props.setProperty("state.dir", localState.getAbsolutePath());
        this.props.setProperty("default.key.serde", Serdes.String().getClass().getName());
        this.props.setProperty("default.value.serde", Serdes.String().getClass().getName());
        this.props.setProperty("default.timestamp.extractor", CustomTimestampExtractor.class.getName());
    }

    @After
    public void cleanup() {
        this.props.clear();
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testTopologyMetadata() {
        this.topology.setApplicationId("X");
        this.topology.addSource("source-1", new String[]{"topic-1"});
        this.topology.addSource("source-2", new String[]{"topic-2", "topic-3"});
        this.topology.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        this.topology.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-1", "source-2"});
        this.topology.addSink("sink-1", "topic-3", new String[]{"processor-1"});
        this.topology.addSink("sink-2", "topic-4", new String[]{"processor-1", "processor-2"});
        ProcessorTopology processorTopology = this.topology.getInternalBuilder().build();
        Assert.assertEquals((long)6L, (long)processorTopology.processors().size());
        Assert.assertEquals((long)2L, (long)processorTopology.sources().size());
        Assert.assertEquals((long)3L, (long)processorTopology.sourceTopics().size());
        Assert.assertNotNull((Object)processorTopology.source("topic-1"));
        Assert.assertNotNull((Object)processorTopology.source("topic-2"));
        Assert.assertNotNull((Object)processorTopology.source("topic-3"));
        Assert.assertEquals((Object)processorTopology.source("topic-2"), (Object)processorTopology.source("topic-3"));
    }

    @Test
    public void testDrivingSimpleTopology() {
        int partition = 10;
        this.driver = new TopologyTestDriver(this.createSimpleTopology(partition), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key4", (Object)"value4"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key5", (Object)"value5"));
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", partition);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4", partition);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5", partition);
    }

    @Test
    public void testDrivingMultiplexingTopology() {
        this.driver = new TopologyTestDriver(this.createMultiplexingTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key1", "value1(2)");
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2(2)");
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key4", (Object)"value4"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key5", (Object)"value5"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key3", "value3(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key4", "value4(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key5", "value5(2)");
    }

    @Test
    public void testDrivingMultiplexByNameTopology() {
        this.driver = new TopologyTestDriver(this.createMultiplexByNameTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key1", "value1(2)");
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2(2)");
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key4", (Object)"value4"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key5", (Object)"value5"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key3", "value3(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key4", "value4(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key5", "value5(2)");
    }

    @Test
    public void testDrivingStatefulTopology() {
        String storeName = "entries";
        this.driver = new TopologyTestDriver(this.createStatefulTopology(storeName), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value4"));
        this.assertNoOutputRecord(OUTPUT_TOPIC_1);
        KeyValueStore store = this.driver.getKeyValueStore(storeName);
        Assert.assertEquals((Object)"value4", (Object)store.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)store.get((Object)"key2"));
        Assert.assertEquals((Object)"value3", (Object)store.get((Object)"key3"));
        Assert.assertNull((Object)store.get((Object)"key4"));
    }

    @Test
    public void shouldDriveGlobalStore() {
        String storeName = "my-store";
        String global = "global";
        String topic = "topic";
        this.topology.addGlobalStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).withLoggingDisabled(), "global", STRING_DESERIALIZER, STRING_DESERIALIZER, "topic", "processor", this.define((Processor)new StatefulProcessor("my-store")));
        this.driver = new TopologyTestDriver((Topology)this.topology, this.props);
        KeyValueStore globalStore = this.driver.getKeyValueStore("my-store");
        this.driver.pipeInput(this.recordFactory.create("topic", (Object)"key1", (Object)"value1"));
        this.driver.pipeInput(this.recordFactory.create("topic", (Object)"key2", (Object)"value2"));
        Assert.assertEquals((Object)"value1", (Object)globalStore.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)globalStore.get((Object)"key2"));
    }

    @Test
    public void testDrivingSimpleMultiSourceTopology() {
        int partition = 10;
        this.driver = new TopologyTestDriver(this.createSimpleMultiSourceTopology(10), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", 10);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_2, (Object)"key2", (Object)"value2"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2", 10);
        this.assertNoOutputRecord(OUTPUT_TOPIC_1);
    }

    @Test
    public void testDrivingForwardToSourceTopology() {
        this.driver = new TopologyTestDriver(this.createForwardToSourceTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key1", "value1");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key3", "value3");
    }

    @Test
    public void testDrivingInternalRepartitioningTopology() {
        this.driver = new TopologyTestDriver(this.createInternalRepartitioningTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3"));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3");
    }

    @Test
    public void testDrivingInternalRepartitioningForwardingTimestampTopology() {
        this.driver = new TopologyTestDriver(this.createInternalRepartitioningWithValueTimestampTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1@1000"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2@2000"));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3@3000"));
        MatcherAssert.assertThat((Object)this.driver.readOutput(OUTPUT_TOPIC_1, STRING_DESERIALIZER, STRING_DESERIALIZER), (Matcher)CoreMatchers.equalTo((Object)new ProducerRecord(OUTPUT_TOPIC_1, null, Long.valueOf(1000L), (Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)this.driver.readOutput(OUTPUT_TOPIC_1, STRING_DESERIALIZER, STRING_DESERIALIZER), (Matcher)CoreMatchers.equalTo((Object)new ProducerRecord(OUTPUT_TOPIC_1, null, Long.valueOf(2000L), (Object)"key2", (Object)"value2")));
        MatcherAssert.assertThat((Object)this.driver.readOutput(OUTPUT_TOPIC_1, STRING_DESERIALIZER, STRING_DESERIALIZER), (Matcher)CoreMatchers.equalTo((Object)new ProducerRecord(OUTPUT_TOPIC_1, null, Long.valueOf(3000L), (Object)"key3", (Object)"value3")));
    }

    @Test
    public void shouldCreateStringWithSourceAndTopics() {
        this.topology.addSource("source", new String[]{"topic1", "topic2"});
        ProcessorTopology processorTopology = this.topology.getInternalBuilder().build();
        String result = processorTopology.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"source:\n\t\ttopics:\t\t[topic1, topic2]\n"));
    }

    @Test
    public void shouldCreateStringWithMultipleSourcesAndTopics() {
        this.topology.addSource("source", new String[]{"topic1", "topic2"});
        this.topology.addSource("source2", new String[]{"t", "t1", "t2"});
        ProcessorTopology processorTopology = this.topology.getInternalBuilder().build();
        String result = processorTopology.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"source:\n\t\ttopics:\t\t[topic1, topic2]\n"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"source2:\n\t\ttopics:\t\t[t, t1, t2]\n"));
    }

    @Test
    public void shouldCreateStringWithProcessors() {
        this.topology.addSource("source", new String[]{"t"}).addProcessor("processor", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"source"}).addProcessor("other", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"source"});
        ProcessorTopology processorTopology = this.topology.getInternalBuilder().build();
        String result = processorTopology.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"\t\tchildren:\t[processor, other]"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"processor:\n"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"other:\n"));
    }

    @Test
    public void shouldRecursivelyPrintChildren() {
        this.topology.addSource("source", new String[]{"t"}).addProcessor("processor", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"source"}).addProcessor("child-one", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"processor"}).addProcessor("child-one-one", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"child-one"}).addProcessor("child-two", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"processor"}).addProcessor("child-two-one", (ProcessorSupplier)this.mockProcessorSupplier, new String[]{"child-two"});
        String result = this.topology.getInternalBuilder().build().toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"child-one:\n\t\tchildren:\t[child-one-one]"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"child-two:\n\t\tchildren:\t[child-two-one]"));
    }

    @Test
    public void shouldConsiderTimeStamps() {
        int partition = 10;
        this.driver = new TopologyTestDriver(this.createSimpleTopology(10), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1", 10L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2", 20L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3", 30L));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", 10, (Long)10L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", 10, (Long)20L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", 10, (Long)30L);
    }

    @Test
    public void shouldConsiderModifiedTimeStamps() {
        int partition = 10;
        this.driver = new TopologyTestDriver(this.createTimestampTopology(10), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1", 10L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2", 20L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3", 30L));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", 10, (Long)20L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", 10, (Long)30L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", 10, (Long)40L);
    }

    @Test
    public void shouldConsiderHeaders() {
        int partition = 10;
        this.driver = new TopologyTestDriver(this.createSimpleTopology(10), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1", HEADERS, 10L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2", HEADERS, 20L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3", HEADERS, 30L));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", HEADERS, 10, 10L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", HEADERS, 10, 20L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", HEADERS, 10, 30L);
    }

    @Test
    public void shouldAddHeaders() {
        this.driver = new TopologyTestDriver(this.createAddHeaderTopology(), this.props);
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key1", (Object)"value1", 10L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key2", (Object)"value2", 20L));
        this.driver.pipeInput(this.recordFactory.create(INPUT_TOPIC_1, (Object)"key3", (Object)"value3", 30L));
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", HEADERS, (Long)10L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", HEADERS, (Long)20L);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", HEADERS, (Long)30L);
    }

    private void assertNextOutputRecord(String topic, String key, String value) {
        this.assertNextOutputRecord(topic, key, value, (Integer)null, (Long)0L);
    }

    private void assertNextOutputRecord(String topic, String key, String value, Integer partition) {
        this.assertNextOutputRecord(topic, key, value, partition, (Long)0L);
    }

    private void assertNextOutputRecord(String topic, String key, String value, Headers headers, Long timestamp) {
        this.assertNextOutputRecord(topic, key, value, headers, null, timestamp);
    }

    private void assertNextOutputRecord(String topic, String key, String value, Integer partition, Long timestamp) {
        this.assertNextOutputRecord(topic, key, value, (Headers)new RecordHeaders(), partition, timestamp);
    }

    private void assertNextOutputRecord(String topic, String key, String value, Headers headers, Integer partition, Long timestamp) {
        ProducerRecord record = this.driver.readOutput(topic, STRING_DESERIALIZER, STRING_DESERIALIZER);
        Assert.assertEquals((Object)topic, (Object)record.topic());
        Assert.assertEquals((Object)key, (Object)record.key());
        Assert.assertEquals((Object)value, (Object)record.value());
        Assert.assertEquals((Object)partition, (Object)record.partition());
        Assert.assertEquals((Object)timestamp, (Object)record.timestamp());
        Assert.assertEquals((Object)headers, (Object)record.headers());
    }

    private void assertNoOutputRecord(String topic) {
        Assert.assertNull((Object)this.driver.readOutput(topic));
    }

    private StreamPartitioner<Object, Object> constantPartitioner(final Integer partition) {
        return new StreamPartitioner<Object, Object>(){

            public Integer partition(String topic, Object key, Object value, int numPartitions) {
                return partition;
            }
        };
    }

    private Topology createSimpleTopology(int partition) {
        return this.topology.addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new ForwardingProcessor()), new String[]{"source"}).addSink("sink", OUTPUT_TOPIC_1, this.constantPartitioner(partition), new String[]{"processor"});
    }

    private Topology createTimestampTopology(int partition) {
        return this.topology.addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new TimestampProcessor()), new String[]{"source"}).addSink("sink", OUTPUT_TOPIC_1, this.constantPartitioner(partition), new String[]{"processor"});
    }

    private Topology createMultiplexingTopology() {
        return this.topology.addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new MultiplexingProcessor(2)), new String[]{"source"}).addSink("sink1", OUTPUT_TOPIC_1, new String[]{"processor"}).addSink("sink2", OUTPUT_TOPIC_2, new String[]{"processor"});
    }

    private Topology createMultiplexByNameTopology() {
        return this.topology.addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new MultiplexByNameProcessor(2)), new String[]{"source"}).addSink("sink0", OUTPUT_TOPIC_1, new String[]{"processor"}).addSink("sink1", OUTPUT_TOPIC_2, new String[]{"processor"});
    }

    private Topology createStatefulTopology(String storeName) {
        return this.topology.addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new StatefulProcessor(storeName)), new String[]{"source"}).addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)storeName), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"processor"}).addSink("counts", OUTPUT_TOPIC_1, new String[]{"processor"});
    }

    private Topology createInternalRepartitioningTopology() {
        this.topology.addSource("source", new String[]{INPUT_TOPIC_1}).addSink("sink0", THROUGH_TOPIC_1, new String[]{"source"}).addSource("source1", new String[]{THROUGH_TOPIC_1}).addSink("sink1", OUTPUT_TOPIC_1, new String[]{"source1"});
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(this.topology);
        internalTopologyBuilder.addInternalTopic(THROUGH_TOPIC_1);
        return this.topology;
    }

    private Topology createInternalRepartitioningWithValueTimestampTopology() {
        this.topology.addSource("source", new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new ValueTimestampProcessor()), new String[]{"source"}).addSink("sink0", THROUGH_TOPIC_1, new String[]{"processor"}).addSource("source1", new String[]{THROUGH_TOPIC_1}).addSink("sink1", OUTPUT_TOPIC_1, new String[]{"source1"});
        InternalTopologyBuilder internalTopologyBuilder = TopologyWrapper.getInternalTopologyBuilder(this.topology);
        internalTopologyBuilder.addInternalTopic(THROUGH_TOPIC_1);
        return this.topology;
    }

    private Topology createForwardToSourceTopology() {
        return this.topology.addSource("source-1", new String[]{INPUT_TOPIC_1}).addSink("sink-1", OUTPUT_TOPIC_1, new String[]{"source-1"}).addSource("source-2", new String[]{OUTPUT_TOPIC_1}).addSink("sink-2", OUTPUT_TOPIC_2, new String[]{"source-2"});
    }

    private Topology createSimpleMultiSourceTopology(int partition) {
        return this.topology.addSource("source-1", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor-1", this.define((Processor)new ForwardingProcessor()), new String[]{"source-1"}).addSink("sink-1", OUTPUT_TOPIC_1, this.constantPartitioner(partition), new String[]{"processor-1"}).addSource("source-2", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_2}).addProcessor("processor-2", this.define((Processor)new ForwardingProcessor()), new String[]{"source-2"}).addSink("sink-2", OUTPUT_TOPIC_2, this.constantPartitioner(partition), new String[]{"processor-2"});
    }

    private Topology createAddHeaderTopology() {
        return this.topology.addSource("source-1", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor-1", this.define((Processor)new AddHeaderProcessor()), new String[]{"source-1"}).addSink("sink-1", OUTPUT_TOPIC_1, new String[]{"processor-1"});
    }

    private <K, V> ProcessorSupplier<K, V> define(final Processor<K, V> processor) {
        return new ProcessorSupplier<K, V>(){

            public Processor<K, V> get() {
                return processor;
            }
        };
    }

    public static class CustomTimestampExtractor
    implements TimestampExtractor {
        private static final long DEFAULT_TIMESTAMP = 1000L;

        public long extract(ConsumerRecord<Object, Object> record, long previousTimestamp) {
            if (record.value().toString().matches(".*@[0-9]+")) {
                return Long.parseLong(record.value().toString().split("@")[1]);
            }
            if (record.timestamp() >= 0L) {
                return record.timestamp();
            }
            return 1000L;
        }
    }

    protected static class StatefulProcessor
    extends AbstractProcessor<String, String> {
        private KeyValueStore<String, String> store;
        private final String storeName;

        StatefulProcessor(String storeName) {
            this.storeName = storeName;
        }

        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(this.storeName);
        }

        public void process(String key, String value) {
            this.store.put((Object)key, (Object)value);
        }

        public void close() {
            this.store.close();
        }
    }

    protected static class MultiplexByNameProcessor
    extends AbstractProcessor<String, String> {
        private final int numChildren;

        MultiplexByNameProcessor(int numChildren) {
            this.numChildren = numChildren;
        }

        public void process(String key, String value) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)key, (Object)(value + "(" + (i + 1) + ")"), "sink" + i);
            }
        }
    }

    protected static class MultiplexingProcessor
    extends AbstractProcessor<String, String> {
        private final int numChildren;

        MultiplexingProcessor(int numChildren) {
            this.numChildren = numChildren;
        }

        public void process(String key, String value) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)key, (Object)(value + "(" + (i + 1) + ")"), i);
            }
        }
    }

    protected static class ValueTimestampProcessor
    extends AbstractProcessor<String, String> {
        protected ValueTimestampProcessor() {
        }

        public void process(String key, String value) {
            this.context().forward((Object)key, (Object)value.split("@")[0]);
        }
    }

    protected static class AddHeaderProcessor
    extends AbstractProcessor<String, String> {
        protected AddHeaderProcessor() {
        }

        public void process(String key, String value) {
            this.context().headers().add(HEADER);
            this.context().forward((Object)key, (Object)value);
        }
    }

    protected static class TimestampProcessor
    extends AbstractProcessor<String, String> {
        protected TimestampProcessor() {
        }

        public void process(String key, String value) {
            this.context().forward((Object)key, (Object)value, To.all().withTimestamp(this.context().timestamp() + 10L));
        }
    }

    protected static class ForwardingProcessor
    extends AbstractProcessor<String, String> {
        protected ForwardingProcessor() {
        }

        public void process(String key, String value) {
            this.context().forward((Object)key, (Object)value);
        }
    }
}

